/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ArrowShape;
import cytoscape.visual.LineStyle;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.customgraphic.CyCustomGraphics;
import cytoscape.visual.ui.editors.discrete.CyColorPropertyEditor;
import cytoscape.visual.ui.editors.discrete.CyComboBoxPropertyEditor;
import cytoscape.visual.ui.editors.discrete.CyCustomGraphicsEditor;
import cytoscape.visual.ui.editors.discrete.CyDoublePropertyEditor;
import cytoscape.visual.ui.editors.discrete.CyFontPropertyEditor;
import cytoscape.visual.ui.editors.discrete.CyObjectPositionPropertyEditor;
import cytoscape.visual.ui.editors.discrete.CyStringPropertyEditor;
import cytoscape.visual.ui.icon.ArrowIcon;
import cytoscape.visual.ui.icon.NodeIcon;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import giny.view.ObjectPosition;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellEditorFactory {
    private final Map<Object, Icon> nodeShapeIcons = NodeShape.getIconSet();
    private final Map<Object, Icon> arrowShapeIcons = ArrowShape.getIconSet();
    private final Map<Object, Icon> lineTypeIcons = LineStyle.getIconSet();
    private final Map<Class<?>, PropertyEditor> editorMap = new HashMap();
    private final PropertyChangeListener pcl;

    CellEditorFactory(PropertyChangeListener pcl) {
        this.pcl = pcl;
        this.registerDefaultEditors();
        this.addListener();
    }

    private void registerDefaultEditors() {
        this.editorMap.put(String.class, new CyStringPropertyEditor());
        this.editorMap.put(Color.class, new CyColorPropertyEditor());
        this.editorMap.put(Font.class, new CyFontPropertyEditor());
        this.editorMap.put(Number.class, new CyDoublePropertyEditor());
        this.editorMap.put(ObjectPosition.class, new CyObjectPositionPropertyEditor(VisualPropertyType.NODE_LABEL_POSITION));
        this.editorMap.put(CyCustomGraphics.class, new CyCustomGraphicsEditor());
        this.initializeShapeSelectors();
    }

    private void initializeShapeSelectors() {
        VisualPropertyIcon newIcon;
        CyComboBoxPropertyEditor shapeCellEditor = new CyComboBoxPropertyEditor();
        ArrayList<Icon> iconList = new ArrayList<Icon>();
        ArrayList<NodeShape> nodeShapes = new ArrayList<NodeShape>();
        for (Object key : this.nodeShapeIcons.keySet()) {
            NodeShape shape = (NodeShape)((Object)key);
            if (!shape.isSupported()) continue;
            iconList.add(this.nodeShapeIcons.get(key));
            nodeShapes.add(shape);
        }
        Icon[] iconArray = new Icon[iconList.size()];
        String[] shapeNames = new String[iconList.size()];
        for (int i = 0; i < iconArray.length; ++i) {
            newIcon = ((NodeIcon)iconList.get(i)).clone();
            newIcon.setIconHeight(16);
            newIcon.setIconWidth(16);
            iconArray[i] = newIcon;
            shapeNames[i] = ((NodeShape)((Object)nodeShapes.get(i))).getShapeName();
        }
        shapeCellEditor.setAvailableValues(nodeShapes.toArray());
        shapeCellEditor.setAvailableIcons(iconArray);
        iconList.clear();
        iconList.addAll(this.arrowShapeIcons.values());
        iconArray = new Icon[iconList.size()];
        String[] arrowNames = new String[iconList.size()];
        Set<Object> arrowShapes = this.arrowShapeIcons.keySet();
        for (int i = 0; i < iconArray.length; ++i) {
            newIcon = (ArrowIcon)iconList.get(i);
            newIcon.setIconHeight(16);
            newIcon.setIconWidth(40);
            newIcon.setBottomPadding(-9);
            iconArray[i] = newIcon;
            arrowNames[i] = newIcon.getName();
        }
        CyComboBoxPropertyEditor arrowCellEditor = new CyComboBoxPropertyEditor();
        arrowCellEditor.setAvailableValues(arrowShapes.toArray());
        arrowCellEditor.setAvailableIcons(iconArray);
        iconList = new ArrayList();
        iconList.addAll(this.lineTypeIcons.values());
        iconArray = new Icon[iconList.size()];
        shapeNames = new String[iconList.size()];
        Set<Object> lineTypes = this.lineTypeIcons.keySet();
        for (int i = 0; i < iconArray.length; ++i) {
            newIcon = (VisualPropertyIcon)iconList.get(i);
            newIcon.setIconHeight(16);
            newIcon.setIconWidth(16);
            iconArray[i] = newIcon;
            shapeNames[i] = newIcon.getName();
        }
        CyComboBoxPropertyEditor lineCellEditor = new CyComboBoxPropertyEditor();
        lineCellEditor.setAvailableValues(lineTypes.toArray());
        lineCellEditor.setAvailableIcons(iconArray);
        CyComboBoxPropertyEditor booleanCellEditor = new CyComboBoxPropertyEditor();
        booleanCellEditor.setAvailableValues(new Boolean[]{true, false});
        this.editorMap.put(NodeShape.class, shapeCellEditor);
        this.editorMap.put(ArrowShape.class, arrowCellEditor);
        this.editorMap.put(LineStyle.class, lineCellEditor);
        this.editorMap.put(Boolean.class, booleanCellEditor);
    }

    private void addListener() {
        for (PropertyEditor editor : this.editorMap.values()) {
            editor.addPropertyChangeListener(this.pcl);
        }
    }

    public PropertyEditor getPropertyEditor(Class<?> type) {
        PropertyEditor editor = this.editorMap.get(type);
        if (editor == null) {
            return null;
        }
        return editor;
    }
}

