/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.strokes;

import cytoscape.visual.LineStyle;
import cytoscape.visual.strokes.ShapeStroke;
import cytoscape.visual.strokes.WidthStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class PipeStroke
extends ShapeStroke {
    private Type offsetType;

    PipeStroke(float width, Type offsetType, LineStyle lineStyle) {
        super(new Shape[]{PipeStroke.getShape(width, offsetType)}, width, lineStyle, width);
        this.offsetType = offsetType;
        this.lineStyle = lineStyle;
    }

    public WidthStroke newInstanceForWidth(float w) {
        return new PipeStroke(w, this.offsetType, this.lineStyle);
    }

    private static Shape getShape(float input, Type offsetType) {
        GeneralPath shape = new GeneralPath();
        float height = input;
        float width = input / 5.0f;
        float offset = offsetType.adjust(input);
        shape.moveTo(0.0f, -height);
        shape.lineTo(width, -height);
        shape.lineTo(width + offset, height);
        shape.lineTo(0.0f + offset, height);
        shape.lineTo(0.0f, -height);
        return shape;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        VERTICAL(0.0f),
        FORWARD(-1.0f),
        BACKWARD(1.0f);

        private float adjust;

        private Type(float adjust) {
            this.adjust = adjust;
        }

        public float adjust(float input) {
            return this.adjust * input;
        }
    }
}

