/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.render.stateful.CustomGraphic;
import cytoscape.visual.VisualPropertyDependency;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.properties.NodeCustomGraphicsProp;
import cytoscape.visual.ui.ObjectPlacerGraphic;
import cytoscape.visual.ui.icon.NodeIcon;
import ding.view.DNodeView;
import ding.view.ObjectPositionImpl;
import giny.view.NodeView;
import giny.view.ObjectPosition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;

public class NodeCustomGraphicsPositionProp
extends AbstractVisualProperty {
    private static final int ICON_SIZE = 55;
    private int index;

    public NodeCustomGraphicsPositionProp(Integer index) {
        this.index = index - 1;
    }

    public VisualPropertyType getType() {
        return VisualPropertyType.getCustomGraphicsPositionType(this.index);
    }

    public Icon getIcon(Object value) {
        final BufferedImage bi = new BufferedImage(55, 55, 1);
        Graphics2D g2 = bi.createGraphics();
        ObjectPlacerGraphic lp = new ObjectPlacerGraphic((ObjectPosition)value, 55, false, "Custom Graphics", null, null);
        lp.paint(g2);
        NodeIcon icon = new NodeIcon(){
            private static final long serialVersionUID = -3190338664704873605L;

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.drawImage((Image)bi, 10, -5, null);
            }
        };
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object position, VisualPropertyDependency dep) {
        if (position == null || nv == null || !(position instanceof ObjectPosition) || !(nv instanceof DNodeView)) {
            return;
        }
        ObjectPosition p = (ObjectPosition)position;
        DNodeView dv = (DNodeView)nv;
        NodeCustomGraphicsProp customGraphicsProp = (NodeCustomGraphicsProp)VisualPropertyType.getCustomGraphicsType(this.index).getVisualProperty();
        Set<CustomGraphic> currentCG = customGraphicsProp.getCurrentCustomGraphics(dv);
        if (currentCG == null || currentCG.size() == 0) {
            return;
        }
        ArrayList<CustomGraphic> newList = new ArrayList<CustomGraphic>();
        for (CustomGraphic g : currentCG) {
            newList.add(dv.setCustomGraphicsPosition(g, p));
            dv.removeCustomGraphic(g);
        }
        currentCG.clear();
        currentCG.addAll(newList);
    }

    public Object getDefaultAppearanceObject() {
        return new ObjectPositionImpl();
    }
}

