/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousRangeCalculator {
    private List<ContinuousMappingPoint> points;
    private Interpolator interpolator;
    private Map<String, Object> attrBundle;

    public ContinuousRangeCalculator(List<ContinuousMappingPoint> points, Interpolator interpolator, Map attrBundle) {
        this.points = points;
        this.interpolator = interpolator;
        this.attrBundle = attrBundle;
    }

    public Object calculateRangeValue(String attrName) {
        if (this.attrBundle == null || attrName == null) {
            return null;
        }
        if (this.points.size() == 0) {
            return null;
        }
        Object attrValue = this.attrBundle.get(attrName);
        if (!(attrValue instanceof Number)) {
            return null;
        }
        return this.getRangeValue((Number)attrValue);
    }

    private Object getRangeValue(Number domainValue) {
        ContinuousMappingPoint firstPoint = this.points.get(0);
        Double minDomain = (double)firstPoint.getValue();
        int firstCmp = this.compareValues(domainValue, minDomain);
        if (firstCmp <= 0) {
            BoundaryRangeValues bv = firstPoint.getRange();
            if (firstCmp < 0) {
                return bv.lesserValue;
            }
            return bv.equalValue;
        }
        ContinuousMappingPoint lastPoint = this.points.get(this.points.size() - 1);
        Double maxDomain = (double)lastPoint.getValue();
        if (this.compareValues(domainValue, maxDomain) > 0) {
            BoundaryRangeValues bv = lastPoint.getRange();
            return bv.greaterValue;
        }
        if (this.interpolator == null) {
            return null;
        }
        int index = 0;
        for (index = 0; index < this.points.size(); ++index) {
            ContinuousMappingPoint currentPoint = this.points.get(index);
            Double currentValue = (double)currentPoint.getValue();
            int cmpValue = this.compareValues(domainValue, currentValue);
            if (cmpValue == 0) {
                BoundaryRangeValues bv = currentPoint.getRange();
                return bv.equalValue;
            }
            if (cmpValue < 0) break;
        }
        return this.getRangeValue(index, domainValue);
    }

    private Object getRangeValue(int index, Number domainValue) {
        ContinuousMappingPoint lowerBound = this.points.get(index - 1);
        Byte lowerDomain = lowerBound.getValue().byteValue();
        BoundaryRangeValues lv = lowerBound.getRange();
        Object lowerRange = lv.greaterValue;
        ContinuousMappingPoint upperBound = this.points.get(index);
        Double upperDomain = (double)upperBound.getValue();
        BoundaryRangeValues gv = upperBound.getRange();
        Object upperRange = gv.lesserValue;
        return this.interpolator.getRangeValue(lowerDomain, lowerRange, upperDomain, upperRange, domainValue);
    }

    private int compareValues(Number probe, Number target) {
        double d2;
        double d1 = probe.doubleValue();
        if (d1 < (d2 = target.doubleValue())) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }
}

