/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.logger.CyLogger;
import cytoscape.visual.mappings.FlatInterpolator;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;

public class InterpolatorFactory {
    public static Interpolator newInterpolator(String typeName) {
        if (typeName == null) {
            String s = "InterpolatorFactory: no Interpolator class specified";
            CyLogger.getLogger().warn(s);
            return null;
        }
        if (typeName.equals("LinearNumberToColorInterpolator")) {
            return new LinearNumberToColorInterpolator();
        }
        if (typeName.equals("LinearNumberToNumberInterpolator")) {
            return new LinearNumberToNumberInterpolator();
        }
        if (typeName.equals("FlatInterpolator")) {
            return new FlatInterpolator();
        }
        String s = "InterpolatorFactory: unknown Interpolator type: " + typeName;
        CyLogger.getLogger().warn(s);
        return null;
    }

    public static String getName(Interpolator fInt) {
        if (fInt == null) {
            return null;
        }
        if (fInt instanceof LinearNumberToColorInterpolator) {
            return new String("LinearNumberToColorInterpolator");
        }
        if (fInt instanceof LinearNumberToNumberInterpolator) {
            return new String("LinearNumberToNumberInterpolator");
        }
        if (fInt instanceof FlatInterpolator) {
            return new String("FlatInterpolator");
        }
        String c = fInt.getClass().getName();
        CyLogger.getLogger().warn("Unknown Interpolator type: " + c);
        return null;
    }
}

