/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.util.FileUtil;
import cytoscape.util.URLUtil;
import cytoscape.util.ZipUtil;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;

public abstract class CalculatorCatalogFactory {
    protected static CyLogger logger = CyLogger.getLogger(CalculatorCatalogFactory.class);
    private static final String VIZMAP_PROPS_FILE_NAME = "vizmap.props";
    static Properties vizmapProps;
    static CalculatorCatalog calculatorCatalog;

    public static CalculatorCatalog loadCalculatorCatalog() {
        return CalculatorCatalogFactory.loadCalculatorCatalog(null);
    }

    public static CalculatorCatalog loadCalculatorCatalog(String vmName) {
        vizmapProps = CytoscapeInit.getVisualProperties();
        CalculatorCatalogFactory.initCatalog();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new VizMapListener());
        return calculatorCatalog;
    }

    private static void initCatalog() {
        calculatorCatalog.clear();
        calculatorCatalog.addMapping(MapperNames.DISCRETE.toString(), DiscreteMapping.class);
        calculatorCatalog.addMapping(MapperNames.CONTINUOUS.toString(), ContinuousMapping.class);
        calculatorCatalog.addMapping(MapperNames.PASSTHROUGH.toString(), PassThroughMapping.class);
        CalculatorIO.loadCalculators(vizmapProps, calculatorCatalog);
    }

    static {
        calculatorCatalog = new CalculatorCatalog();
    }

    private static class VizMapListener
    implements PropertyChangeListener {
        private VizMapListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent e) {
            String pn = null;
            if (e != null) {
                pn = e.getPropertyName();
            }
            if (Cytoscape.SAVE_VIZMAP_PROPS.equals(pn)) {
                File propertiesFile = null;
                propertiesFile = e.getNewValue() == null ? CytoscapeInit.getConfigFile(CalculatorCatalogFactory.VIZMAP_PROPS_FILE_NAME) : new File((String)e.getNewValue());
                if (propertiesFile != null) {
                    Set<String> test2 = calculatorCatalog.getVisualStyleNames();
                    Iterator<String> it = test2.iterator();
                    String styles = "Saving the following Visual Styles: ";
                    while (it.hasNext()) {
                        styles = styles + "\n    - " + it.next().toString();
                    }
                    logger.info(styles);
                    try {
                        CalculatorIO.storeCatalog(calculatorCatalog, propertiesFile);
                        logger.info("Vizmap saved to: " + propertiesFile);
                    }
                    catch (IOException e1) {
                        logger.error("Unable to save vizmap to: " + propertiesFile, e1);
                    }
                }
            } else if (Cytoscape.VIZMAP_RESTORED.equals(pn) || Cytoscape.VIZMAP_LOADED.equals(pn)) {
                Object vizmapSource;
                block24: {
                    if (Cytoscape.VIZMAP_RESTORED.equals(pn)) {
                        vizmapProps.clear();
                    }
                    vizmapSource = e.getNewValue();
                    logger.info("vizmapSource: '" + vizmapSource.toString() + "'");
                    try {
                        Object v1;
                        InputStream is = null;
                        ZipFile zf = null;
                        if (vizmapSource.getClass() == URL.class) {
                            is = URLUtil.getBasicInputStream((URL)vizmapSource);
                        } else if (vizmapSource.getClass() == String.class) {
                            if (Cytoscape.VIZMAP_RESTORED.equals(pn)) {
                                zf = new ZipFile((String)vizmapSource);
                                is = ZipUtil.readFile(zf, ".*vizmap.props");
                            } else {
                                is = FileUtil.getInputStream((String)vizmapSource);
                            }
                        }
                        if (is == null) break block24;
                        try {
                            vizmapProps.load(is);
                            Object var9_13 = null;
                        }
                        catch (Throwable throwable) {
                            Object v0;
                            Object var9_14 = null;
                            try {
                                if (zf != null) {
                                    zf.close();
                                }
                                v0 = null;
                            }
                            catch (Throwable throwable2) {
                                v0 = null;
                            }
                            Object var11_18 = v0;
                            is.close();
                            throw throwable;
                        }
                        try {
                            if (zf != null) {
                                zf.close();
                            }
                            v1 = null;
                        }
                        catch (Throwable throwable) {
                            v1 = null;
                        }
                        Object var11_17 = v1;
                        is.close();
                        {
                        }
                    }
                    catch (FileNotFoundException e1) {
                        logger.error("Unable to open visual mapper file: " + e1.getMessage());
                    }
                    catch (IOException e1) {
                        logger.error("Unable to read visual mapper file: " + e1.getMessage());
                    }
                }
                CalculatorCatalogFactory.initCatalog();
                logger.info("Applying visual styles from: " + vizmapSource.toString());
                VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
                vmm.setVisualStyle(vmm.getVisualStyle().getName());
                Cytoscape.getCurrentNetworkView().setVisualStyle(vmm.getVisualStyle().getName());
                Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                Cytoscape.getDesktop().repaint();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MapperNames {
        DISCRETE("Discrete Mapper"),
        CONTINUOUS("Continuous Mapper"),
        PASSTHROUGH("Passthrough Mapper");

        private String name;

        private MapperNames(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

