/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.ArrowShape;
import java.awt.Color;
import java.io.Serializable;

public class Arrow
implements Serializable {
    private static final Color DEFAULT_ARROW_COLOR = Color.BLACK;
    public static final Arrow NONE = new Arrow(ArrowShape.NONE, DEFAULT_ARROW_COLOR);
    public static final Arrow DIAMOND = new Arrow(ArrowShape.DIAMOND, DEFAULT_ARROW_COLOR);
    public static final Arrow DELTA = new Arrow(ArrowShape.DELTA, DEFAULT_ARROW_COLOR);
    public static final Arrow ARROW = new Arrow(ArrowShape.ARROW, DEFAULT_ARROW_COLOR);
    public static final Arrow T = new Arrow(ArrowShape.T, DEFAULT_ARROW_COLOR);
    public static final Arrow CIRCLE = new Arrow(ArrowShape.CIRCLE, DEFAULT_ARROW_COLOR);
    private Color arrowColor;
    private ArrowShape shape;
    private int size;

    public Arrow(ArrowShape shape, Color arrowColor) {
        this.shape = shape;
        this.arrowColor = arrowColor;
    }

    public ArrowShape getShape() {
        return this.shape;
    }

    public void setShape(ArrowShape newShape) {
        this.shape = newShape;
    }

    public Color getColor() {
        return this.arrowColor;
    }

    public void setColor(Color newColor) {
        this.arrowColor = newColor;
    }

    public String toString() {
        return this.shape.getGinyName();
    }

    public static Arrow parseArrowText(String text) {
        String arrowtext = text.trim();
        if (arrowtext.equals("WHITE_DIAMOND")) {
            return new Arrow(ArrowShape.DIAMOND, Color.white);
        }
        if (arrowtext.equals("BLACK_DIAMOND")) {
            return DIAMOND;
        }
        if (arrowtext.equals("COLOR_DIAMOND")) {
            return DIAMOND;
        }
        if (arrowtext.equals("WHITE_DELTA")) {
            return new Arrow(ArrowShape.DELTA, Color.white);
        }
        if (arrowtext.equals("BLACK_DELTA")) {
            return DELTA;
        }
        if (arrowtext.equals("COLOR_DELTA")) {
            return DELTA;
        }
        if (arrowtext.equals("WHITE_ARROW")) {
            return new Arrow(ArrowShape.ARROW, Color.white);
        }
        if (arrowtext.equals("BLACK_ARROW")) {
            return ARROW;
        }
        if (arrowtext.equals("COLOR_ARROW")) {
            return ARROW;
        }
        if (arrowtext.equals("WHITE_T")) {
            return new Arrow(ArrowShape.T, Color.white);
        }
        if (arrowtext.equals("BLACK_T")) {
            return T;
        }
        if (arrowtext.equals("COLOR_T")) {
            return T;
        }
        if (arrowtext.equals("WHITE_CIRCLE")) {
            return new Arrow(ArrowShape.CIRCLE, Color.white);
        }
        if (arrowtext.equals("BLACK_CIRCLE")) {
            return CIRCLE;
        }
        if (arrowtext.equals("COLOR_CIRCLE")) {
            return CIRCLE;
        }
        return NONE;
    }
}

