/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.swing.AbstractTreeTableModel;
import cytoscape.view.ColumnTypes;
import cytoscape.view.NetworkTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkTreeTableModel
extends AbstractTreeTableModel {
    private List<ColumnTypes> columnNames = new ArrayList<ColumnTypes>();
    private final Map<String, Icon> networkIcons;

    public NetworkTreeTableModel(Object root) {
        super(root);
        this.columnNames.add(ColumnTypes.NETWORK);
        this.columnNames.add(ColumnTypes.NODES);
        this.columnNames.add(ColumnTypes.EDGES);
        this.networkIcons = new HashMap<String, Icon>();
    }

    public void addColumn(ColumnTypes model, int idx) {
        this.columnNames.add(idx, model);
    }

    public void removeColumn(int idx) {
        this.columnNames.remove(idx);
    }

    @Override
    public Object getChild(Object parent, int index) {
        Enumeration<TreeNode> tree_node_enum = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
        while (tree_node_enum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node_enum.nextElement();
            if (node != parent) continue;
            return node.getChildAt(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        Enumeration<TreeNode> tree_node_enum = ((DefaultMutableTreeNode)this.getRoot()).breadthFirstEnumeration();
        while (tree_node_enum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree_node_enum.nextElement();
            if (node != parent) continue;
            return node.getChildCount();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column).getDisplayName();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.columnNames.get(column).getType();
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (this.columnNames.get(column).equals((Object)ColumnTypes.NETWORK)) {
            return ((DefaultMutableTreeNode)node).getUserObject();
        }
        if (this.columnNames.get(column).equals((Object)ColumnTypes.NODES)) {
            CyNetwork cyNetwork = Cytoscape.getNetwork(((NetworkTreeNode)node).getNetworkID());
            return "" + cyNetwork.getNodeCount() + "(" + cyNetwork.getSelectedNodes().size() + ")";
        }
        if (this.columnNames.get(column).equals((Object)ColumnTypes.EDGES)) {
            CyNetwork cyNetwork = Cytoscape.getNetwork(((NetworkTreeNode)node).getNetworkID());
            return "" + cyNetwork.getEdgeCount() + "(" + cyNetwork.getSelectedEdges().size() + ")";
        }
        if (this.columnNames.get(column).equals((Object)ColumnTypes.NETWORK_ICONS)) {
            return this.networkIcons.get(((NetworkTreeNode)node).getNetworkID());
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, Object node, int column) {
        if (this.columnNames.get(column).equals((Object)ColumnTypes.NETWORK)) {
            ((DefaultMutableTreeNode)node).setUserObject(aValue);
        } else if (this.columnNames.get(column).equals((Object)ColumnTypes.NETWORK_ICONS)) {
            if (aValue == null) {
                this.networkIcons.put(((NetworkTreeNode)node).getNetworkID(), null);
            } else {
                this.networkIcons.put(((NetworkTreeNode)node).getNetworkID(), (Icon)aValue);
            }
        }
    }
}

