/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.CyNetworkTitleChange;
import cytoscape.Cytoscape;
import cytoscape.actions.ApplyVisualStyleAction;
import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import cytoscape.logger.CyLogger;
import cytoscape.util.swing.JTreeTable;
import cytoscape.view.ColumnTypes;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.NetworkTreeNode;
import cytoscape.view.NetworkTreeTableModel;
import cytoscape.view.PopupActionListener;
import cytoscape.view.TreeCellRenderer;
import cytoscape.view.cytopanels.BiModalJSplitPane;
import giny.model.Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NetworkPanel
extends JPanel
implements PropertyChangeListener,
TreeSelectionListener,
SelectEventListener,
ChangeListener {
    private static final long serialVersionUID = -7102083850894612840L;
    private static final int DEF_DEVIDER_LOCATION = 280;
    private static final int PANEL_PREFFERED_WIDTH = 250;
    private static final int DEF_ROW_HEIGHT = 20;
    private final SwingPropertyChangeSupport pcs;
    private final JTreeTable treeTable;
    private final NetworkTreeNode root;
    private JPanel navigatorPanel;
    private JPanel networkTreePanel;
    private JPopupMenu popup;
    private PopupActionListener popupActionListener;
    private JMenuItem createViewItem;
    private JMenuItem destroyViewItem;
    private JMenuItem destroyNetworkItem;
    private JMenuItem editNetworkTitle;
    private JMenuItem applyVisualStyleMenu;
    private BiModalJSplitPane split;
    private final NetworkTreeTableModel treeTableModel;
    private final CytoscapeDesktop cytoscapeDesktop;
    private boolean doNotEnterValueChanged = false;

    public NetworkPanel(CytoscapeDesktop desktop) {
        this.cytoscapeDesktop = desktop;
        this.root = new NetworkTreeNode((Object)"Network Root", "root");
        this.treeTableModel = new NetworkTreeTableModel(this.root);
        this.treeTable = new JTreeTable(this.treeTableModel);
        this.treeTable.setSelectionMode(2);
        this.initialize();
        for (KeyStroke listener : this.treeTable.getRegisteredKeyStrokes()) {
            if (!listener.toString().equals("ctrl pressed A")) continue;
            InputMap map = this.treeTable.getInputMap();
            map.remove(listener);
            this.treeTable.setInputMap(0, map);
            this.treeTable.setInputMap(1, map);
        }
        this.pcs = new SwingPropertyChangeSupport(this);
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getVisualMappingManager().addChangeListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(250, 700));
        this.networkTreePanel = new JPanel();
        this.networkTreePanel.setLayout(new BoxLayout(this.networkTreePanel, 1));
        this.treeTable.getTree().addTreeSelectionListener(this);
        this.treeTable.getTree().setRootVisible(false);
        ToolTipManager.sharedInstance().registerComponent(this.treeTable);
        this.treeTable.getTree().setCellRenderer(new TreeCellRenderer());
        this.resetTable();
        this.navigatorPanel = new JPanel();
        this.navigatorPanel.setMinimumSize(new Dimension(180, 180));
        this.navigatorPanel.setMaximumSize(new Dimension(180, 180));
        this.navigatorPanel.setPreferredSize(new Dimension(180, 180));
        JScrollPane scroll = new JScrollPane(this.treeTable);
        this.networkTreePanel.add(scroll);
        this.split = new BiModalJSplitPane(this.cytoscapeDesktop, 0, 1, this.networkTreePanel, this.navigatorPanel);
        this.split.setResizeWeight(1.0);
        this.split.setDividerLocation(280);
        this.add(this.split);
        this.treeTable.addMouseListener(new PopupListener());
        this.popup = new JPopupMenu();
        this.editNetworkTitle = new JMenuItem("Edit Network Title");
        this.createViewItem = new JMenuItem("Create View");
        this.destroyViewItem = new JMenuItem("Destroy View");
        this.destroyNetworkItem = new JMenuItem("Destroy Network");
        this.applyVisualStyleMenu = new JMenu("Apply Visual Style");
        this.popupActionListener = new PopupActionListener();
        this.editNetworkTitle.addActionListener(this.popupActionListener);
        this.createViewItem.addActionListener(this.popupActionListener);
        this.destroyViewItem.addActionListener(this.popupActionListener);
        this.destroyNetworkItem.addActionListener(this.popupActionListener);
        this.applyVisualStyleMenu.addActionListener(this.popupActionListener);
        this.popup.add(this.editNetworkTitle);
        this.popup.add(this.createViewItem);
        this.popup.add(this.destroyViewItem);
        this.popup.add(this.destroyNetworkItem);
        this.popup.addSeparator();
        this.popup.add(this.applyVisualStyleMenu);
    }

    private void resetTable() {
        this.treeTable.getColumn(ColumnTypes.NETWORK.getDisplayName()).setPreferredWidth(170);
        this.treeTable.getColumn(ColumnTypes.NODES.getDisplayName()).setPreferredWidth(45);
        this.treeTable.getColumn(ColumnTypes.EDGES.getDisplayName()).setPreferredWidth(45);
        this.treeTable.setRowHeight(20);
    }

    public void setNavigator(Component comp) {
        this.split.setRightComponent(comp);
        this.split.validate();
    }

    public JTreeTable getTreeTable() {
        return this.treeTable;
    }

    public JPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void removeNetwork(String network_id) {
        NetworkTreeNode node = this.getNetworkNode(network_id);
        if (node == null) {
            return;
        }
        Enumeration<TreeNode> children = node.children();
        Object var4_4 = null;
        ArrayList<TreeNode> removed_children = new ArrayList<TreeNode>();
        while (children.hasMoreElements()) {
            removed_children.add(children.nextElement());
        }
        for (NetworkTreeNode networkTreeNode : removed_children) {
            networkTreeNode.removeFromParent();
            this.root.add(networkTreeNode);
        }
        Cytoscape.getNetwork(network_id).removeSelectEventListener(this);
        node.removeFromParent();
        this.treeTable.getTree().updateUI();
        this.treeTable.doLayout();
    }

    public void updateTitle(CyNetwork network) {
        if (this.treeTable.getTree().getSelectionPath() != null) {
            this.treeTableModel.setValueAt(network.getTitle(), this.treeTable.getTree().getSelectionPath().getLastPathComponent(), 0);
        } else {
            NetworkTreeNode node = this.getNetworkNode(network.getIdentifier());
            this.treeTableModel.setValueAt(network.getTitle(), node, 0);
        }
        this.treeTable.getTree().updateUI();
        this.treeTable.doLayout();
        Cytoscape.getDesktop().getNetworkViewManager().updateNetworkTitle(network);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelectEvent(SelectEvent event) {
        if (event.getTargetType() == 0 || event.getTargetType() == 2) {
            Set selectedNodes = Cytoscape.getCurrentNetwork().getSelectedNodes();
            ArrayList<String> selectedNestedNetworkIDs = new ArrayList<String>();
            for (Node node : selectedNodes) {
                CyNetwork nestedNetwork = (CyNetwork)node.getNestedNetwork();
                if (nestedNetwork == null) continue;
                selectedNestedNetworkIDs.add(nestedNetwork.getIdentifier());
            }
            if (!selectedNestedNetworkIDs.isEmpty()) {
                this.doNotEnterValueChanged = true;
                try {
                    TreePath[] treePaths = new TreePath[selectedNestedNetworkIDs.size() + 1];
                    int index = 0;
                    String currentNetworkID = Cytoscape.getCurrentNetwork().getIdentifier();
                    TreePath currentPath = null;
                    JTree tree = this.treeTable.getTree();
                    for (int row = 0; row < tree.getRowCount(); ++row) {
                        TreePath path = tree.getPathForRow(row);
                        String ID2 = ((NetworkTreeNode)path.getLastPathComponent()).getNetworkID();
                        if (ID2.equals(currentNetworkID)) {
                            currentPath = path;
                            continue;
                        }
                        if (!selectedNestedNetworkIDs.contains(ID2)) continue;
                        treePaths[index++] = path;
                    }
                    Cytoscape.setSelectedNetworks(selectedNestedNetworkIDs);
                    treePaths[index] = currentPath;
                    tree.getSelectionModel().setSelectionPaths(treePaths);
                    tree.scrollPathToVisible(currentPath);
                }
                finally {
                    this.doNotEnterValueChanged = false;
                }
            }
        }
        this.treeTable.getTree().updateUI();
    }

    public void addNetwork(String network_id, String parent_id) {
        if (this.getNetworkNode(network_id) == null) {
            NetworkTreeNode dmtn = new NetworkTreeNode((Object)Cytoscape.getNetwork(network_id).getTitle(), network_id);
            Cytoscape.getNetwork(network_id).addSelectEventListener(this);
            if (parent_id != null && this.getNetworkNode(parent_id) != null) {
                this.getNetworkNode(parent_id).add(dmtn);
            } else {
                this.root.add(dmtn);
            }
            this.treeTable.getTree().collapsePath(new TreePath(new TreeNode[]{this.root}));
            this.treeTable.getTree().updateUI();
            TreePath path = new TreePath(dmtn.getPath());
            this.treeTable.getTree().expandPath(path);
            this.treeTable.getTree().scrollPathToVisible(path);
            this.treeTable.doLayout();
            this.focusNetworkNode(network_id);
        }
    }

    public void focusNetworkNode(String network_id) {
        NetworkTreeNode node = this.getNetworkNode(network_id);
        if (node != null) {
            this.treeTable.getTree().getSelectionModel().setSelectionPath(new TreePath(node.getPath()));
            this.treeTable.getTree().scrollPathToVisible(new TreePath(node.getPath()));
        }
    }

    public NetworkTreeNode getNetworkNode(String network_id) {
        Enumeration<TreeNode> tree_node_enum = this.root.breadthFirstEnumeration();
        while (tree_node_enum.hasMoreElements()) {
            NetworkTreeNode node = (NetworkTreeNode)tree_node_enum.nextElement();
            if (node.getNetworkID() != network_id) continue;
            return node;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.doNotEnterValueChanged) {
            return;
        }
        JTree mtree = this.treeTable.getTree();
        NetworkTreeNode node = (NetworkTreeNode)mtree.getLastSelectedPathComponent();
        if (node == null || node.getUserObject() == null) {
            return;
        }
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, "NETWORK_VIEW_FOCUS", null, node.getNetworkID()));
        LinkedList<String> networkList = new LinkedList<String>();
        try {
            for (int i = mtree.getMinSelectionRow(); i <= mtree.getMaxSelectionRow(); ++i) {
                NetworkTreeNode n = (NetworkTreeNode)mtree.getPathForRow(i).getLastPathComponent();
                if (n == null || n.getUserObject() == null || !mtree.isRowSelected(i)) continue;
                networkList.add(n.getNetworkID());
            }
        }
        catch (Exception ex) {
            CyLogger.getLogger().warn("Exception handling network panel change: " + ex.getMessage());
            ex.printStackTrace();
        }
        if (networkList.size() > 0) {
            Cytoscape.setSelectedNetworks(networkList);
            Cytoscape.setSelectedNetworkViews(networkList);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (Cytoscape.NETWORK_CREATED.equals(e.getPropertyName())) {
            this.addNetwork((String)e.getNewValue(), (String)e.getOldValue());
        } else if (Cytoscape.NETWORK_DESTROYED.equals(e.getPropertyName())) {
            this.removeNetwork((String)e.getNewValue());
        } else if ("NETWORK_VIEW_FOCUSED".equals(e.getPropertyName())) {
            if (e.getSource() != this) {
                this.focusNetworkNode((String)e.getNewValue());
            }
        } else if ("NETWORK_TITLE_MODIFIED".equals(e.getPropertyName())) {
            CyNetworkTitleChange cyNetworkTitleChange = (CyNetworkTitleChange)e.getNewValue();
            String newID = cyNetworkTitleChange.getNetworkIdentifier();
            CyNetwork _network = Cytoscape.getNetwork(newID);
            if (_network != null && !_network.getIdentifier().equals("0")) {
                this.updateTitle(_network);
            }
        } else if (Cytoscape.CYTOSCAPE_INITIALIZED.equals(e.getPropertyName())) {
            this.updateVSMenu();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.updateVSMenu();
    }

    private void updateVSMenu() {
        this.applyVisualStyleMenu.removeAll();
        TreeSet<String> vsNames = new TreeSet<String>(Cytoscape.getVisualMappingManager().getCalculatorCatalog().getVisualStyleNames());
        for (String name : vsNames) {
            JMenuItem styleMenu = new JMenuItem(name);
            styleMenu.setAction(new ApplyVisualStyleAction(name));
            this.applyVisualStyleMenu.add(styleMenu);
        }
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            int[] selected;
            if (e.isPopupTrigger() && (selected = NetworkPanel.this.treeTable.getSelectedRows()) != null && selected.length != 0) {
                boolean enableViewRelatedMenu = false;
                int selectedItemCount = selected.length;
                CyNetwork cyNetwork = null;
                JTree tree = NetworkPanel.this.treeTable.getTree();
                for (int i = 0; i < selectedItemCount; ++i) {
                    TreePath treePath = tree.getPathForRow(selected[i]);
                    String networkID = ((NetworkTreeNode)treePath.getLastPathComponent()).getNetworkID();
                    cyNetwork = Cytoscape.getNetwork(networkID);
                    if (!Cytoscape.viewExists(networkID)) continue;
                    enableViewRelatedMenu = true;
                }
                if (selectedItemCount == 1) {
                    NetworkPanel.this.editNetworkTitle.setEnabled(true);
                    NetworkPanel.this.popupActionListener.setActiveNetwork(cyNetwork);
                } else {
                    NetworkPanel.this.editNetworkTitle.setEnabled(false);
                }
                if (enableViewRelatedMenu) {
                    NetworkPanel.this.createViewItem.setEnabled(true);
                    NetworkPanel.this.destroyViewItem.setEnabled(true);
                    NetworkPanel.this.applyVisualStyleMenu.setEnabled(true);
                } else {
                    NetworkPanel.this.createViewItem.setEnabled(true);
                    NetworkPanel.this.destroyViewItem.setEnabled(false);
                    NetworkPanel.this.applyVisualStyleMenu.setEnabled(false);
                }
                NetworkPanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

