/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.task.ui;

import cytoscape.task.util.StringWrap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class JErrorPanel
extends JPanel {
    private static final long serialVersionUID = 333614801L;
    private Throwable t;
    private String userErrorMessage;
    private String tip;
    private boolean showDetails = false;
    private JButton detailsButton;
    private JScrollPane detailsPane;
    private JDialog owner;
    private static final String SHOW_TEXT = "Show Error Details";
    private static final String HIDE_TEXT = "Hide Error Details";

    JErrorPanel(JDialog owner, Throwable t, String userErrorMessage) {
        if (owner == null) {
            throw new IllegalArgumentException("owner parameter is null.");
        }
        this.owner = owner;
        this.t = t;
        this.userErrorMessage = userErrorMessage;
        this.initUI();
    }

    JErrorPanel(JDialog owner, Throwable t, String userErrorMessage, String tip) {
        if (owner == null) {
            throw new IllegalArgumentException("owner parameter is null.");
        }
        this.owner = owner;
        this.t = t;
        this.userErrorMessage = userErrorMessage;
        this.tip = tip;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = this.createNorthPanel();
        this.add((Component)northPanel, "North");
        JScrollPane centerPanel = this.createCenterPanel();
        this.add((Component)centerPanel, "Center");
        this.owner.pack();
        this.owner.validate();
    }

    private JPanel createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BorderLayout());
        if (this.userErrorMessage == null) {
            this.userErrorMessage = new String("An Error Has Occurred.  Please try again.");
        }
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        JLabel l = new JLabel(icon);
        l.setVerticalAlignment(1);
        panel.add((Component)l, "West");
        JPanel textPanel = new JPanel();
        textPanel.setAlignmentY(0.0f);
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        JTextArea errorArea = this.createErrorTextArea(this.userErrorMessage);
        textPanel.add(errorArea);
        if (this.tip != null) {
            JTextArea tipArea = this.createTipTextArea(this.tip);
            textPanel.add(tipArea);
        }
        panel.add((Component)textPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 1));
        buttonPanel.setAlignmentY(0.0f);
        this.conditionallyAddDetailsButton(buttonPanel);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JErrorPanel.this.owner.dispose();
            }
        });
        buttonPanel.add(closeButton);
        JPanel enclosingPanel = new JPanel();
        enclosingPanel.add(buttonPanel);
        enclosingPanel.setAlignmentY(0.0f);
        panel.add((Component)enclosingPanel, "East");
        return panel;
    }

    private JTextArea createErrorTextArea(String msg) {
        msg = StringWrap.wrap(msg, 50, "\n", false);
        JTextArea errorArea = new JTextArea(msg);
        errorArea.setEditable(false);
        errorArea.setOpaque(false);
        Font font = errorArea.getFont();
        errorArea.setFont(new Font(font.getFamily(), 1, font.getSize() - 1));
        errorArea.setBorder(new EmptyBorder(10, 10, 0, 10));
        return errorArea;
    }

    private JTextArea createTipTextArea(String tip) {
        tip = StringWrap.wrap(tip, 50, "\n", false);
        JTextArea tipArea = new JTextArea(tip);
        tipArea.setEditable(false);
        tipArea.setOpaque(false);
        Font font = tipArea.getFont();
        tipArea.setFont(new Font(font.getFamily(), 0, font.getSize()));
        tipArea.setBorder(new EmptyBorder(10, 10, 10, 10));
        return tipArea;
    }

    private JScrollPane createCenterPanel() {
        this.detailsPane = new JScrollPane();
        if (this.t != null) {
            DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root Error");
            this.processThrowable(this.t, top);
            JTree tree = new JTree(top);
            tree.scrollPathToVisible(new TreePath(top.getPath()));
            tree.setBorder(new EmptyBorder(4, 10, 10, 10));
            this.detailsPane.setViewportView(tree);
            this.detailsPane.setPreferredSize(new Dimension(10, 150));
        }
        this.detailsPane.setVisible(false);
        return this.detailsPane;
    }

    private void processThrowable(Throwable t, DefaultMutableTreeNode top) {
        if (t == null) {
            return;
        }
        StackTraceElement[] ste = t.getStackTrace();
        StringBuffer rootBuffer = new StringBuffer("Caused by: ");
        rootBuffer.append(t.getClass().getName());
        rootBuffer.append(":  ");
        if (t.getMessage() != null) {
            rootBuffer.append(t.getMessage());
        }
        DefaultMutableTreeNode current = top;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(rootBuffer.toString());
        current.add(node);
        current = node;
        if (ste != null) {
            for (int i = 0; i < ste.length; ++i) {
                DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(ste[i]);
                current.add(node2);
                if (i >= ste.length - 1) continue;
                current = node2;
            }
        }
        this.processThrowable(t.getCause(), current);
    }

    private void conditionallyAddDetailsButton(JPanel panel) {
        if (this.t != null && this.t.getStackTrace() != null) {
            this.detailsButton = new JButton(SHOW_TEXT);
            this.detailsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JErrorPanel.this.showDetails = !JErrorPanel.this.showDetails;
                    JErrorPanel.this.detailsPane.setVisible(JErrorPanel.this.showDetails);
                    JErrorPanel.this.owner.setResizable(JErrorPanel.this.showDetails);
                    if (JErrorPanel.this.showDetails) {
                        JErrorPanel.this.detailsButton.setText(JErrorPanel.HIDE_TEXT);
                    } else {
                        JErrorPanel.this.detailsButton.setText(JErrorPanel.SHOW_TEXT);
                    }
                    JErrorPanel.this.owner.pack();
                    JErrorPanel.this.owner.validate();
                }
            });
            this.detailsButton.setAlignmentX(1.0f);
            panel.add(this.detailsButton);
        }
    }

    public static void main(String[] args) {
        NullPointerException e = new NullPointerException();
        final JDialog dialog = new JDialog();
        JErrorPanel errorPanel = new JErrorPanel(dialog, e, "Network error occurred while tring to connect to remote web service.", "Please check your network settings, and try again.");
        dialog.getContentPane().add((Component)errorPanel, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dialog.pack();
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }
}

