/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CytoscapeVersion;
import cytoscape.plugin.Category;
import cytoscape.plugin.ManagerUtil;
import cytoscape.plugin.PluginFileReader;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginTestXML;
import cytoscape.plugin.ThemeInfo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.jdom.JDOMException;

public class PluginFileReaderTest
extends TestCase {
    private String url;
    private PluginFileReader reader;
    private File tempTestFile;

    private String getFileUrl() {
        String FS = "/";
        String UserDir = System.getProperty("user.dir");
        UserDir = UserDir.replaceFirst(FS, "");
        return "file:///" + UserDir + FS + "testData" + FS + "plugins" + FS;
    }

    protected void setUp() throws Exception {
        this.tempTestFile = PluginTestXML.transformXML("test_plugin.xml", this.getFileUrl());
        this.url = "file:///" + this.tempTestFile.getAbsolutePath();
        this.reader = new PluginFileReader(this.url);
        PluginFileReaderTest.assertNotNull(this.reader);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tempTestFile.delete();
    }

    public void testPluginFileReader() throws Exception {
        PluginFileReaderTest.assertNotNull(this.reader);
    }

    public void testGetProjectName() {
        PluginFileReaderTest.assertNotNull(this.reader.getProjectName());
        PluginFileReaderTest.assertTrue(this.reader.getProjectName().equals("Cytoscape Plugins"));
    }

    public void testGetProjectDescription() {
        PluginFileReaderTest.assertNotNull(this.reader.getProjectDescription());
        PluginFileReaderTest.assertTrue(this.reader.getProjectDescription().equals("Test"));
    }

    public void testGetProjectUrl() {
        PluginFileReaderTest.assertNotNull(this.reader.getProjectUrl());
        PluginFileReaderTest.assertTrue(this.reader.getProjectUrl().equals("http://cytoscape.org"));
    }

    public void testGetPlugins() {
        PluginFileReaderTest.assertNotNull(this.reader.getPlugins());
        PluginFileReaderTest.assertEquals(this.reader.getPlugins().size(), 10);
    }

    public void testGetPluginsLicense() {
        List<PluginInfo> All = this.reader.getPlugins();
        PluginFileReaderTest.assertNotNull(All.get(0).getLicenseText());
    }

    public void testGetThemes() {
        PluginFileReaderTest.assertNotNull(this.reader.getThemes());
        PluginFileReaderTest.assertEquals(this.reader.getThemes().size(), 3);
        PluginFileReaderTest.assertEquals(this.reader.getThemes().get(0).getPlugins().size(), 2);
        for (ThemeInfo i : this.reader.getThemes()) {
            PluginFileReaderTest.assertEquals(i.getCategory(), Category.THEME.getCategoryText());
        }
    }

    public void testReadFileMissingThemes() throws JDOMException, IOException {
        this.url = this.getFileUrl() + "test_plugin_no_themes.xml";
        PluginFileReader readerNoThemes = new PluginFileReader(this.url);
        PluginFileReaderTest.assertNotNull(readerNoThemes.getThemes());
        PluginFileReaderTest.assertEquals(readerNoThemes.getThemes().size(), 0);
    }

    public void testVersionReads() {
        PluginFileReaderTest.assertNotNull(this.reader.getPlugins());
        PluginFileReaderTest.assertEquals(this.reader.getPlugins().size(), 10);
        CytoscapeVersion.version = "2.3.3";
        int count = 0;
        for (PluginInfo info : this.reader.getPlugins()) {
            if (!info.isPluginCompatibleWithCurrent()) continue;
            ++count;
        }
        PluginFileReaderTest.assertEquals(count, 2);
    }

    public void testThemePlugins() {
        boolean foundTheme = false;
        PluginFileReaderTest.assertNotNull(this.reader.getThemes());
        PluginFileReaderTest.assertEquals(this.reader.getThemes().size(), 3);
        for (ThemeInfo info : this.reader.getThemes()) {
            if (!info.getID().equals("regresstionTestTheme123")) continue;
            foundTheme = true;
            PluginFileReaderTest.assertEquals(info.getPlugins().size(), 3);
            Map<String, List<PluginInfo>> idSort = ManagerUtil.sortByID(info.getPlugins());
            PluginFileReaderTest.assertTrue(idSort.containsKey("themePlugin1234"));
            PluginInfo plugin = idSort.get("themePlugin1234").get(0);
            PluginFileReaderTest.assertEquals(plugin.getObjectVersion(), "1.1");
        }
        PluginFileReaderTest.assertTrue(foundTheme);
    }
}

