/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.geom.rtree.test;

import java.io.IOException;
import java.io.InputStream;

public class ArrayTestMethod1 {
    public static void main(String[] args) throws Exception {
        int read;
        int nodeSize = Integer.parseInt(args[0]);
        int nPrime = 51437;
        Node[] nodeArr = new Node[51437];
        for (int i = 0; i < nodeArr.length; ++i) {
            nodeArr[i] = new Node(nodeSize);
        }
        double sqrtN = Math.sqrt(51437.0);
        InputStream in = System.in;
        byte[] buff = new byte[16 * nodeSize];
        int inx = 0;
        int off = 0;
        while (inx < nodeArr.length && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            for (int i = 0; i < nodeSize; ++i) {
                int nonnegative = Integer.MAX_VALUE & ArrayTestMethod1.assembleInt(buff, 0 + i * 16);
                double centerX = (double)nonnegative / 2.147483647E9;
                nonnegative = Integer.MAX_VALUE & ArrayTestMethod1.assembleInt(buff, 4 + i * 16);
                double centerY = (double)nonnegative / 2.147483647E9;
                nonnegative = Integer.MAX_VALUE & ArrayTestMethod1.assembleInt(buff, 8 + i * 16);
                double width = (double)nonnegative / 2.147483647E9 / sqrtN;
                nonnegative = Integer.MAX_VALUE & ArrayTestMethod1.assembleInt(buff, 12 + i * 16);
                double height = (double)nonnegative / 2.147483647E9 / sqrtN;
                ((Node)nodeArr[inx]).xMins[i] = centerX - width / 2.0;
                ((Node)nodeArr[inx]).yMins[i] = centerY - height / 2.0;
                ((Node)nodeArr[inx]).xMaxs[i] = centerX + width / 2.0;
                ((Node)nodeArr[inx]).yMaxs[i] = centerY + height / 2.0;
            }
            ++inx;
        }
        if (inx < nodeArr.length) {
            throw new IOException("premature end of input");
        }
        int incr = 797;
        int inx2 = 0;
        long millisBegin = System.currentTimeMillis();
        for (int i = 0; i < nodeArr.length; ++i) {
            Node n = nodeArr[inx2];
            for (int j = 0; j < nodeSize; ++j) {
                double foo = n.xMins[j] + n.yMins[j] + n.xMaxs[j] + n.yMaxs[j];
            }
            inx2 = (inx2 + 797) % nodeArr.length;
        }
        long millisEnd = System.currentTimeMillis();
        System.err.println("sequential rectangle access took " + (millisEnd - millisBegin) + " milliseconds");
    }

    private static int assembleInt(byte[] bytes, int offset) {
        int firstByte = (bytes[offset] & 0xFF) << 24;
        int secondByte = (bytes[offset + 1] & 0xFF) << 16;
        int thirdByte = (bytes[offset + 2] & 0xFF) << 8;
        int fourthByte = (bytes[offset + 3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }

    private static final class Node {
        private final double[] xMins;
        private final double[] yMins;
        private final double[] xMaxs;
        private final double[] yMaxs;

        private Node(int size) {
            this.xMins = new double[size];
            this.yMins = new double[size];
            this.xMaxs = new double[size];
            this.yMaxs = new double[size];
        }
    }
}

