/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.plugin.DownloadableInfo;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode
extends DefaultMutableTreeNode {
    private Vector<TreeNode> children;
    private DownloadableInfo infoObj;
    private String title;
    private TreeNode parent;
    private boolean childAllowed;
    private boolean visible;

    public TreeNode(String Title2) {
        this.init(Title2, true);
    }

    public TreeNode(String Title2, boolean allowsChildren) {
        this.init(Title2, allowsChildren);
    }

    public TreeNode(DownloadableInfo obj) {
        this.init(obj.getName(), false);
        this.addObject(obj);
    }

    public TreeNode(DownloadableInfo obj, boolean allowsChildren) {
        this.init(obj.getName(), allowsChildren);
        this.addObject(obj);
    }

    private void init(String Title2, boolean childrenOk) {
        this.children = new Vector();
        this.title = Title2;
        this.childAllowed = childrenOk;
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isLeaf() {
        return !this.childAllowed;
    }

    public boolean isNodeAncestor(TreeNode otherNode) {
        return this.recursiveParentLookup(this, otherNode);
    }

    public void setParent(TreeNode newParent) {
        this.parent = newParent;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public void addObject(DownloadableInfo info) {
        this.infoObj = info;
    }

    public void addChild(TreeNode newChild) {
        if (!this.childAllowed) {
            throw new IllegalStateException();
        }
        if (newChild == null) {
            throw new IllegalArgumentException();
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("Cannot add ancestor node.");
        }
        this.children.add(newChild);
        newChild.setParent(this);
    }

    public void removeChild(TreeNode child) {
        this.children.remove(child);
    }

    public void removeChildren() {
        this.children.clear();
    }

    public void addChildren(TreeNode[] children) {
        for (TreeNode c : children) {
            if (!c.isVisible()) continue;
            this.addChild(c);
        }
    }

    public Vector<TreeNode> getChildren() {
        return this.children;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getChildAt(int index) {
        return this.children.get(index);
    }

    public int getIndexOfChild(TreeNode child) {
        return this.children.indexOf(child);
    }

    public int getTreeCount() {
        return this.recursiveTotalSubCategorySize(this);
    }

    @Override
    public int getLeafCount() {
        if (this.getChildCount() <= 0) {
            return 0;
        }
        return this.recursiveTotalLeafSize(this);
    }

    public String getTitle() {
        return this.title;
    }

    public DownloadableInfo getObject() {
        return this.infoObj;
    }

    @Override
    public String toString() {
        if (this.infoObj != null) {
            return this.infoObj.toString();
        }
        return this.getTitle() + ": " + this.getLeafCount();
    }

    private int recursiveTotalSubCategorySize(TreeNode node) {
        int n = 0;
        n += node.getChildCount();
        for (TreeNode c : node.getChildren()) {
            n += this.recursiveTotalSubCategorySize(c);
        }
        return n;
    }

    private int recursiveTotalLeafSize(TreeNode node) {
        int n = 0;
        if (node.getChildCount() == 0) {
            n = 1;
        }
        for (TreeNode c : node.getChildren()) {
            n += this.recursiveTotalLeafSize(c);
        }
        return n;
    }

    private boolean recursiveParentLookup(TreeNode node, TreeNode ancestor) {
        boolean lookup = false;
        if (node.getParent() != null) {
            lookup = node.getParent().equals(ancestor) ? true : this.recursiveParentLookup(node.getParent(), ancestor);
        }
        return lookup;
    }
}

