/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class LicenseDialog
extends JDialog {
    private static String title = "Plugin License Agreement";
    private JRadioButton acceptRadio;
    private JPanel buttonPane;
    private JButton cancelButton;
    private JRadioButton declineRadio;
    private JLabel licenseLabel;
    private JEditorPane licensePanel;
    private JScrollPane licenseScrollPane;
    private JSplitPane licenseSplitPane;
    private JButton okButton;
    private JList pluginList;
    private JScrollPane pluginListScrollPane;
    private LicenseListModel listModel;

    public LicenseDialog() {
        this.setModal(true);
        this.setTitle(title);
        this.setLocationRelativeTo(this);
        this.initComponents();
        this.listSetup();
    }

    public LicenseDialog(JDialog owner) {
        super(owner, title, true);
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.listSetup();
    }

    public LicenseDialog(JFrame owner) {
        super(owner, title, true);
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.listSetup();
    }

    private void listSetup() {
        this.listModel = new LicenseListModel();
        this.pluginList.setCellRenderer(new LicenseListCellRenderer());
        this.pluginList.setModel(this.listModel);
        this.pluginList.setSelectionMode(0);
        this.acceptRadio.setEnabled(false);
        this.declineRadio.setEnabled(false);
    }

    public void addPlugin(DownloadableInfo obj) {
        this.listModel.addElement(obj);
    }

    public void selectDefault() {
        this.pluginList.setSelectedIndex(0);
        DownloadableInfo infoObj = (DownloadableInfo)this.pluginList.getSelectedValue();
        this.setLicenseText(infoObj.getLicenseText());
    }

    private void initComponents() {
        this.licenseSplitPane = new JSplitPane();
        this.pluginListScrollPane = new JScrollPane();
        this.pluginList = new JList();
        this.licenseScrollPane = new JScrollPane();
        this.licensePanel = new JEditorPane();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.acceptRadio = new JRadioButton();
        this.declineRadio = new JRadioButton();
        this.licenseLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.licenseSplitPane.setDividerLocation(150);
        this.pluginList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                LicenseDialog.this.pluginListValueChanged(evt);
            }
        });
        this.pluginListScrollPane.setViewportView(this.pluginList);
        this.licenseSplitPane.setLeftComponent(this.pluginListScrollPane);
        this.licenseScrollPane.setViewportView(this.licensePanel);
        this.licenseSplitPane.setRightComponent(this.licenseScrollPane);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LicenseDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("Ok");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LicenseDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.acceptRadio.setText("Accept All");
        this.acceptRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.acceptRadio.setMargin(new Insets(0, 0, 0, 0));
        this.acceptRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LicenseDialog.this.radioAcceptEvent(evt);
            }
        });
        this.declineRadio.setText("Decline All");
        this.declineRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.declineRadio.setMargin(new Insets(0, 0, 0, 0));
        this.declineRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LicenseDialog.this.radioDeclineEvent(evt);
            }
        });
        GroupLayout buttonPaneLayout = new GroupLayout(this.buttonPane);
        this.buttonPane.setLayout(buttonPaneLayout);
        buttonPaneLayout.setHorizontalGroup(buttonPaneLayout.createParallelGroup(1).add(2, buttonPaneLayout.createSequentialGroup().addContainerGap().add(this.acceptRadio).add(17, 17, 17).add(this.declineRadio).addPreferredGap(0, 221, Short.MAX_VALUE).add(this.okButton).add(20, 20, 20).add(this.cancelButton).addContainerGap()));
        buttonPaneLayout.setVerticalGroup(buttonPaneLayout.createParallelGroup(1).add(buttonPaneLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(buttonPaneLayout.createParallelGroup(3).add(this.acceptRadio).add(this.declineRadio).add(this.cancelButton).add(this.okButton))));
        this.licenseLabel.setText("Cytoscape Plugin License Agreements");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.licenseLabel, -1, 595, Short.MAX_VALUE).add(this.buttonPane, -1, -1, Short.MAX_VALUE).add(this.licenseSplitPane, -1, 595, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.licenseLabel, -2, 16, -2).add(14, 14, 14).add(this.licenseSplitPane, -1, 356, Short.MAX_VALUE).add(9, 9, 9).add(this.buttonPane, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void radioAcceptEvent(ActionEvent evt) {
        this.acceptRadio.setSelected(true);
        this.declineRadio.setSelected(false);
        this.okButton.setEnabled(true);
    }

    private void radioDeclineEvent(ActionEvent evt) {
        this.declineRadio.setSelected(true);
        this.acceptRadio.setSelected(false);
        this.okButton.setEnabled(false);
    }

    public void addListenerToOk(ActionListener listener) {
        this.okButton.addActionListener(listener);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        CyLogger.getLogger().info("FINISHED");
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void pluginListValueChanged(ListSelectionEvent evt) {
        if (this.pluginList.getSelectedIndex() < 0) {
            this.pluginList.setSelectedIndex(0);
        }
        DownloadableInfo infoObj = (DownloadableInfo)this.pluginList.getSelectedValue();
        this.setLicenseText(infoObj.getLicenseText());
        this.acceptRadio.setEnabled(true);
        this.declineRadio.setEnabled(true);
    }

    private void setLicenseText(String licenseText) {
        this.licensePanel.setContentType("text/html");
        String Html = "<html><style type='text/css'>";
        Html = Html + "body,th,td,div,p,h1,h2,li,dt,dd ";
        Html = Html + "{ font-family: Tahoma, \"Gill Sans\", Arial, sans-serif; }";
        Html = Html + "body { margin: 0px; color: #333333; background-color: #ffffff; }";
        Html = Html + "#indent { padding-left: 30px; }";
        Html = Html + "ul {list-style-type: none}";
        Html = Html + "</style><body>";
        Html = Html + licenseText;
        Html = Html + "</body></html>";
        this.licensePanel.setText(Html);
        this.licensePanel.setEditable(false);
        this.licensePanel.setCaretPosition(0);
    }

    class LicenseListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LicenseListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DownloadableInfo dInfo = (DownloadableInfo)value;
            this.setText(dInfo.getName());
            this.setToolTipText(dInfo.toString());
            this.setBackground(isSelected ? Color.gray : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    class LicenseListModel
    extends AbstractListModel {
        private List<DownloadableInfo> licenseObjs = new ArrayList<DownloadableInfo>();

        public void addElement(DownloadableInfo obj) {
            this.licenseObjs.add(obj);
        }

        public void removeElement(int index) {
            this.licenseObjs.remove(index);
            this.fireContentsChanged(this, index, index);
        }

        public int getSize() {
            return this.licenseObjs.size();
        }

        public Object getElementAt(int index) {
            return this.licenseObjs.get(index);
        }
    }
}

