/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.data.readers.GMLException;
import cytoscape.data.readers.GMLParser;
import cytoscape.data.readers.KeyValue;
import cytoscape.data.readers.VisualStyleBuilder;
import cytoscape.init.CyInitParams;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.LayoutAdapter;
import cytoscape.logger.CyLogger;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import cytoscape.util.PercentUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.ArrowShape;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import giny.model.GraphObject;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMLReader
extends AbstractGraphReader {
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String LABEL = "label";
    protected static final String COMMENT = "comment";
    protected static final String VERSION = "Version";
    protected static final String CREATOR = "Creator";
    protected static final String TITLE = "Title";
    protected static final String GRAPH = "graph";
    protected static final String NODE = "node";
    protected static final String EDGE = "edge";
    protected static final String GRAPHICS = "graphics";
    protected static final String SOURCE = "source";
    protected static final String TARGET = "target";
    protected static final String X = "x";
    protected static final String Y = "y";
    protected static final String H = "h";
    protected static final String W = "w";
    protected static final String TYPE = "type";
    protected static final String ROOT_INDEX = "root_index";
    protected static final String RECTANGLE = "rectangle";
    protected static final String ELLIPSE = "ellipse";
    protected static final String LINE = "Line";
    protected static final String POINT = "point";
    protected static final String DIAMOND = "diamond";
    protected static final String HEXAGON = "hexagon";
    protected static final String OCTAGON = "octagon";
    protected static final String PARALELLOGRAM = "parallelogram";
    protected static final String TRIANGLE = "triangle";
    protected static final String FILL = "fill";
    protected static final String WIDTH = "width";
    protected static final String STRAIGHT_LINES = "line";
    protected static final String CURVED_LINES = "curved";
    protected static final String SOURCE_ARROW = "source_arrow";
    protected static final String TARGET_ARROW = "target_arrow";
    protected static final String YED_SOURCE_ARROW = "sourceArrow";
    protected static final String YED_TARGET_ARROW = "targetArrow";
    protected static final String YED_DELTA = "delta";
    protected static final String YED_STANDARD = "standard";
    protected static final String YED_DIAMOND = "diamond";
    protected static final String YED_SHORT = "short";
    protected static final String YED_WHITE_DELTA = "white_delta";
    protected static final String YED_WHITE_DIAMOND = "white_diamond";
    protected static final String ARROW = "arrow";
    protected static final String ARROW_NONE = "none";
    protected static final String ARROW_FIRST = "first";
    protected static final String ARROW_LAST = "last";
    protected static final String ARROW_BOTH = "both";
    protected static final String OUTLINE = "outline";
    protected static final String OUTLINE_WIDTH = "outline_width";
    protected static final String DEFAULT_EDGE_INTERACTION = "pp";
    private static final String VIZMAP_PREFIX = "vizmap:";
    private static final Color DEF_COLOR = new Color(153, 153, 255);
    private String vsbSwitch = CytoscapeInit.getProperties().getProperty("visualStyleBuilder");
    private VisualStyleBuilder graphStyle = null;
    private static CyLogger logger = CyLogger.getLogger(GMLReader.class);
    private List<KeyValue> keyVals;
    OpenIntIntHashMap nodeIDMap;
    IntArrayList nodes;
    IntArrayList sources;
    IntArrayList targets;
    private List<String> nodeLabels;
    private List<String> edgeLabels;
    private List<Map<String, Object>> nodeAttributes;
    private List<Map<String, Object>> edgeAttributes;
    Vector edge_root_index_pairs;
    Vector node_root_index_pairs;
    private List<String> edgeNames;
    private List<String> nodeNames;
    IntArrayList giny_nodes;
    IntArrayList giny_edges;
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;
    private String styleName;
    HashMap nodeW;
    HashMap nodeH;
    HashMap<String, NodeShape> nodeShape;
    HashMap nodeCol;
    HashMap<String, Double> nodeBWidth;
    HashMap nodeBCol;
    HashMap edgeCol;
    HashMap<String, Float> edgeWidth;
    HashMap<String, String> edgeArrow;
    HashMap edgeShape;
    InputStream inputStream = null;

    public GMLReader(String filename) {
        this(filename, null);
    }

    public GMLReader(InputStream is, String name) {
        super(name);
        this.styleName = this.createVSName();
        this.initializeHash();
        this.initStyle();
        this.inputStream = is;
    }

    public GMLReader(String filename, TaskMonitor taskMonitor) {
        super(filename);
        this.inputStream = FileUtil.getInputStream(filename);
        this.styleName = this.createVSName();
        this.initializeHash();
        this.initStyle();
        if (taskMonitor != null) {
            this.taskMonitor = taskMonitor;
            this.percentUtil = new PercentUtil(5);
        }
    }

    @Override
    public void setTaskMonitor(TaskMonitor monitor) {
        this.taskMonitor = monitor;
        this.percentUtil = new PercentUtil(3);
    }

    private String createVSName() {
        return this.getNetworkName();
    }

    private void initializeHash() {
        this.edgeNames = new ArrayList<String>();
        this.nodeNames = new ArrayList<String>();
        this.nodeAttributes = new ArrayList<Map<String, Object>>();
        this.edgeAttributes = new ArrayList<Map<String, Object>>();
    }

    private void initStyle() {
        this.graphStyle = new VisualStyleBuilder(this.styleName, false);
        this.graphStyle.setNodeSizeLocked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void read() {
        block6: {
            try {
                try {
                    this.keyVals = new GMLParser(this.inputStream).parseList();
                    Object var2_1 = null;
                    if (this.inputStream == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                    throw throwable;
                }
                this.inputStream.close();
            }
            catch (Exception io) {
                logger.warn("Error reading GML file: " + io.getMessage(), io);
                if (this.taskMonitor != null) {
                    this.taskMonitor.setException(io, io.getMessage());
                }
                throw new RuntimeException(io.getMessage());
            }
        }
        this.initializeStructures();
        this.readGML(this.keyVals);
        this.createGraph();
        this.extract();
        this.releaseStructures();
    }

    public List<KeyValue> getList() {
        return this.keyVals;
    }

    protected void initializeStructures() {
        this.title = null;
        this.nodes = new IntArrayList();
        this.sources = new IntArrayList();
        this.targets = new IntArrayList();
        this.nodeLabels = new ArrayList<String>();
        this.edgeLabels = new ArrayList<String>();
        this.edge_root_index_pairs = new Vector();
        this.node_root_index_pairs = new Vector();
    }

    protected void releaseStructures() {
        this.nodes = null;
        this.sources = null;
        this.targets = null;
        this.nodeLabels = null;
        this.edgeLabels = null;
        this.edge_root_index_pairs = null;
        this.node_root_index_pairs = null;
    }

    private void mapAttributes(GraphObject obj, CyAttributes attrs, Map<String, Object> attrMap) {
        for (String attrName : attrMap.keySet()) {
            Object attrVal = attrMap.get(attrName);
            if (attrVal == null) continue;
            try {
                if (attrVal instanceof Double) {
                    attrs.setAttribute(obj.getIdentifier(), attrName, (Double)attrVal);
                    continue;
                }
                if (attrVal instanceof Integer) {
                    attrs.setAttribute(obj.getIdentifier(), attrName, (Integer)attrVal);
                    continue;
                }
                attrs.setAttribute(obj.getIdentifier(), attrName, attrVal.toString());
            }
            catch (IllegalArgumentException e) {}
        }
    }

    protected void createGraph() {
        Cytoscape.ensureCapacity(this.nodes.size(), this.sources.size());
        this.nodeIDMap = new OpenIntIntHashMap(this.nodes.size());
        this.giny_nodes = new IntArrayList(this.nodes.size());
        OpenIntIntHashMap gml_id2order = new OpenIntIntHashMap(this.nodes.size());
        HashSet<String> nodeNameSet = new HashSet<String>(this.nodes.size());
        CyAttributes nodeAttr = Cytoscape.getNodeAttributes();
        for (int idx = 0; idx < this.nodes.size(); ++idx) {
            CyNode node;
            String label;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(2, idx, this.nodes.size()));
            }
            if (nodeNameSet.add(label = this.nodeLabels.get(idx))) {
                node = Cytoscape.getCyNode(label, true);
                if (this.nodeLabels.get(idx) != null) {
                    nodeAttr.setAttribute(node.getIdentifier(), LABEL, this.nodeLabels.get(idx));
                }
                if (this.nodeNames.get(idx) != null) {
                    nodeAttr.setAttribute(node.getIdentifier(), NAME, this.nodeNames.get(idx));
                }
            } else {
                throw new GMLException("GML id " + this.nodes.get(idx) + " has a duplicated ID: " + label);
            }
            this.mapAttributes(node, nodeAttr, this.nodeAttributes.get(idx));
            this.giny_nodes.add(node.getRootGraphIndex());
            this.nodeIDMap.put(this.nodes.get(idx), node.getRootGraphIndex());
            gml_id2order.put(this.nodes.get(idx), idx);
            ((KeyValue)this.node_root_index_pairs.get((int)idx)).value = new Integer(node.getRootGraphIndex());
        }
        nodeNameSet = null;
        this.giny_edges = new IntArrayList(this.sources.size());
        HashSet<String> edgeNameSet = new HashSet<String>(this.sources.size());
        CyAttributes edgeAttr = Cytoscape.getEdgeAttributes();
        for (int idx = 0; idx < this.sources.size(); ++idx) {
            CyEdge edge;
            String edgeName;
            String label;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(3, idx, this.sources.size()));
            }
            if (gml_id2order.containsKey(this.sources.get(idx)) && gml_id2order.containsKey(this.targets.get(idx))) {
                label = this.edgeLabels.get(idx);
                String sourceName = this.nodeLabels.get(gml_id2order.get(this.sources.get(idx)));
                String targetName = this.nodeLabels.get(gml_id2order.get(this.targets.get(idx)));
                edgeName = CyEdge.createIdentifier(sourceName, label, targetName);
                int duplicate_count = 1;
                while (!edgeNameSet.add(edgeName)) {
                    edgeName = CyEdge.createIdentifier(sourceName, label, targetName) + "_" + duplicate_count;
                    ++duplicate_count;
                }
                this.edgeNames.add(idx, edgeName);
                edge = Cytoscape.getRootGraph().getEdge(edgeName);
                if (edge == null) {
                    CyNode node_1 = Cytoscape.getCyNode(sourceName);
                    CyNode node_2 = Cytoscape.getCyNode(targetName);
                    edge = Cytoscape.getCyEdge(node_1, node_2, "interaction", label, true, true);
                }
            } else {
                throw new GMLException("Non-existant source/target node for edge with gml (source,target): " + this.sources.get(idx) + "," + this.targets.get(idx));
            }
            edge.setIdentifier(edgeName);
            edgeAttr.setAttribute(edgeName, "interaction", label);
            this.mapAttributes(edge, edgeAttr, this.edgeAttributes.get(idx));
            this.giny_edges.add(edge.getRootGraphIndex());
            ((KeyValue)this.edge_root_index_pairs.get((int)idx)).value = new Integer(edge.getRootGraphIndex());
        }
        edgeNameSet = null;
    }

    protected void readGML(List<KeyValue> list) {
        int counter = 0;
        int size = list.size();
        for (KeyValue keyVal : list) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(1, counter, size));
                ++counter;
            }
            if (keyVal.key.equals(GRAPH)) {
                this.readGraph((List)keyVal.value);
            }
            if (!keyVal.key.equals(TITLE)) continue;
            this.title = (String)keyVal.value;
        }
    }

    protected void readGraph(List<KeyValue> list) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.readNode((List)keyVal.value);
            }
            if (!keyVal.key.equals(EDGE)) continue;
            this.readEdge((List)keyVal.value);
        }
    }

    private void readNode(List<KeyValue> list) {
        String label = "";
        String name = null;
        HashMap<String, Object> attr = new HashMap<String, Object>();
        boolean contains_id = false;
        int id = 0;
        KeyValue root_index_pair = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ID)) {
                contains_id = true;
                id = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = keyVal.value.toString();
                continue;
            }
            if (keyVal.key.equals(NAME)) {
                name = keyVal.value.toString();
                continue;
            }
            if (keyVal.key.equals(ROOT_INDEX)) {
                root_index_pair = keyVal;
                continue;
            }
            if (keyVal.key.equals(GRAPHICS) || keyVal.key.startsWith(VIZMAP_PREFIX)) continue;
            attr.put(keyVal.key, keyVal.value);
        }
        if (label.equals("") || label.matches("\\s+")) {
            label = String.valueOf(id);
        }
        if (root_index_pair == null) {
            root_index_pair = new KeyValue(ROOT_INDEX, null);
            list.add(root_index_pair);
        }
        if (!contains_id) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new GMLException("The node-associated list\n" + stringWriter + "is missing an id field");
        }
        this.node_root_index_pairs.add(root_index_pair);
        this.nodes.add(id);
        this.nodeLabels.add(label);
        this.nodeNames.add(name);
        this.nodeAttributes.add(attr);
    }

    protected void readEdge(List<KeyValue> list) {
        String label = DEFAULT_EDGE_INTERACTION;
        boolean contains_source = false;
        boolean contains_target = false;
        int source = 0;
        int target = 0;
        KeyValue root_index_pair = null;
        HashMap<String, Object> attr = new HashMap<String, Object>();
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(SOURCE)) {
                contains_source = true;
                source = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(TARGET)) {
                contains_target = true;
                target = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(ROOT_INDEX)) {
                root_index_pair = keyVal;
                continue;
            }
            if (keyVal.key.equals(GRAPHICS) || keyVal.key.startsWith(VIZMAP_PREFIX)) continue;
            attr.put(keyVal.key, keyVal.value);
        }
        if (root_index_pair == null) {
            root_index_pair = new KeyValue(ROOT_INDEX, null);
            list.add(root_index_pair);
        }
        if (!contains_source || !contains_target) {
            StringWriter stringWriter = new StringWriter();
            try {
                GMLParser.printList(list, stringWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            throw new GMLException("The edge-associated list\n" + stringWriter + " is missing a source or target key");
        }
        this.sources.add(source);
        this.targets.add(target);
        this.edgeLabels.add(label);
        this.edge_root_index_pairs.add(root_index_pair);
        this.edgeAttributes.add(attr);
    }

    @Override
    public CyLayoutAlgorithm getLayoutAlgorithm() {
        return new LayoutAdapter(){

            public void doLayout(CyNetworkView networkView, TaskMonitor monitor) {
                GMLReader.this.layout(networkView);
            }
        };
    }

    public void layout(CyNetworkView myView) {
        if (myView == null || myView.nodeCount() == 0) {
            return;
        }
        if (this.keyVals == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        for (KeyValue keyVal : this.keyVals) {
            if (!keyVal.key.equals(GRAPH)) continue;
            this.layoutGraph(myView, (List)keyVal.value);
        }
    }

    public void extract() {
        if (this.keyVals == null) {
            throw new RuntimeException("Failed to read gml file on initialization");
        }
        for (KeyValue keyVal : this.keyVals) {
            if (!keyVal.key.equals(GRAPH)) continue;
            this.extractGraph((List)keyVal.value);
        }
    }

    protected void extractGraph(List list) {
        String edgeName = null;
        int ePtr = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(NODE)) {
                this.extractNode((List)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(EDGE)) continue;
            edgeName = this.edgeNames.get(ePtr);
            ++ePtr;
            this.extractEdge((List)keyVal.value, edgeName);
        }
    }

    protected void extractNode(List list) {
        List graphics_list = null;
        String label = null;
        int tempid = 0;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value != null) continue;
                return;
            }
            if (keyVal.key.equals(GRAPHICS)) {
                graphics_list = (List)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ID)) continue;
            tempid = (Integer)keyVal.value;
        }
        if (graphics_list != null) {
            if (label == null) {
                label = NODE + tempid;
                logger.info("Warning: node label is missing for node ID: " + tempid);
            }
            this.extractNodeAttributes(graphics_list, label);
        }
    }

    protected void extractEdge(List<KeyValue> list, String edgeName) {
        List graphics_list = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value != null) continue;
                return;
            }
            if (!keyVal.key.equals(GRAPHICS)) continue;
            graphics_list = (List)keyVal.value;
        }
        if (graphics_list != null) {
            this.extractEdgeAttributes(graphics_list, edgeName);
        }
    }

    protected void layoutGraph(GraphView myView, List list) {
        Object edgeName = null;
        boolean ePtr = false;
        for (KeyValue keyVal : list) {
            if (!keyVal.key.equals(NODE)) continue;
            this.layoutNode(myView, (List)keyVal.value);
        }
    }

    protected void layoutNode(GraphView myView, List list) {
        Integer root_index = null;
        List graphics_list = null;
        String label = null;
        int tempid = 0;
        NodeView view = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value == null) {
                    return;
                }
                root_index = (Integer)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(GRAPHICS)) {
                graphics_list = (List)keyVal.value;
                continue;
            }
            if (keyVal.key.equals(LABEL)) {
                label = (String)keyVal.value;
                continue;
            }
            if (!keyVal.key.equals(ID)) continue;
            tempid = (Integer)keyVal.value;
        }
        view = myView.getNodeView(root_index);
        if (label != null) {
            view.getLabel().setText(label);
        } else {
            view.getLabel().setText("node(" + tempid + ")");
        }
        if (graphics_list != null) {
            this.layoutNodeGraphics(myView, graphics_list, view);
        }
    }

    protected void layoutNodeGraphics(GraphView myView, List list, NodeView nodeView) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(X)) {
                nodeView.setXPosition(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(Y)) {
                nodeView.setYPosition(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(H)) {
                nodeView.setHeight(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(W)) {
                nodeView.setWidth(((Number)keyVal.value).doubleValue());
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                nodeView.setUnselectedPaint(this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(OUTLINE)) {
                nodeView.setBorderPaint(this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(OUTLINE_WIDTH)) {
                nodeView.setBorderWidth(((Number)keyVal.value).floatValue());
                continue;
            }
            if (!keyVal.key.equals(TYPE)) continue;
            String type = (String)keyVal.value;
            if (type.equals(ELLIPSE)) {
                nodeView.setShape(2);
                continue;
            }
            if (type.equals(RECTANGLE)) {
                nodeView.setShape(6);
                continue;
            }
            if (type.equals("diamond")) {
                nodeView.setShape(1);
                continue;
            }
            if (type.equals(HEXAGON)) {
                nodeView.setShape(3);
                continue;
            }
            if (type.equals(OCTAGON)) {
                nodeView.setShape(4);
                continue;
            }
            if (type.equals(PARALELLOGRAM)) {
                nodeView.setShape(5);
                continue;
            }
            if (!type.equals(TRIANGLE)) continue;
            nodeView.setShape(0);
        }
    }

    protected void extractNodeAttributes(List list, String nodeName) {
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(X) || keyVal.key.equals(Y)) continue;
            if (keyVal.key.equals(H)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_HEIGHT, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(W)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_WIDTH, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_FILL_COLOR, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(OUTLINE)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_BORDER_COLOR, "" + keyVal.value);
                continue;
            }
            if (keyVal.key.equals(WIDTH)) {
                this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_LINE_WIDTH, "" + keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(TYPE)) continue;
            String type = (String)keyVal.value;
            this.graphStyle.addProperty(nodeName, VisualPropertyType.NODE_SHAPE, type);
        }
    }

    protected void extractEdgeAttributes(List<KeyValue> list, String edgeName) {
        String value = null;
        boolean isArrow = false;
        String edgeFill = DEF_COLOR.toString();
        String arrowShape = ARROW_NONE;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(LINE)) continue;
            if (keyVal.key.equals(WIDTH)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_LINE_WIDTH, new String(keyVal.value.toString()));
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_COLOR, new String(keyVal.value.toString()));
                edgeFill = keyVal.value.toString();
                continue;
            }
            if (keyVal.key.equals(ARROW)) {
                isArrow = true;
                ArrowShape shape = ArrowShape.ARROW;
                String arrowName = shape.getName();
                if (keyVal.value.toString().equalsIgnoreCase(ARROW_FIRST)) {
                    arrowShape = ARROW_FIRST;
                    this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, arrowName);
                    continue;
                }
                if (keyVal.value.toString().equalsIgnoreCase(ARROW_LAST)) {
                    arrowShape = ARROW_LAST;
                    this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, arrowName);
                    continue;
                }
                if (!keyVal.value.toString().equalsIgnoreCase(ARROW_BOTH)) continue;
                arrowShape = ARROW_BOTH;
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, arrowName);
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, arrowName);
                continue;
            }
            if (keyVal.key.equals(TYPE)) {
                value = (String)keyVal.value;
                if (value.equals(STRAIGHT_LINES) || !value.equals(CURVED_LINES)) continue;
                continue;
            }
            if (keyVal.key.equals(SOURCE_ARROW)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, ArrowShape.getArrowShape(((Number)keyVal.value).intValue()).getName());
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
                continue;
            }
            if (keyVal.key.equals(TARGET_ARROW)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, ArrowShape.getArrowShape(((Number)keyVal.value).intValue()).getName());
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
                continue;
            }
            if (keyVal.key.equals(YED_SOURCE_ARROW)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_SHAPE, this.convertYEDArrowShape(keyVal.value.toString()));
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
                continue;
            }
            if (!keyVal.key.equals(YED_TARGET_ARROW)) continue;
            this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_SHAPE, this.convertYEDArrowShape(keyVal.value.toString()));
            this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
        }
        if (isArrow) {
            if (arrowShape.equals(ARROW_FIRST)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
            } else if (arrowShape.equals(ARROW_LAST)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
            } else if (arrowShape.equals(ARROW_BOTH)) {
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_SRCARROW_COLOR, edgeFill);
                this.graphStyle.addProperty(edgeName, VisualPropertyType.EDGE_TGTARROW_COLOR, edgeFill);
            }
        }
    }

    private String convertYEDArrowShape(String yedArrow) {
        String shape = ArrowShape.NONE.getName();
        if (yedArrow.equals(YED_DELTA) || yedArrow.equals(YED_WHITE_DELTA)) {
            shape = ArrowShape.DELTA.getName();
        } else if (yedArrow.equals("diamond") || yedArrow.equals(YED_WHITE_DIAMOND)) {
            shape = ArrowShape.DIAMOND.getName();
        } else if (yedArrow.equals(YED_STANDARD) || yedArrow.equals(YED_SHORT)) {
            shape = ArrowShape.ARROW.getName();
        }
        return shape;
    }

    public void showMaps() {
        String e = null;
        Object n = null;
        String temp = null;
        for (int i = 0; i < this.edgeNames.size(); ++i) {
            e = this.edgeNames.get(i);
            temp = e + ": ";
            temp = temp + this.edgeCol.get(e) + ", ";
            temp = temp + this.edgeWidth.get(e) + ", ";
            temp = temp + this.edgeArrow.get(e) + ", ";
            temp = temp + this.edgeShape.get(e) + ", ";
            logger.info(temp);
            temp = null;
        }
    }

    protected void layoutEdge(GraphView myView, List list, String edgeName) {
        EdgeView edgeView = null;
        List graphics_list = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(ROOT_INDEX)) {
                if (keyVal.value == null) {
                    return;
                }
                edgeView = myView.getEdgeView((Integer)keyVal.value);
                continue;
            }
            if (!keyVal.key.equals(GRAPHICS)) continue;
            graphics_list = (List)keyVal.value;
        }
        if (edgeView != null && graphics_list != null) {
            this.layoutEdgeGraphics(myView, graphics_list, edgeView);
        }
    }

    protected void layoutEdgeGraphics(GraphView myView, List<KeyValue> list, EdgeView edgeView) {
        String value = null;
        for (KeyValue keyVal : list) {
            if (keyVal.key.equals(LINE)) {
                this.layoutEdgeGraphicsLine(myView, (List)keyVal.value, edgeView);
                continue;
            }
            if (keyVal.key.equals(WIDTH)) {
                edgeView.setStrokeWidth(((Number)keyVal.value).floatValue());
                continue;
            }
            if (keyVal.key.equals(FILL)) {
                edgeView.setUnselectedPaint(this.getColor((String)keyVal.value));
                continue;
            }
            if (keyVal.key.equals(TYPE)) {
                value = (String)keyVal.value;
                if (value.equals(STRAIGHT_LINES)) {
                    edgeView.setLineType(2);
                    continue;
                }
                if (!value.equals(CURVED_LINES)) continue;
                edgeView.setLineType(1);
                continue;
            }
            if (keyVal.key.equals(ARROW)) {
                if (keyVal.value.equals(ARROW_FIRST)) {
                    edgeView.setSourceEdgeEnd(2);
                    continue;
                }
                if (keyVal.value.equals(ARROW_LAST)) {
                    edgeView.setTargetEdgeEnd(2);
                    continue;
                }
                if (keyVal.value.equals(ARROW_BOTH)) {
                    edgeView.setSourceEdgeEnd(2);
                    edgeView.setTargetEdgeEnd(2);
                    continue;
                }
                if (!keyVal.value.equals(ARROW_NONE)) continue;
                continue;
            }
            if (keyVal.key.equals(SOURCE_ARROW)) {
                edgeView.setSourceEdgeEnd(((Number)keyVal.value).intValue());
                continue;
            }
            if (!keyVal.key.equals(TARGET_ARROW)) continue;
            edgeView.setTargetEdgeEnd(((Number)keyVal.value).intValue());
        }
    }

    protected void layoutEdgeGraphicsLine(GraphView myView, List list, EdgeView edgeView) {
        for (KeyValue keyVal : list) {
            if (!keyVal.key.equals(POINT)) continue;
            Number x = null;
            Number y = null;
            for (KeyValue pointVal : (List)keyVal.value) {
                if (pointVal.key.equals(X)) {
                    x = (Number)pointVal.value;
                    continue;
                }
                if (!pointVal.key.equals(Y)) continue;
                y = (Number)pointVal.value;
            }
            if (x == null || y == null) continue;
            Point2D.Double pt = new Point2D.Double(x.doubleValue(), y.doubleValue());
            edgeView.getBend().addHandle(pt);
        }
    }

    @Override
    public int[] getNodeIndicesArray() {
        this.giny_nodes.trimToSize();
        return this.giny_nodes.elements();
    }

    @Override
    public int[] getEdgeIndicesArray() {
        this.giny_edges.trimToSize();
        return this.giny_edges.elements();
    }

    public Color getColor(String colorString) {
        return new Color(Integer.parseInt(colorString.substring(1), 16));
    }

    @Override
    public void doPostProcessing(CyNetwork net) {
        CyInitParams init = CytoscapeInit.getCyInitParams();
        if (init == null) {
            return;
        }
        if (!(init.getMode() != 1 && init.getMode() != 4 || this.vsbSwitch != null && this.vsbSwitch.equals("off"))) {
            this.graphStyle.buildStyle();
        }
    }
}

