/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.ontology;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.ontology.OntologyTerm;
import cytoscape.data.ontology.Triple;
import cytoscape.data.ontology.readers.OBOTags;
import cytoscape.data.readers.MetadataEntries;
import cytoscape.data.readers.MetadataParser;
import giny.model.Node;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.OntologyOps;
import org.biojava.ontology.Term;
import org.biojava.ontology.Variable;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeVetoException;

public class Ontology
extends AbstractChangeable
implements org.biojava.ontology.Ontology {
    private static final String CURATOR = "curator";
    private static final String OBO_FORMAT = "OBO Flat File";
    private static final String DATA_TYPE = "Ontology DAG";
    public static final String IS_ONTOLOGY = "Is_Ontology";
    protected String name;
    protected MetadataParser metaParser;
    private final OntologyOps ops;
    private CyNetwork ontologyGraph;
    private CyAttributes ontologyAttr = Cytoscape.getNetworkAttributes();
    private CyAttributes termAttr = Cytoscape.getNodeAttributes();

    public Ontology(String name) {
        this(name, null, null, null);
    }

    public Ontology(String name, String curator, String description, CyNetwork dag) {
        this.name = name;
        this.ops = new OntologyOps(){

            public Set getRemoteTerms() {
                return null;
            }
        };
        this.ontologyGraph = dag == null ? Cytoscape.createNetwork(this.name) : dag;
        this.ontologyAttr.setAttribute(this.ontologyGraph.getIdentifier(), IS_ONTOLOGY, true);
        this.ontologyAttr.setUserEditable(IS_ONTOLOGY, false);
        this.ontologyAttr.setUserVisible(IS_ONTOLOGY, false);
        this.metaParser = new MetadataParser(this.ontologyGraph);
        this.metaParser.setMetadata(MetadataEntries.TITLE, name);
        this.metaParser.setMetadata(MetadataEntries.FORMAT, OBO_FORMAT);
        this.metaParser.setMetadata(MetadataEntries.TYPE, DATA_TYPE);
        if (curator != null) {
            this.ontologyAttr.setAttribute(this.ontologyGraph.getIdentifier(), CURATOR, curator);
        }
        if (description != null) {
            this.metaParser.setMetadata(MetadataEntries.DESCRIPTION, description);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCurator() {
        return this.ontologyAttr.getStringAttribute(this.ontologyGraph.getIdentifier(), CURATOR);
    }

    public void add(OntologyTerm newTerm) {
        CyNode newOntologyTerm = Cytoscape.getCyNode(newTerm.getName(), true);
        this.ontologyGraph.addNode(newOntologyTerm);
        this.termAttr.setAttribute(newOntologyTerm.getIdentifier(), OBOTags.DEF.toString(), newTerm.getDescription());
    }

    public int size() {
        return this.ontologyGraph.getNodeCount();
    }

    public Set getTerms() {
        HashSet<OntologyTerm> terms = new HashSet<OntologyTerm>();
        Iterator nodeIt = this.ontologyGraph.nodesIterator();
        while (nodeIt.hasNext()) {
            Node node = (Node)nodeIt.next();
            String id = node.getIdentifier();
            OntologyTerm term = new OntologyTerm(node.getIdentifier(), this.name, this.termAttr.getStringAttribute(id, OBOTags.DEF.toString()));
            terms.add(term);
        }
        return terms;
    }

    public boolean containsTerm(String id) {
        CyNode testNode = Cytoscape.getCyNode(id, false);
        return testNode != null;
    }

    public OntologyTerm getTerm(String id) {
        OntologyTerm term = new OntologyTerm(id, this.name, this.termAttr.getStringAttribute(id, OBOTags.DEF.toString()));
        return term;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Ontology Name: " + this.name + ", ");
        sb.append("Curator: " + this.ontologyAttr.getStringAttribute(this.ontologyGraph.getIdentifier(), CURATOR) + ", ");
        sb.append("Description: " + this.getDescription());
        return sb.toString();
    }

    public boolean containsTriple(Term subject, Term object, Term predicate) {
        CyNode source = Cytoscape.getCyNode(subject.getName());
        CyNode target = Cytoscape.getCyNode(object.getName());
        String interaction = predicate.getName();
        if (source == null || target == null) {
            return false;
        }
        return Cytoscape.getCyEdge(source, target, "interaction", interaction, false) != null;
    }

    public Term createTerm(String name, String description) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        CyNode newNode = Cytoscape.getCyNode(name, true);
        this.ontologyGraph.addNode(newNode);
        this.termAttr.setAttribute(name, MetadataEntries.DESCRIPTION.toString(), description);
        OntologyTerm newTerm = new OntologyTerm(name, this.name, description);
        return newTerm;
    }

    public Term createTerm(String arg0, String arg1, Object[] arg2) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        return null;
    }

    public org.biojava.ontology.Triple createTriple(Term subject, Term object, Term predicate, String name, String description) throws AlreadyExistsException, ChangeVetoException {
        Triple newTriple = new Triple(subject, object, predicate, name, description);
        return newTriple;
    }

    public Variable createVariable(String arg0, String arg1) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
        return null;
    }

    public void deleteTerm(Term arg0) throws ChangeVetoException {
        this.ontologyGraph.removeNode(Cytoscape.getRootGraph().getNode(arg0.getName()).getRootGraphIndex(), true);
    }

    public String getDescription() {
        return this.metaParser.getMetadataMap().get(MetadataEntries.DESCRIPTION.toString()).toString();
    }

    public OntologyOps getOps() {
        return this.ops;
    }

    public Set getTriples(Term arg0, Term arg1, Term arg2) {
        return null;
    }

    public Term importTerm(Term arg0, String arg1) throws ChangeVetoException, IllegalArgumentException {
        return null;
    }
}

