/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.data.annotation.Ontology;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

@Deprecated
public class Annotation
implements Serializable {
    protected Ontology ontology;
    protected String curator;
    protected String species;
    protected String type;
    protected HashMap hash;

    public Annotation(String species, String type, Ontology ontology) {
        this.ontology = ontology;
        this.species = species;
        this.type = type;
        this.curator = ontology.getCurator();
        this.hash = new HashMap();
    }

    public Annotation(String species, String type, String curator) {
        this.curator = curator;
        this.species = species;
        this.type = type;
        this.hash = new HashMap();
    }

    public HashMap getMap() {
        return this.hash;
    }

    public void setOntology(Ontology newValue) {
        this.ontology = newValue;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public String getCurator() {
        return this.curator;
    }

    public String getType() {
        return this.type;
    }

    public String getOntologyType() {
        if (this.ontology != null) {
            return this.ontology.getType();
        }
        return "unknown";
    }

    public String getSpecies() {
        return this.species;
    }

    public void add(String name, int classificationID) {
        Vector classifications;
        if (this.hash.containsKey(name)) {
            classifications = (Vector)this.hash.get(name);
        } else {
            classifications = new Vector();
            this.hash.put(name, classifications);
        }
        Integer classificationInteger = new Integer(classificationID);
        if (!classifications.contains(classificationInteger)) {
            classifications.add(new Integer(classificationID));
        }
    }

    public String[] getNames() {
        return this.hash.keySet().toArray(new String[0]);
    }

    public int[] getClassifications() {
        Vector[] arrayOfIntegerVectors = this.hash.values().toArray(new Vector[0]);
        Vector collector = new Vector();
        for (int v = 0; v < arrayOfIntegerVectors.length; ++v) {
            Vector vec = arrayOfIntegerVectors[v];
            for (int i = 0; i < vec.size(); ++i) {
                collector.add(vec.get(i));
            }
        }
        int[] result = new int[collector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)collector.get(i);
        }
        return result;
    }

    public int[] getClassifications(String name) {
        if (!this.hash.containsKey(name)) {
            return new int[0];
        }
        Vector classifications = (Vector)this.hash.get(name);
        int[] result = new int[classifications.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)classifications.get(i);
        }
        return result;
    }

    public Vector getClassificationsVector(String name) {
        if (!this.hash.containsKey(name)) {
            return new Vector();
        }
        return (Vector)this.hash.get(name);
    }

    public String[][] getAllHierarchyPathsAsNames(String name) {
        int i;
        if (this.ontology == null) {
            return new String[0][0];
        }
        int[] leafClassifications = this.getClassifications(name);
        if (leafClassifications.length == 0) {
            String[][] stringArray = new String[0][0];
        }
        Vector<String[]> collector = new Vector<String[]>();
        for (i = 0; i < leafClassifications.length; ++i) {
            String[][] paths = this.ontology.getAllHierarchyPathsAsNames(leafClassifications[i]);
            for (int p = 0; p < paths.length; ++p) {
                collector.add(paths[p]);
            }
        }
        String[][] result = new String[collector.size()][];
        for (i = 0; i < collector.size(); ++i) {
            String[] path = (String[])collector.get(i);
            result[i] = path;
        }
        return result;
    }

    public int count() {
        return this.hash.size();
    }

    public int size() {
        String[] names = this.getNames();
        int total = 0;
        for (int i = 0; i < names.length; ++i) {
            total += ((Vector)this.hash.get(names[i])).size();
        }
        return total;
    }

    public int maxDepth() {
        if (this.ontology == null) {
            return 0;
        }
        int[] classifications = this.getClassifications();
        int max = 0;
        for (int i = 0; i < classifications.length; ++i) {
            int[][] paths = this.ontology.getAllHierarchyPaths(classifications[i]);
            for (int p = 0; p < paths.length; ++p) {
                if (paths[p].length <= max) continue;
                max = paths[p].length;
            }
        }
        return max;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("annotation: ");
        sb.append(this.getCurator());
        sb.append(", ");
        sb.append(this.type);
        sb.append(", ");
        sb.append(this.species);
        sb.append(" (" + this.count() + " entities)  ");
        sb.append(" (" + this.size() + " classifications)  ");
        return sb.toString();
    }
}

