/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.AttributeFilter;
import cytoscape.data.AttributeValueVisitor;
import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesUtils;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import giny.model.GraphObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.cytoscape.equations.EqnCompiler;
import org.cytoscape.equations.Equation;

public class CyAttributesUtilsTest
extends TestCase {
    private CyNode testNode1;
    private CyNode testNode2;
    private CyEdge testEdge;
    private List<Double> PValues = new ArrayList<Double>();
    private int numTSIs;
    private List<String> TSIValues = new ArrayList<String>();
    private int numPValues;
    private boolean initialized = false;

    public static void main(String[] args) {
        TestRunner.run(CyAttributesUtilsTest.class);
    }

    protected void setUp() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.testNode1 = Cytoscape.getCyNode("testNode1", true);
        this.testNode2 = Cytoscape.getCyNode("testNode2", true);
        this.testEdge = Cytoscape.getCyEdge(this.testNode1.getIdentifier(), "Interaction Value", this.testNode2.getIdentifier(), "interaction");
        this.addAttributes(this.testNode1);
        this.addAttributes(this.testEdge);
    }

    public void testToString() {
        CyAttributes attrs = Cytoscape.getNodeAttributes();
        Assert.assertTrue("BOOLEAN".equals(CyAttributesUtils.toString(attrs.getType("BooleanTest"))));
        Assert.assertTrue("STRING".equals(CyAttributesUtils.toString(attrs.getType("StringTest"))));
        Assert.assertTrue("SIMPLE_MAP".equals(CyAttributesUtils.toString(attrs.getType("MapTest"))));
        Assert.assertTrue("SIMPLE_LIST".equals(CyAttributesUtils.toString(attrs.getType("ListTest"))));
        Assert.assertTrue("COMPLEX".equals(CyAttributesUtils.toString(attrs.getType("TextSourceInfo"))));
        Assert.assertTrue("UNDEFINED".equals(CyAttributesUtils.toString(attrs.getType("foo"))));
    }

    public void testTraverseAttributeValues() {
        CyAttributesUtils.traverseAttributeValues(this.testNode1.getIdentifier(), "BooleanTest", Cytoscape.getNodeAttributes(), new AttributeValueVisitor(){

            public void visitingAttributeValue(String objTraversedID, String attrName, CyAttributes attrs, Object[] keySpace, Object visitedValue) {
                Assert.assertTrue(Boolean.TRUE.equals(visitedValue));
            }
        });
        this.numTSIs = 0;
        CyAttributesUtils.traverseAttributeValues(this.testNode1.getIdentifier(), "TextSourceInfo", Cytoscape.getNodeAttributes(), new AttributeValueVisitor(){

            public void visitingAttributeValue(String objTraversedID, String attrName, CyAttributes attrs, Object[] keySpace, Object visitedValue) {
                CyAttributesUtilsTest.this.numTSIs++;
                Assert.assertTrue(CyAttributesUtilsTest.this.TSIValues.contains(visitedValue));
            }
        });
        Assert.assertTrue(this.numTSIs == this.TSIValues.size());
        this.numPValues = 0;
        CyAttributesUtils.traverseAttributeValues(this.testNode1.getIdentifier(), "p-valuesTest", Cytoscape.getNodeAttributes(), new AttributeValueVisitor(){

            public void visitingAttributeValue(String objTraversedID, String attrName, CyAttributes attrs, Object[] keySpace, Object visitedValue) {
                CyAttributesUtilsTest.this.numPValues++;
                Assert.assertTrue(CyAttributesUtilsTest.this.PValues.contains(visitedValue));
            }
        });
        Assert.assertTrue(this.numPValues == this.PValues.size());
    }

    public void testCopyAttributes() {
        CyNode copyTestNode1 = Cytoscape.getCyNode("copyTestNode1", true);
        CyAttributes attrs = Cytoscape.getNodeAttributes();
        CyAttributesUtils.copyAttributes(this.testNode1.getIdentifier(), copyTestNode1.getIdentifier(), attrs, false);
        this.testAttributes(copyTestNode1);
        CyAttributesUtils.copyAttributes(this.testNode1.getIdentifier(), "copyAnotherTestNode1", attrs, new AttributeFilter(){

            public boolean includeAttribute(CyAttributes attrs, String objID, String attrName) {
                return "IntegerTest".equals(attrName);
            }
        }, false);
        Assert.assertTrue(new Integer(6).equals(attrs.getIntegerAttribute("copyAnotherTestNode1", "IntegerTest")));
        List<String> attrNames = CyAttributesUtils.getAttributeNamesForObj("copyAnotherTestNode1", attrs);
        Assert.assertTrue(attrNames.size() == 1);
    }

    public void testCopyAttribute() {
        CyNode testNode3 = Cytoscape.getCyNode("testNode3", true);
        CyEdge testEdgeCopy = Cytoscape.getCyEdge(this.testNode1.getIdentifier(), "Interaction Value", testNode3.getIdentifier(), "interaction");
        CyAttributes attrs = Cytoscape.getEdgeAttributes();
        CyAttributesUtils.copyAttribute(this.testEdge.getIdentifier(), testEdgeCopy.getIdentifier(), "ListTest", attrs, false);
        List listVal = attrs.getListAttribute(testEdgeCopy.getIdentifier(), "ListTest");
        Assert.assertTrue(listVal.size() == 2 && listVal.contains("list test value1") && listVal.contains("list test value2"));
        List<String> attrNames = CyAttributesUtils.getAttributeNamesForObj(testEdgeCopy.getIdentifier(), attrs);
        Assert.assertTrue(attrNames.size() == 3);
    }

    private void addAttributes(GraphObject go) {
        String goID = go.getIdentifier();
        CyAttributes attrs = null;
        if (go instanceof CyNode) {
            attrs = Cytoscape.getNodeAttributes();
        } else if (go instanceof CyEdge) {
            attrs = Cytoscape.getEdgeAttributes();
        }
        attrs.setAttribute(goID, "BooleanTest", new Boolean(true));
        attrs.setAttribute(goID, "StringTest", "string test value");
        attrs.setAttribute(goID, "IntegerTest", new Integer(6));
        attrs.setAttribute(goID, "DoubleTest", new Double(5.0));
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        EqnCompiler compiler = new EqnCompiler();
        compiler.compile("=ABS(-13) + 12.3", attribNameToTypeMap);
        Equation equation = compiler.getEquation();
        attrs.setAttribute(goID, "EquationTest", equation);
        ArrayList<String> listTestValue = new ArrayList<String>();
        listTestValue.add("list test value1");
        listTestValue.add("list test value2");
        attrs.setListAttribute(goID, "ListTest", listTestValue);
        HashMap<String, String> mapTestValue = new HashMap<String, String>();
        mapTestValue.put("map key1", "map key1 value");
        mapTestValue.put("map key2", "map key2 value");
        attrs.setMapAttribute(goID, "MapTest", mapTestValue);
        this.addComplexAttributes(go, attrs);
    }

    private void addComplexAttributes(GraphObject go, CyAttributes attrs) {
        String goID = go.getIdentifier();
        MultiHashMap mmap = attrs.getMultiHashMap();
        MultiHashMapDefinition mmapDef = attrs.getMultiHashMapDefinition();
        if (mmapDef.getAttributeValueType("p-valuesTest") < 0) {
            mmapDef.defineAttribute("p-valuesTest", (byte)2, new byte[]{4, 3});
        }
        if (mmapDef.getAttributeValueType("TextSourceInfo") < 0) {
            mmapDef.defineAttribute("TextSourceInfo", (byte)4, new byte[]{4, 3, 3});
        }
        this.PValues.clear();
        mmap.setAttributeValue(goID, "p-valuesTest", new Double(0.5), new Object[]{"Jojo", new Integer(0)});
        this.PValues.add(new Double(0.5));
        mmap.setAttributeValue(goID, "p-valuesTest", new Double(0.6), new Object[]{"Jojo", new Integer(1)});
        this.PValues.add(new Double(0.6));
        mmap.setAttributeValue(goID, "p-valuesTest", new Double(0.6), new Object[]{"Jojo", new Integer(2)});
        this.PValues.add(new Double(0.6));
        mmap.setAttributeValue(goID, "p-valuesTest", new Double(0.7), new Object[]{"Harry", new Integer(0)});
        this.PValues.add(new Double(0.7));
        mmap.setAttributeValue(goID, "p-valuesTest", new Double(0.6), new Object[]{"Harry", new Integer(1)});
        this.PValues.add(new Double(0.6));
        this.TSIValues.clear();
        mmap.setAttributeValue(goID, "TextSourceInfo", "url1: sentence1", new Object[]{"url1", new Integer(0), new Integer(0)});
        this.TSIValues.add("url1: sentence1");
        mmap.setAttributeValue(goID, "TextSourceInfo", "url1: sentence2", new Object[]{"url1", new Integer(0), new Integer(1)});
        this.TSIValues.add("url1: sentence2");
        mmap.setAttributeValue(goID, "TextSourceInfo", "url1: sentence3", new Object[]{"url1", new Integer(0), new Integer(10)});
        this.TSIValues.add("url1: sentence3");
        mmap.setAttributeValue(goID, "TextSourceInfo", "url1: publication 1", new Object[]{"url1", new Integer(1), new Integer(0)});
        this.TSIValues.add("url1: publication 1");
        mmap.setAttributeValue(goID, "TextSourceInfo", "url2: sentence1", new Object[]{"url2", new Integer(0), new Integer(6)});
        this.TSIValues.add("url2: sentence1");
        mmap.setAttributeValue(goID, "TextSourceInfo", "url2: publication 1", new Object[]{"url2", new Integer(1), new Integer(0)});
        this.TSIValues.add("url2: publication 1");
    }

    private void testAttributes(GraphObject go) {
        String goID = go.getIdentifier();
        CyAttributes attrs = null;
        if (go instanceof CyNode) {
            attrs = Cytoscape.getNodeAttributes();
        } else if (go instanceof CyEdge) {
            attrs = Cytoscape.getEdgeAttributes();
        }
        Assert.assertTrue(Boolean.TRUE.equals(attrs.getBooleanAttribute(goID, "BooleanTest")));
        Assert.assertTrue("string test value".equals(attrs.getStringAttribute(goID, "StringTest")));
        Assert.assertTrue(new Integer(6).equals(attrs.getIntegerAttribute(goID, "IntegerTest")));
        Assert.assertTrue(new Double(5.0).equals(attrs.getDoubleAttribute(goID, "DoubleTest")));
        List listVal = attrs.getListAttribute(goID, "ListTest");
        Assert.assertTrue(listVal.size() == 2 && listVal.contains("list test value1") && listVal.contains("list test value2"));
        Map mapVal = attrs.getMapAttribute(goID, "MapTest");
        Assert.assertTrue(mapVal.size() == 2 && "map key1 value".equals(mapVal.get("map key1")) && "map key2 value".equals(mapVal.get("map key2")));
        this.testComplexAttributes(goID, attrs);
    }

    private void testComplexAttributes(String goID, CyAttributes attrs) {
        MultiHashMap mmap = attrs.getMultiHashMap();
        Assert.assertTrue(new Double(0.5).equals(mmap.getAttributeValue(goID, "p-valuesTest", new Object[]{"Jojo", new Integer(0)})));
        Assert.assertTrue(new Double(0.6).equals(mmap.getAttributeValue(goID, "p-valuesTest", new Object[]{"Jojo", new Integer(1)})));
        Assert.assertTrue(new Double(0.6).equals(mmap.getAttributeValue(goID, "p-valuesTest", new Object[]{"Jojo", new Integer(2)})));
        Assert.assertTrue(new Double(0.7).equals(mmap.getAttributeValue(goID, "p-valuesTest", new Object[]{"Harry", new Integer(0)})));
        Assert.assertTrue(new Double(0.6).equals(mmap.getAttributeValue(goID, "p-valuesTest", new Object[]{"Harry", new Integer(1)})));
        Assert.assertTrue("url1: sentence1".equals(mmap.getAttributeValue(goID, "TextSourceInfo", new Object[]{"url1", new Integer(0), new Integer(0)})));
        Assert.assertTrue("url1: sentence2".equals(mmap.getAttributeValue(goID, "TextSourceInfo", new Object[]{"url1", new Integer(0), new Integer(1)})));
        Assert.assertTrue("url1: sentence3".equals(mmap.getAttributeValue(goID, "TextSourceInfo", new Object[]{"url1", new Integer(0), new Integer(10)})));
        Assert.assertTrue("url1: publication 1".equals(mmap.getAttributeValue(goID, "TextSourceInfo", new Object[]{"url1", new Integer(1), new Integer(0)})));
        Assert.assertTrue("url2: sentence1".equals(mmap.getAttributeValue(goID, "TextSourceInfo", new Object[]{"url2", new Integer(0), new Integer(6)})));
        Assert.assertTrue("url2: publication 1".equals(mmap.getAttributeValue(goID, "TextSourceInfo", new Object[]{"url2", new Integer(1), new Integer(0)})));
    }

    public void testCopyAttribute2() {
        CyAttributes attribs = Cytoscape.getNodeAttributes();
        String sourceId = "testNode1";
        String targetId = "testNode2";
        StringBuilder errorMessage = new StringBuilder();
        CyAttributesUtilsTest.assertTrue(CyAttributesUtils.copyAttribute(attribs, "testNode1", "testNode2", "BooleanTest", false, errorMessage));
        CyAttributesUtilsTest.assertEquals(attribs.getBooleanAttribute("testNode1", "BooleanTest"), attribs.getBooleanAttribute("testNode2", "BooleanTest"));
        CyAttributesUtilsTest.assertTrue(CyAttributesUtils.copyAttribute(attribs, "testNode1", "testNode2", "IntegerTest", false, errorMessage));
        CyAttributesUtilsTest.assertEquals(attribs.getIntegerAttribute("testNode1", "IntegerTest"), attribs.getIntegerAttribute("testNode2", "IntegerTest"));
        CyAttributesUtilsTest.assertTrue(CyAttributesUtils.copyAttribute(attribs, "testNode1", "testNode2", "DoubleTest", false, errorMessage));
        CyAttributesUtilsTest.assertEquals(attribs.getDoubleAttribute("testNode1", "DoubleTest"), attribs.getDoubleAttribute("testNode2", "DoubleTest"));
        CyAttributesUtilsTest.assertTrue(CyAttributesUtils.copyAttribute(attribs, "testNode1", "testNode2", "StringTest", false, errorMessage));
        CyAttributesUtilsTest.assertEquals(attribs.getStringAttribute("testNode1", "StringTest"), attribs.getStringAttribute("testNode2", "StringTest"));
        CyAttributesUtilsTest.assertTrue(CyAttributesUtils.copyAttribute(attribs, "testNode1", "testNode2", "ListTest", false, errorMessage));
        CyAttributesUtilsTest.assertEquals(attribs.getListAttribute("testNode1", "ListTest"), attribs.getListAttribute("testNode2", "ListTest"));
        CyAttributesUtilsTest.assertTrue(CyAttributesUtils.copyAttribute(attribs, "testNode1", "testNode2", "MapTest", false, errorMessage));
        CyAttributesUtilsTest.assertEquals(attribs.getMapAttribute("testNode1", "MapTest"), attribs.getMapAttribute("testNode2", "MapTest"));
        CyAttributesUtilsTest.assertTrue(CyAttributesUtils.copyAttribute(attribs, "testNode1", "testNode2", "EquationTest", true, errorMessage));
        CyAttributesUtilsTest.assertEquals(attribs.getEquation("testNode1", "EquationTest"), attribs.getEquation("testNode2", "EquationTest"));
    }
}

