/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.Composition;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.CompositionFactory;
import com.sun.glf.util.CompositionPaintMonitor;
import com.sun.glf.util.DefaultFileFilter;
import com.sun.glf.util.ImageEncoder;
import com.sun.glf.util.SerializedBeanFileFilter;
import com.sun.glf.util.TextBeans;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public class CompositionFrame
extends JFrame {
    static final String BEANS_SAVED = "Beans saved";
    static final String ERROR_CANNOT_SERIALIZE_BEANS = "Error. Cannot serialize bean: ";
    static final String ERROR_UNKNOWN_FORMAT = "Unable to save. Unknown format : ";
    static final String FILE_EXIST_OVERRIDE = "File already exists. Overwrite?";
    static final String CONFIRM = "Confirm";
    static final String COULD_NOT_SAVE_IMAGE = "Could not save image";
    static final String COULD_NOT_LOAD_COMPOSITION = "Could not load Composition";
    static final String PLEASE_WAIT = "Please, Wait while image is loading...";
    static final String SAVE_AS_IMAGE = "Save image...";
    static final int MONITOR_MARGIN = 5;
    private static int curThread = 0;
    private static Dimension defaultSize = new Dimension(300, 50);
    private JPopupMenu menu;
    CompositionLoadThread loadingThread;
    CompositionComponent comp;
    CompositionPaintMonitor paintMonitor = new CompositionPaintMonitor();
    boolean isSaveEnabled = true;
    byte[] serializedFactory;
    static JFileChooser fileChooser;
    static SerializedBeanFileFilter serializedBeanFilter;
    static Map encoderMap;
    static /* synthetic */ Class class$com$sun$glf$util$CompositionFrame;

    private void init() {
        try {
            Object object;
            Object object2;
            Object object3;
            fileChooser = new JFileChooser();
            fileChooser.setDialogType(1);
            fileChooser.setFileSelectionMode(0);
            InputStream inputStream = (class$com$sun$glf$util$CompositionFrame == null ? (class$com$sun$glf$util$CompositionFrame = CompositionFrame.class$("com.sun.glf.util.CompositionFrame")) : class$com$sun$glf$util$CompositionFrame).getResourceAsStream("/com/sun/glf/res/encoders.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            encoderMap = new Hashtable();
            String string = properties.getProperty("list");
            if (string != null) {
                object3 = new StringTokenizer(string);
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    try {
                        object = (ImageEncoder)Beans.instantiate(null, (String)object2);
                        encoderMap.put(object.getFileExtention(), object);
                    }
                    catch (ClassCastException classCastException) {
                        System.out.println((String)object2 + " is not an ImageEncoder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.out.println((String)object2 + " not found");
                    }
                    catch (IOException iOException) {
                        System.out.println((String)object2 + " could not be read");
                    }
                }
            }
            object3 = encoderMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (ImageEncoder)encoderMap.get(object3.next());
                object = new DefaultFileFilter(object2.getFileExtention(), object2.getDescription());
                fileChooser.addChoosableFileFilter((FileFilter)object);
            }
            inputStream = (class$com$sun$glf$util$CompositionFrame == null ? (class$com$sun$glf$util$CompositionFrame = CompositionFrame.class$("com.sun.glf.util.CompositionFrame")) : class$com$sun$glf$util$CompositionFrame).getResourceAsStream("/com/sun/glf/res/config.properties");
            if (inputStream != null) {
                object2 = new Properties();
                ((Properties)object2).load(inputStream);
                object = ((Properties)object2).getProperty("canSave", "no");
                this.isSaveEnabled = ((String)object).equalsIgnoreCase("sure");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CompositionFrame(String string) {
        super(string);
        if (encoderMap == null) {
            this.init();
        }
        this.setSize(defaultSize);
        if (this.isSaveEnabled) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        Point point = CompositionFrame.this.getLocation();
                        CompositionFrame.this.menu.setLocation(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
                        CompositionFrame.this.menu.setVisible(true);
                    }
                    if ((mouseEvent.getModifiers() & 0x10) != 0) {
                        CompositionFrame.this.menu.setVisible(false);
                    }
                }
            });
        }
        this.menu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(SAVE_AS_IMAGE);
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CompositionFrame.this.onSave();
            }
        });
        this.paintMonitor.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onSave() {
        int n;
        Object object;
        this.menu.setVisible(false);
        fileChooser.setDialogType(1);
        int n2 = fileChooser.showDialog(this, null);
        if (n2 != 0) return;
        File file = fileChooser.getSelectedFile();
        FileFilter fileFilter = fileChooser.getFileFilter();
        ImageEncoder imageEncoder = null;
        boolean bl = false;
        if (fileFilter == null) {
            object = file.getName();
            n = ((String)object).lastIndexOf(46);
            if (n != -1) {
                String string = ((String)object).substring(n);
                if (string.equalsIgnoreCase(".ser") && this.serializedFactory != null) {
                    bl = true;
                } else {
                    imageEncoder = (ImageEncoder)encoderMap.get(string);
                }
            }
        } else if (fileFilter instanceof DefaultFileFilter) {
            object = (DefaultFileFilter)fileChooser.getFileFilter();
            imageEncoder = (ImageEncoder)encoderMap.get(((DefaultFileFilter)object).getExtention());
        } else {
            bl = true;
        }
        if (imageEncoder != null) {
            try {
                object = new FileOutputStream(file);
                imageEncoder.encode(this.comp.getOffscreen(), (OutputStream)object);
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, iOException.getMessage(), COULD_NOT_SAVE_IMAGE, 0);
            }
            return;
        } else if (bl) {
            try {
                object = new File(file.getAbsolutePath() + ".txt");
                n = 0;
                if (file.exists() || ((File)object).exists()) {
                    int n3 = JOptionPane.showConfirmDialog(null, FILE_EXIST_OVERRIDE, CONFIRM, 0);
                    if (n3 != 0) return;
                    int n4 = 1;
                    n = n4;
                } else {
                    n = 1;
                }
                if (n == 0) return;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.serializedFactory);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Object object2 = objectInputStream.readObject();
                byteArrayInputStream.close();
                objectInputStream.close();
                FileOutputStream fileOutputStream = new FileOutputStream(file.getPath());
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object2);
                objectOutputStream.flush();
                objectOutputStream.close();
                fileOutputStream.close();
                fileOutputStream = new FileOutputStream(file.getPath() + ".txt");
                TextBeans.save(object2, fileOutputStream);
                fileOutputStream.close();
                JOptionPane.showMessageDialog(null, BEANS_SAVED);
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, ERROR_CANNOT_SERIALIZE_BEANS + iOException.getMessage());
                iOException.printStackTrace();
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error();
            }
        } else {
            JOptionPane.showMessageDialog(null, ERROR_UNKNOWN_FORMAT + file.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setComposition(Composition composition) {
        this.getContentPane().setBackground(this.getBackground());
        this.getContentPane().removeAll();
        this.comp = new CompositionComponent(composition);
        this.getContentPane().add("North", this.paintMonitor);
        this.pack();
        this.validate();
        this.paintMonitor.monitor(composition);
        try {
            try {
                this.comp.prepareOffscreen();
                this.getContentPane().add(this.comp);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), COULD_NOT_LOAD_COMPOSITION, 0);
                exception.printStackTrace();
                Object var4_3 = null;
                this.getContentPane().remove(this.paintMonitor);
                this.paintMonitor.monitor(null);
                this.pack();
                fileChooser.removeChoosableFileFilter(serializedBeanFilter);
                this.serializedFactory = null;
                return;
            }
            Object var4_2 = null;
            this.getContentPane().remove(this.paintMonitor);
            this.paintMonitor.monitor(null);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getContentPane().remove(this.paintMonitor);
            this.paintMonitor.monitor(null);
            this.pack();
            fileChooser.removeChoosableFileFilter(serializedBeanFilter);
            this.serializedFactory = null;
            throw throwable;
        }
        this.pack();
        fileChooser.removeChoosableFileFilter(serializedBeanFilter);
        this.serializedFactory = null;
    }

    public synchronized void load(CompositionFactory compositionFactory) {
        if (this.loadingThread != null) {
            this.loadingThread.pleaseDie();
        }
        this.loadingThread = new CompositionLoadThread(compositionFactory);
        this.loadingThread.setPriority(Thread.currentThread().getPriority() - 1);
        this.loadingThread.start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        serializedBeanFilter = new SerializedBeanFileFilter();
    }

    class CompositionLoadThread
    extends Thread {
        private boolean dead = false;
        private CompositionFactory factory;

        public CompositionLoadThread(CompositionFactory compositionFactory) {
            super("Preview Thread " + curThread++);
            this.factory = compositionFactory;
        }

        public void pleaseDie() {
            this.dead = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CompositionFrame.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                block6: {
                    try {
                        Composition composition = this.factory.build();
                        byte[] byArray = null;
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                            objectOutputStream.writeObject(this.factory);
                            objectOutputStream.close();
                            byteArrayOutputStream.close();
                            byArray = byteArrayOutputStream.toByteArray();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            byArray = null;
                        }
                        if (this.dead) break block6;
                        CompositionFrame.this.setComposition(composition);
                        if (byArray == null) break block6;
                        CompositionFrame.this.serializedFactory = byArray;
                        fileChooser.removeChoosableFileFilter(serializedBeanFilter);
                        fileChooser.addChoosableFileFilter(serializedBeanFilter);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(CompositionFrame.this, exception.getMessage(), CompositionFrame.COULD_NOT_LOAD_COMPOSITION, 0);
                        exception.printStackTrace();
                        Object var6_8 = null;
                        if (this.dead) return;
                        CompositionFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                        CompositionFrame.this.setVisible(true);
                        return;
                    }
                }
                Object var6_7 = null;
                if (this.dead) return;
                CompositionFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                CompositionFrame.this.setVisible(true);
                return;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (this.dead) throw throwable;
                CompositionFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                CompositionFrame.this.setVisible(true);
                throw throwable;
            }
        }
    }
}

