/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.util.CompositionComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JFrame;

public class TextStroke
implements Stroke {
    static final String ERROR_INVALID_TEXT_ARGUMENT = "Error : text should be non null and contain non white-space characters";
    static final FontRenderContext frc = new FontRenderContext(null, true, true);
    static final int FLATTENESS = 1;
    private GlyphVector glyphVector;
    private float ascent;
    private int nGlyphs;
    private boolean cycle;
    private float cycleGap;
    private String text;
    private Font font;

    public TextStroke(String string, Font font, boolean bl, float f) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException(ERROR_INVALID_TEXT_ARGUMENT);
        }
        if (font == null) {
            throw new NullPointerException();
        }
        this.glyphVector = font.createGlyphVector(frc, string);
        this.glyphVector.performDefaultLayout();
        this.nGlyphs = this.glyphVector.getNumGlyphs();
        LineMetrics lineMetrics = font.getLineMetrics(string, frc);
        this.ascent = lineMetrics.getAscent();
        this.cycle = bl;
        this.cycleGap = f;
        if (f < 0.0f) {
            this.cycleGap = font.getSize();
        }
        this.text = string;
        this.font = font;
    }

    public Shape createStrokedShape(Shape shape) {
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(new AffineTransform()), 1.0);
        float[] fArray = new float[6];
        int n = 0;
        ProcessSegmentControl processSegmentControl = new ProcessSegmentControl();
        boolean bl = false;
        while (!flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    processSegmentControl.x = fArray[0];
                    processSegmentControl.y = fArray[1];
                    processSegmentControl.mx = processSegmentControl.x;
                    processSegmentControl.my = processSegmentControl.y;
                    processSegmentControl.start = true;
                    break;
                }
                case 1: {
                    processSegmentControl.dx = fArray[0];
                    processSegmentControl.dy = fArray[1];
                    bl = this.processSegment(processSegmentControl);
                    processSegmentControl.start = false;
                    break;
                }
                case 4: {
                    processSegmentControl.dx = processSegmentControl.mx;
                    processSegmentControl.dy = processSegmentControl.my;
                    bl = this.processSegment(processSegmentControl);
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + n);
                }
            }
            flatteningPathIterator.next();
            if (!bl) continue;
            break;
        }
        return processSegmentControl.s;
    }

    private boolean processSegment(ProcessSegmentControl processSegmentControl) {
        boolean bl = false;
        float f = (float)Point2D.distance(processSegmentControl.x, processSegmentControl.y, processSegmentControl.dx, processSegmentControl.dy);
        float f2 = (processSegmentControl.dx - processSegmentControl.x) / f;
        float f3 = (processSegmentControl.dy - processSegmentControl.y) / f;
        processSegmentControl.x -= f2 * processSegmentControl.startCredit;
        processSegmentControl.y -= f3 * processSegmentControl.startCredit;
        float f4 = processSegmentControl.ngx - processSegmentControl.d;
        float f5 = processSegmentControl.x + f4 * f2;
        float f6 = processSegmentControl.y + f4 * f3;
        float f7 = (float)Math.atan2(processSegmentControl.dy - processSegmentControl.y, processSegmentControl.dx - processSegmentControl.x);
        float f8 = 0.0f;
        if (!processSegmentControl.start) {
            float f9 = f7 - processSegmentControl.previousAngle;
            if ((double)f9 < -Math.PI) {
                f9 += (float)Math.PI * 2;
            }
            if ((double)f9 > Math.PI) {
                f9 -= (float)Math.PI * 2;
            }
            if (f9 < 0.0f) {
                f8 = Math.abs(this.ascent * (float)Math.tan(f9 / 2.0f));
                f -= f8;
                f5 += f8 * f2;
                f6 += f8 * f3;
            }
        }
        if (processSegmentControl.d + processSegmentControl.startCredit + f > processSegmentControl.ngx + (float)processSegmentControl.glyphWidth) {
            processSegmentControl.previousAngle = f7;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f5 - processSegmentControl.ngx, f6 - processSegmentControl.ngy);
            affineTransform.rotate(f7, processSegmentControl.ngx, processSegmentControl.ngy);
            affineTransform.concatenate(processSegmentControl.defaultTransform);
            float f10 = f + processSegmentControl.startCredit;
            AffineTransform affineTransform2 = new AffineTransform();
            boolean bl2 = true;
            while (bl2) {
                Point2D point2D = this.glyphVector.getGlyphPosition(processSegmentControl.glyphIndex);
                affineTransform2.setToIdentity();
                affineTransform2.concatenate(affineTransform);
                affineTransform2.translate(point2D.getX(), point2D.getY());
                processSegmentControl.s.append(affineTransform2.createTransformedShape(this.glyphVector.getGlyphOutline(processSegmentControl.glyphIndex)), false);
                float f11 = (float)processSegmentControl.defaultTransform.getTranslateX() + (float)point2D.getX() + (float)processSegmentControl.glyphWidth;
                f10 -= f11 - processSegmentControl.d;
                processSegmentControl.d = f11;
                processSegmentControl.x += (float)processSegmentControl.glyphWidth * f2;
                processSegmentControl.y += (float)processSegmentControl.glyphWidth * f3;
                ++processSegmentControl.glyphIndex;
                if (processSegmentControl.glyphIndex >= this.nGlyphs) {
                    if (!this.cycle) {
                        bl = true;
                        bl2 = false;
                    } else {
                        processSegmentControl.defaultTransform.translate((float)this.glyphVector.getVisualBounds().getWidth() + this.cycleGap, 0.0);
                        affineTransform.translate((float)this.glyphVector.getVisualBounds().getWidth() + this.cycleGap, 0.0);
                    }
                }
                if (bl) continue;
                processSegmentControl.glyphIndex %= this.nGlyphs;
                processSegmentControl.ngx = (float)processSegmentControl.defaultTransform.getTranslateX() + (float)this.glyphVector.getGlyphPosition(processSegmentControl.glyphIndex).getX();
                processSegmentControl.ngy = (float)this.glyphVector.getGlyphPosition(processSegmentControl.glyphIndex).getY();
                processSegmentControl.glyphWidth = this.glyphVector.getGlyphLogicalBounds((int)processSegmentControl.glyphIndex).getBounds().width;
                bl2 = processSegmentControl.d + f10 > processSegmentControl.ngx + (float)processSegmentControl.glyphWidth;
            }
            processSegmentControl.x = processSegmentControl.dx;
            processSegmentControl.y = processSegmentControl.dy;
            processSegmentControl.startCredit = f10;
        }
        return bl;
    }

    public String getText() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public float getCycleGap() {
        return this.cycleGap;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("TextStroke unit testing");
        jFrame.getContentPane().setBackground(Color.white);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(50.0f, 0.0f);
        generalPath.lineTo(100.0f, 100.0f);
        generalPath.lineTo(0.0f, 100.0f);
        generalPath.closePath();
        Rectangle rectangle = new Rectangle(0, 0, 100, 100);
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(80.0f, 40.0f);
        generalPath2.lineTo(100.0f, 40.0f);
        generalPath2.quadTo(100.0f, 100.0f, 140.0f, 160.0f);
        generalPath2.lineTo(110.0f, 160.0f);
        generalPath2.curveTo(110.0f, 120.0f, 70.0f, 120.0f, 70.0f, 160.0f);
        generalPath2.lineTo(40.0f, 160.0f);
        generalPath2.quadTo(80.0f, 100.0f, 80.0f, 40.0f);
        Shape[] shapeArray = new Shape[]{generalPath, rectangle, double_, generalPath2};
        Font font = new Font("dialog", 0, 10);
        Stroke[] strokeArray = new Stroke[]{new BasicStroke(), new TextStroke("Text Strokes are fun", font, false, 0.0f), new TextStroke("Text Strokes are fun", font, true, 10.0f)};
        jFrame.getContentPane().setLayout(new GridLayout(0, strokeArray.length));
        for (int i = 0; i < shapeArray.length; ++i) {
            Shape shape = shapeArray[i];
            for (int j = 0; j < strokeArray.length; ++j) {
                TextStroke.addTestComponent(jFrame, strokeArray[j], shape);
            }
        }
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static void addTestComponent(JFrame jFrame, Stroke stroke, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        LayerComposition layerComposition = new LayerComposition(new Dimension(rectangle.width + 20, rectangle.height + 20));
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, shape, new StrokeRenderer((Paint)Color.black, stroke), Position.CENTER);
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, shape, new StrokeRenderer((Paint)Color.black, new BasicStroke()), Position.CENTER);
        layerComposition.setBackgroundPaint(Color.white);
        layerComposition.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        layerComposition.setLayers(new Layer[]{shapeLayer});
        jFrame.getContentPane().add(new CompositionComponent(layerComposition));
    }

    class ProcessSegmentControl {
        float x;
        float y;
        float mx;
        float my;
        float dx;
        float dy;
        float startCredit;
        float d;
        float ngx;
        float ngy;
        int glyphWidth;
        int glyphIndex;
        boolean start;
        float previousAngle;
        GeneralPath s = new GeneralPath();
        AffineTransform defaultTransform = new AffineTransform();

        public ProcessSegmentControl() {
            this.glyphWidth = ((TextStroke)TextStroke.this).glyphVector.getGlyphOutline((int)0).getBounds().width;
        }
    }
}

