/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.goodies;

import com.sun.glf.goodies.AbstractTransform;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class BumpTransform
extends AbstractTransform {
    float angle;
    int sign = 1;

    public BumpTransform(float f) {
        if (f < 0.0f) {
            this.sign = -1;
        }
        f = Math.abs(f);
        this.angle = f % ((float)Math.PI * 2);
        if (this.angle == 0.0f) {
            this.angle = (float)Math.PI * 2;
        }
    }

    private final void transform(float f, float f2, float f3, float f4, float f5, float[] fArray, int n, AffineTransform affineTransform) {
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f6 = fArray[2 * i] - f;
            f7 = (float)this.sign * (f2 - fArray[2 * i + 1]);
            f9 = f3 + f7;
            f10 = 1.0f + f7 / f5 * (f4 - 1.0f);
            f8 = f10 * f6 / f9;
            fArray[2 * i] = f + f9 * (float)Math.sin(f8);
            int n2 = 2 * i + 1;
            fArray[n2] = fArray[n2] + (float)this.sign * f9 * (1.0f - (float)Math.cos(f8));
        }
    }

    public Shape transformImpl(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        Rectangle rectangle = shape.getBounds();
        float f = (float)rectangle.x + (float)rectangle.width / 2.0f;
        float f2 = rectangle.y + rectangle.height;
        float f3 = rectangle.height;
        if (this.sign == -1) {
            f2 = rectangle.y;
        }
        float f4 = (float)rectangle.width / this.angle;
        float f5 = (f4 + (float)rectangle.height) * this.angle / (float)rectangle.width;
        float[] fArray = new float[6];
        int n = 0;
        boolean bl = false;
        GeneralPath generalPath = new GeneralPath();
        AffineTransform affineTransform = new AffineTransform();
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    this.transform(f, f2, f4, f5, f3, fArray, 1, affineTransform);
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.transform(f, f2, f4, f5, f3, fArray, 1, affineTransform);
                    generalPath.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
                case 2: {
                    this.transform(f, f2, f4, f5, f3, fArray, 2, affineTransform);
                    generalPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.transform(f, f2, f4, f5, f3, fArray, 3, affineTransform);
                    generalPath.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + n);
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }
}

