/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.Anchor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Position {
    public static final Position TOP_LEFT = new Position(Anchor.TOP_LEFT);
    public static final Position TOP = new Position(Anchor.TOP);
    public static final Position TOP_RIGHT = new Position(Anchor.TOP_RIGHT);
    public static final Position RIGHT = new Position(Anchor.RIGHT);
    public static final Position BOTTOM_RIGHT = new Position(Anchor.BOTTOM_RIGHT);
    public static final Position BOTTOM = new Position(Anchor.BOTTOM);
    public static final Position BOTTOM_LEFT = new Position(Anchor.BOTTOM_LEFT);
    public static final Position LEFT = new Position(Anchor.LEFT);
    public static final Position CENTER = new Position(Anchor.CENTER);
    private Anchor anchor = Anchor.CENTER;
    private float hAdjust;
    private float vAdjust;
    private AffineTransform transform = new AffineTransform();
    private boolean placeBeforeTransform = true;

    public Position() {
        this(Anchor.CENTER);
    }

    public Position(Anchor anchor) {
        this(anchor, 0.0f, 0.0f);
    }

    public Position(Anchor anchor, float f, float f2) {
        this(anchor, f, f2, null);
    }

    public Position(Anchor anchor, float f, float f2, AffineTransform affineTransform) {
        this(anchor, f, f2, affineTransform, true);
    }

    public Position(Anchor anchor, float f, float f2, AffineTransform affineTransform, boolean bl) {
        if (anchor == null) {
            anchor = Anchor.CENTER;
        }
        this.anchor = anchor;
        this.hAdjust = f;
        this.vAdjust = f2;
        if (affineTransform != null) {
            this.transform = (AffineTransform)affineTransform.clone();
        }
        this.placeBeforeTransform = bl;
    }

    public Shape createTransformedShape(Shape shape, Rectangle2D rectangle2D) {
        AffineTransform affineTransform = this.getTransform(shape, rectangle2D);
        return affineTransform.createTransformedShape(shape);
    }

    public AffineTransform getTransform(Shape shape, Rectangle2D rectangle2D) {
        AffineTransform affineTransform = null;
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        if (this.placeBeforeTransform) {
            affineTransform = this.getAnchorPlacementTransform(rectangle2D2, rectangle2D);
            affineTransform.translate(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
            affineTransform.concatenate(this.transform);
            affineTransform.translate(-rectangle2D2.getX() - rectangle2D2.getWidth() / 2.0, -rectangle2D2.getY() - rectangle2D2.getHeight() / 2.0);
        } else {
            affineTransform = new AffineTransform();
            affineTransform.translate(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0, rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
            affineTransform.concatenate(this.transform);
            affineTransform.translate(-rectangle2D2.getX() - rectangle2D2.getWidth() / 2.0, -rectangle2D2.getY() - rectangle2D2.getHeight() / 2.0);
            rectangle2D2 = affineTransform.createTransformedShape(shape).getBounds();
            AffineTransform affineTransform2 = this.getAnchorPlacementTransform(rectangle2D2, rectangle2D);
            affineTransform.preConcatenate(affineTransform2);
        }
        return affineTransform;
    }

    private AffineTransform getAnchorPlacementTransform(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D2.getWidth();
        double d2 = rectangle2D2.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        switch (this.anchor.toInt()) {
            case 0: {
                affineTransform.setToTranslation(this.hAdjust, this.vAdjust);
                break;
            }
            case 1: {
                affineTransform.setToTranslation(-rectangle2D.getWidth() / 2.0 + d / 2.0, this.vAdjust);
                break;
            }
            case 2: {
                affineTransform.setToTranslation(d - rectangle2D.getWidth() - (double)this.hAdjust, this.vAdjust);
                break;
            }
            case 3: {
                affineTransform.setToTranslation(d - rectangle2D.getWidth() - (double)this.hAdjust, -rectangle2D.getHeight() / 2.0 + d2 / 2.0);
                break;
            }
            case 4: {
                affineTransform.setToTranslation(d - rectangle2D.getWidth() - (double)this.hAdjust, d2 - rectangle2D.getHeight() - (double)this.vAdjust);
                break;
            }
            case 5: {
                affineTransform.setToTranslation(-rectangle2D.getWidth() / 2.0 + d / 2.0, d2 - rectangle2D.getHeight() - (double)this.vAdjust);
                break;
            }
            case 6: {
                affineTransform.setToTranslation(this.hAdjust, d2 - rectangle2D.getHeight() - (double)this.vAdjust);
                break;
            }
            case 7: {
                affineTransform.setToTranslation(this.hAdjust, -rectangle2D.getHeight() / 2.0 + d2 / 2.0);
                break;
            }
            case 8: {
                affineTransform.setToTranslation(-rectangle2D.getWidth() / 2.0 + d / 2.0, -rectangle2D.getHeight() / 2.0 + d2 / 2.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid anchor value: " + this.anchor);
            }
        }
        affineTransform.translate(rectangle2D2.getX() - rectangle2D.getX(), rectangle2D2.getY() - rectangle2D.getY());
        return affineTransform;
    }
}

