/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.xmldecode;

import com.install4j.runtime.xmldecode.Handler;
import com.install4j.runtime.xmldecode.sax.AttributesImpl;
import com.install4j.runtime.xmldecode.sax.SAXException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import nanoxml.XMLElement;

public class SaxOutputter {
    private Handler handler;

    public SaxOutputter(Handler handler) {
        this.handler = handler;
    }

    public void output(XMLElement xMLElement) throws SAXException {
        if (xMLElement == null) {
            return;
        }
        this.handler.startDocument();
        this.element(xMLElement);
        this.handler.endDocument();
    }

    private void element(XMLElement xMLElement) throws SAXException {
        this.startElement(xMLElement);
        Vector vector = xMLElement.getChildren();
        if (vector.size() > 0) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                XMLElement xMLElement2 = (XMLElement)iterator.next();
                this.element(xMLElement2);
            }
        } else {
            this.elementContent(xMLElement);
        }
        this.endElement(xMLElement);
    }

    private void startElement(XMLElement xMLElement) throws SAXException {
        String string = xMLElement.getName();
        AttributesImpl attributesImpl = new AttributesImpl();
        Enumeration enumeration = xMLElement.enumerateAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Object object = xMLElement.getAttribute(string2);
            attributesImpl.addAttribute("", "", string2.toLowerCase(), "CDATA", object.toString());
        }
        this.handler.startElement("", "", string, attributesImpl);
    }

    private void elementContent(XMLElement xMLElement) throws SAXException {
        String string = xMLElement.getContent();
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            this.handler.characters(cArray, 0, cArray.length);
        }
    }

    private void endElement(XMLElement xMLElement) throws SAXException {
        this.handler.endElement("", "", xMLElement.getName());
    }
}

