/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public class InstallerUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final boolean DEBUG = Boolean.getBoolean("install4j.debug");
    public static final String REGKEY_EXE4J = "SOFTWARE\\ej-technologies\\exe4j\\";
    private static final String REGVAL_INSTALL_STARTED = "InstallStarted";
    public static final String REGVAL_SETTING_LAF = "SettingLaf";
    private static boolean unattended = false;
    private static boolean console = false;

    public static boolean isUnattended() {
        return unattended;
    }

    public static void setUnattended(boolean bl) {
        unattended = bl;
    }

    public static boolean isConsole() {
        return console;
    }

    public static void setConsole(boolean bl) {
        console = bl;
    }

    public static boolean isSolaris() {
        return OS_NAME.equals("SunOS");
    }

    public static boolean isSolarisSparc() {
        return InstallerUtil.isSolaris() && OS_ARCH.equals("sparc");
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isLinuxX86() {
        return InstallerUtil.isLinux() && OS_ARCH.indexOf("86") > -1;
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }

    public static boolean isWindowsXP() {
        return OS_NAME.toLowerCase().startsWith("windows xp");
    }

    public static boolean isWindows2000() {
        return OS_NAME.toLowerCase().startsWith("windows 2000");
    }

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean isWindowsMe() {
        return OS_NAME.startsWith("Windows Me");
    }

    public static boolean isWindows9X() {
        return OS_NAME.startsWith("Windows 98") || OS_NAME.startsWith("Windows 95") || OS_NAME.startsWith("Windows Me");
    }

    public static boolean isWindowsNT() {
        return (OS_NAME.toLowerCase().startsWith("windows nt") || OS_NAME.toLowerCase().startsWith("windowsnt")) && !OS_VERSION.startsWith("6");
    }

    public static boolean isWindowsVista() {
        return OS_NAME.toLowerCase().startsWith("windows vista") || OS_NAME.toLowerCase().startsWith("windows nt") && OS_VERSION.startsWith("6");
    }

    public static boolean isHpux() {
        return OS_NAME.equals("HP-UX");
    }

    public static String getStandardApplicationsDirectory() {
        if (InstallerUtil.isWindows()) {
            return FolderInfo.getProgramFilesDirectory().getAbsolutePath();
        }
        if (InstallerUtil.isMacOS()) {
            return "/Applications";
        }
        File file = new File("/opt");
        String[] stringArray = file.list();
        if (file.exists() && stringArray != null && stringArray.length > 0) {
            return "/opt";
        }
        return "/usr/local";
    }

    public static File getInstallerFile(String string) {
        File file = new File(string).getAbsoluteFile();
        if (file.exists()) {
            return file;
        }
        return new File(ResourceHelper.getRuntimeDir(), string);
    }

    public static CommandLineOptions parseCommandLine(String[] stringArray) {
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (string.equals("-q") && !commandLineOptions.console) {
                commandLineOptions.quiet = true;
                continue;
            }
            if (string.equals("-c") && !commandLineOptions.quiet) {
                commandLineOptions.console = true;
                continue;
            }
            if (string.equals("-overwrite")) {
                commandLineOptions.quietOverwrite = true;
                continue;
            }
            if (string.equals("-dir") && i + 1 < stringArray.length) {
                commandLineOptions.installDir = new File(stringArray[++i]);
                continue;
            }
            if (string.equals("-varfile") && i + 1 < stringArray.length) {
                commandLineOptions.varFileName = stringArray[++i];
                continue;
            }
            boolean bl = string.startsWith("-D");
            boolean bl2 = string.startsWith("-V");
            if (!bl && !bl2 || (n = string.indexOf(61)) <= -1 || string.length() <= n + 1) continue;
            String string2 = string.substring(2, n);
            String string3 = string.substring(n + 1);
            if (bl) {
                System.setProperty(string2, string3);
                continue;
            }
            commandLineOptions.commandLineVars.setProperty(string2, string3);
        }
        return commandLineOptions;
    }

    public static InstallerConfig getOldApplicationConfig(File file) {
        if (file.exists()) {
            File file2 = new File(file, ".install4j/i4jparams.conf");
            if (file2.exists()) {
                try {
                    return InstallerConfig.getGeneralConfigFromFile(file2);
                }
                catch (Exception exception) {
                }
            } else if (Util.isMacOS() && (file2 = new File(file, "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                try {
                    return InstallerConfig.getGeneralConfigFromFile(file2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getOldApplicationId(File file) {
        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(file);
        if (installerConfig != null) {
            if (installerConfig.getApplicationId().indexOf("${") > -1) {
                return null;
            }
            return installerConfig.getApplicationId();
        }
        return null;
    }

    public static boolean checkWritable(File file, Component component, boolean bl) {
        Serializable serializable;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (serializable = file; serializable != null; serializable = ((File)serializable).getParentFile()) {
            arrayList.add((File)serializable);
        }
        serializable = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file2 = (File)arrayList.get(i);
            if (!file2.mkdir()) continue;
            serializable.add(file2);
        }
        File file3 = new File(file, "i4j_writeperm_test");
        file3.delete();
        boolean bl2 = file3.mkdir();
        file3.delete();
        for (int i = serializable.size() - 1; i >= 0; --i) {
            File file4 = (File)serializable.get(i);
            file4.delete();
        }
        if (!bl2 && bl) {
            GUIHelper.showMessage(component, Messages.getMessages().getString("NoWritePermissions"), 2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadFile(File file, String string) {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        try {
            if (!file.getName().toLowerCase().endsWith(".zip")) return InstallerUtil.readString(new FileInputStream(file));
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipEntry zipEntry;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                do {
                    if (!enumeration.hasMoreElements()) return null;
                } while (!(zipEntry = enumeration.nextElement()).getName().startsWith(string + "."));
                String string2 = InstallerUtil.readString(zipFile.getInputStream(zipEntry));
                return string2;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String readString(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringWriter stringWriter = new StringWriter();
        while ((n = inputStreamReader.read()) != -1) {
            stringWriter.write(n);
        }
        inputStreamReader.close();
        return stringWriter.toString();
    }

    public static String sanitizeHTML(String string) {
        boolean bl;
        String string2 = string.toLowerCase();
        boolean bl2 = bl = string2.indexOf("<html>") > -1;
        if (bl) {
            int n = string2.indexOf("<head>");
            int n2 = string2.indexOf("</head>");
            if (n > -1 && n2 > n) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(string.substring(n + 6, n2));
                stringBuffer.append(string.substring(n2 + 7));
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String cleanupName(String string) {
        if (string.endsWith("//") || string.endsWith("\\\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void reportException(Throwable throwable) {
        Logger.getInstance().log(throwable);
        if (DEBUG) {
            throwable.printStackTrace();
        } else {
            Object object;
            File file = null;
            try {
                file = File.createTempFile("install4jError", ".log");
                object = new PrintWriter(new FileOutputStream(file));
                ((PrintWriter)object).println("Exception:");
                ((PrintWriter)object).println();
                throwable.printStackTrace((PrintWriter)object);
                ((PrintWriter)object).println();
                ((PrintWriter)object).println("System properties:");
                ((PrintWriter)object).println();
                Iterator<Map.Entry<Object, Object>> iterator = System.getProperties().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    ((PrintWriter)object).print(entry.getKey());
                    ((PrintWriter)object).print("=");
                    ((PrintWriter)object).println(entry.getValue());
                }
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file != null) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            object = "An error occurred:\n" + throwable + "\nError log: " + (file == null ? "" : file.getPath());
            if (unattended) {
                System.err.println((String)object);
                throwable.printStackTrace();
            } else if (console) {
                ConsoleImpl.getInstance().println(object);
                ConsoleImpl.getInstance().printStackTrace(throwable);
            } else if (throwable instanceof InternalError && throwable.getMessage().indexOf("X11") > 0) {
                InstallerUtil.displayXMessage((String)object);
            } else {
                try {
                    JOptionPane.showMessageDialog(null, object, "install4j", 0);
                }
                catch (Throwable throwable2) {
                    InstallerUtil.displayXMessage((String)object);
                }
            }
        }
    }

    public static boolean isAtLeastJava14() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    private static void displayXMessage(String string) {
        System.err.println("Could not display the GUI. This application needs access to an X Server.");
        System.err.println("If you have access there is probably an X library missing.");
        if (InstallerUtil.isAtLeastJava14()) {
            if (InstallerConfig.getCurrentInstance().isAllowConsole()) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in console mode without");
                System.err.println("access to an X server by passing the argument -c");
                System.err.println("*******************************************************************");
            } else if (InstallerConfig.getCurrentInstance().isAllowUnattended()) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in unattended mode without");
                System.err.println("access to an X server by passing the argument -q");
                System.err.println("*******************************************************************");
            }
        }
        System.err.println(string);
    }

    public static Process launchApplication(File file, File file2, String[] stringArray) {
        Process process = null;
        try {
            if (file == null) {
                Logger.getInstance().error(null, "executable is null");
            } else if (InstallerUtil.isMacOS()) {
                if (file.isDirectory()) {
                    file = new File(file, "Contents/MacOS/JavaApplicationStub");
                }
                File file3 = File.createTempFile("i4j", ".sh");
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file3)), "UTF-8"));
                printWriter.println("#!/bin/sh");
                printWriter.print("\"" + file.getAbsolutePath() + "\"");
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        printWriter.print(" \"" + stringArray[i] + "\"");
                    }
                }
                printWriter.println();
                printWriter.println("rm $0");
                printWriter.close();
                String[] stringArray2 = new String[]{"/bin/sh", file3.getAbsolutePath()};
                process = Runtime.getRuntime().exec(stringArray2, null, file2);
                if (process == null) {
                    Logger.getInstance().error(null, "process is null");
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else if (file.isFile()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = file.getAbsolutePath();
                if (Util.isWindows() && (string.toLowerCase().endsWith(".bat") || string.toLowerCase().endsWith(".cmd"))) {
                    int n;
                    int n2;
                    if (Util.isWindows9X()) {
                        arrayList.add(new File(WinFileSystem.getWindowsDirectory(), "command.com").getAbsolutePath());
                    } else {
                        arrayList.add(new File(WinFileSystem.getSystemDirectory(), "cmd.exe").getAbsolutePath());
                    }
                    arrayList.add("/C");
                    if (string.indexOf(32) > -1) {
                        n2 = 0;
                        if (stringArray != null) {
                            for (n = 0; n < stringArray.length; ++n) {
                                if (stringArray[n].indexOf(32) <= -1) continue;
                                n2 = 1;
                                break;
                            }
                        }
                        if (n2 != 0 && !Util.isWindows9X()) {
                            arrayList.add(string.charAt(0) + "\"" + string.substring(1) + "\"");
                        } else {
                            arrayList.add("\"" + string + "\"");
                        }
                    } else {
                        arrayList.add(string);
                    }
                    if (stringArray != null) {
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            if (stringArray[n2].indexOf(32) > -1) {
                                arrayList.add("\"" + stringArray[n2] + "\"");
                                continue;
                            }
                            arrayList.add(stringArray[n2]);
                        }
                    }
                    String string2 = "";
                    for (n = 0; n < arrayList.size(); ++n) {
                        string2 = string2 + arrayList.get(n);
                        if (n >= arrayList.size() - 1) continue;
                        string2 = string2 + " ";
                    }
                    process = Runtime.getRuntime().exec(string2, null, file2);
                } else {
                    arrayList.add(string);
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            arrayList.add(stringArray[i]);
                        }
                    }
                    process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), null, file2);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                Logger.getInstance().error(null, "executable is not a file: " + file);
            }
        }
        catch (IOException iOException) {
            Logger.getInstance().error(null, iOException.getMessage());
            System.err.println(iOException.getMessage());
        }
        return process;
    }

    public static void registerStarted() {
        if (InstallerUtil.isWindows()) {
            Registry.setValue(2, REGKEY_EXE4J, REGVAL_INSTALL_STARTED, new Integer(0));
        }
    }

    public static boolean checkJavaVersion() {
        if (InstallerUtil.isMacOS()) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            String string = installerConfig.getMinJavaVersion();
            if (string.trim().equals("")) {
                return true;
            }
            if (System.getProperty("java.version").compareTo(string) >= 0) {
                return true;
            }
            String string2 = MessageFormat.format(Messages.getMessages().getString("AppleJavaMinVersionError"), installerConfig.getMinJavaVersion(), installerConfig.getApplicationName());
            GUIHelper.showMessage(null, string2, 0);
            return false;
        }
        return true;
    }

    public static String getVerboseVariableDefinition(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(object);
        if (object != null) {
            stringBuffer.append("[");
            stringBuffer.append(object.getClass());
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public static class CommandLineOptions {
        public boolean quiet = false;
        public boolean console = false;
        public File installDir = null;
        public boolean quietOverwrite = false;
        public Properties commandLineVars = new Properties();
        public String varFileName;
    }
}

