/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.registry.DeleteRegistryItemAction;
import com.install4j.runtime.beans.actions.registry.SetRegistryValueAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.File;
import java.io.IOException;

public class RegisterAddRemoveAction
extends SystemAutoUninstallInstallAction {
    private String itemName = "";
    private ExternalFile icon;
    private static final String UNINSTALL_KEY = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
    private static final String DISPLAY_NAME_VALUE_NAME = "DisplayName";
    private static final String DISPLAY_ICON_VALUE_NAME = "DisplayIcon";
    private static final String UNINSTALL_STRING_VALUE_NAME = "UninstallString";
    private static final String PUBLISHER_VALUE_NAME = "Publisher";
    private static final String URL_INFO_ABOUT_VALUE_NAME = "URLInfoAbout";

    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File file = uninstallerContext.getDestinationFile("uninstall.exe");
        if (file.exists()) {
            this.removeUninstallLinks(file, uninstallerContext);
        }
        return true;
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        String string;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        File file = installerContext.getDestinationFile("uninstall.exe");
        if (!file.exists()) {
            return false;
        }
        this.removeUninstallLinks(file, installerContext);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string2 = UNINSTALL_KEY + this.getItemName();
        SetRegistryValueAction setRegistryValueAction = new SetRegistryValueAction(RegistryRoot.HKEY_LOCAL_MACHINE, string2, DISPLAY_NAME_VALUE_NAME, this.getItemName(), false);
        this.addRollbackAction(setRegistryValueAction);
        setRegistryValueAction.execute(installerContext);
        File file2 = installerContext.getExternalFile(this.getIcon(), true);
        if (file2 != null) {
            setRegistryValueAction = new SetRegistryValueAction(RegistryRoot.HKEY_LOCAL_MACHINE, string2, DISPLAY_ICON_VALUE_NAME, file2.getAbsolutePath(), false);
            this.addRollbackAction(setRegistryValueAction);
            setRegistryValueAction.execute(installerContext);
        }
        setRegistryValueAction = new SetRegistryValueAction(RegistryRoot.HKEY_LOCAL_MACHINE, string2, UNINSTALL_STRING_VALUE_NAME, file.getAbsolutePath(), false);
        this.addRollbackAction(setRegistryValueAction);
        setRegistryValueAction.execute(installerContext);
        String string3 = installerConfig.getPublisherName();
        if (string3 != null && !string3.trim().equals("")) {
            setRegistryValueAction = new SetRegistryValueAction(RegistryRoot.HKEY_LOCAL_MACHINE, string2, PUBLISHER_VALUE_NAME, string3, false);
            this.addRollbackAction(setRegistryValueAction);
            setRegistryValueAction.execute(installerContext);
        }
        if ((string = installerConfig.getPublisherURL()) != null && !string.trim().equals("")) {
            setRegistryValueAction = new SetRegistryValueAction(RegistryRoot.HKEY_LOCAL_MACHINE, string2, URL_INFO_ABOUT_VALUE_NAME, string, false);
            this.addRollbackAction(setRegistryValueAction);
            setRegistryValueAction.execute(installerContext);
        }
        return true;
    }

    public ExternalFile getIcon() {
        return this.icon;
    }

    public void setIcon(ExternalFile externalFile) {
        this.icon = externalFile;
    }

    public String getItemName() {
        return RegisterAddRemoveAction.replaceVariables(this.itemName);
    }

    public void setItemName(String string) {
        this.itemName = string;
    }

    private void removeUninstallLinks(File file, Context context) throws UserCanceledException {
        String[] stringArray = Registry.enumSubKeys(3, UNINSTALL_KEY);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                String string;
                String string2 = UNINSTALL_KEY + stringArray[i];
                Object object = Registry.getValue(3, string2, UNINSTALL_STRING_VALUE_NAME);
                if (object == null || !(object instanceof String) || !(string = ((String)object).trim().toLowerCase()).endsWith(".exe") || !string.startsWith(file.getAbsolutePath().substring(0, 2).toLowerCase()) || !(file2 = new File(string)).exists()) continue;
                try {
                    if (!file2.getCanonicalFile().equals(file.getCanonicalFile())) continue;
                    DeleteRegistryItemAction deleteRegistryItemAction = new DeleteRegistryItemAction(RegistryRoot.HKEY_LOCAL_MACHINE, string2, "", false);
                    this.addRollbackAction(deleteRegistryItemAction);
                    deleteRegistryItemAction.execute(context);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

