/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Rendezvous;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int n) {
        this(n, (RendezvousFunction)new Rotator());
    }

    public Rendezvous(int n, RendezvousFunction rendezvousFunction) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = n;
        this.rendezvousFunction_ = rendezvousFunction;
        this.entryGate_ = new WaiterPreferenceSemaphore((long)n);
        this.slots_ = new Object[n];
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction rendezvousFunction) {
        RendezvousFunction rendezvousFunction2 = this.rendezvousFunction_;
        this.rendezvousFunction_ = rendezvousFunction;
        return rendezvousFunction2;
    }

    public int parties() {
        return this.parties_;
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object object) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(object, false, 0L);
    }

    public Object attemptRendezvous(Object object, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(object, true, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doRendezvous(Object object, boolean bl, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        long l2;
        if (bl) {
            l2 = System.currentTimeMillis();
            if (!this.entryGate_.attempt(l)) {
                throw new TimeoutException(l);
            }
        } else {
            l2 = 0L;
            this.entryGate_.acquire();
        }
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            Object object2 = null;
            int n = this.entries_++;
            this.slots_[n] = object;
            try {
                if (this.entries_ == this.parties_) {
                    this.departures_ = this.entries_;
                    this.notifyAll();
                    try {
                        if (!this.broken_ && this.rendezvousFunction_ != null) {
                            this.rendezvousFunction_.rendezvousFunction(this.slots_);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        this.broken_ = true;
                    }
                } else {
                    while (!this.broken_ && this.departures_ < 1L) {
                        long l3 = 0L;
                        if (bl && (l3 = l - (System.currentTimeMillis() - l2)) <= 0L) {
                            this.broken_ = true;
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            throw new TimeoutException(l);
                        }
                        try {
                            this.wait(l3);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.broken_ || this.departures_ > 0L) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                            this.broken_ = true;
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            throw interruptedException;
                        }
                    }
                }
                Object var14_11 = null;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                object2 = this.slots_[n];
                if (--this.departures_ <= 0L) {
                    for (int i = 0; i < this.slots_.length; ++i) {
                        this.slots_[i] = null;
                    }
                    this.entryGate_.release((long)this.entries_);
                    this.entries_ = 0;
                }
                throw throwable;
            }
            object2 = this.slots_[n];
            if (--this.departures_ <= 0L) {
                for (int i = 0; i < this.slots_.length; ++i) {
                    this.slots_[i] = null;
                }
                this.entryGate_.release((long)this.entries_);
                this.entries_ = 0;
            }
            if (this.broken_) {
                throw new BrokenBarrierException(n);
            }
            return object2;
        }
    }
}

