/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunner;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;

public class FJTaskRunnerGroup
implements Executor {
    protected final FJTaskRunner[] threads;
    protected final LinkedQueue entryQueue = new LinkedQueue();
    protected int activeCount = 0;
    protected int nstarted = 0;
    static final boolean COLLECT_STATS = true;
    long initTime = 0L;
    int entries = 0;
    static final int DEFAULT_SCAN_PRIORITY = 2;
    static final long SCANS_PER_SLEEP = 15L;
    static final long MAX_SLEEP_TIME = 100L;

    public FJTaskRunnerGroup(int n) {
        this.threads = new FJTaskRunner[n];
        this.initializeThreads();
        this.initTime = System.currentTimeMillis();
    }

    public void execute(Runnable runnable) throws InterruptedException {
        if (runnable instanceof FJTask) {
            this.entryQueue.put((Object)((FJTask)runnable));
        } else {
            this.entryQueue.put((Object)new FJTask.Wrap(runnable));
        }
        this.signalNewTask();
    }

    public void executeTask(FJTask fJTask) {
        try {
            this.entryQueue.put((Object)fJTask);
            this.signalNewTask();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void invoke(Runnable runnable) throws InterruptedException {
        InvokableFJTask invokableFJTask = new InvokableFJTask(runnable);
        this.entryQueue.put((Object)invokableFJTask);
        this.signalNewTask();
        invokableFJTask.awaitTermination();
    }

    public void interruptAll() {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner fJTaskRunner = this.threads[i];
            if (fJTaskRunner == thread) {
                bl = true;
                continue;
            }
            fJTaskRunner.interrupt();
        }
        if (bl) {
            thread.interrupt();
        }
    }

    public synchronized void setScanPriorities(int n) {
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner fJTaskRunner = this.threads[i];
            fJTaskRunner.setScanPriority(n);
            if (fJTaskRunner.active) continue;
            fJTaskRunner.setPriority(n);
        }
    }

    public synchronized void setRunPriorities(int n) {
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner fJTaskRunner = this.threads[i];
            fJTaskRunner.setRunPriority(n);
            if (!fJTaskRunner.active) continue;
            fJTaskRunner.setPriority(n);
        }
    }

    public int size() {
        return this.threads.length;
    }

    public synchronized int getActiveCount() {
        return this.activeCount;
    }

    public void stats() {
        long l = System.currentTimeMillis() - this.initTime;
        double d = (double)l / 1000.0;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        System.out.print("Thread\tQ Cap\tScans\tNew\tRuns\n");
        for (int i = 0; i < this.threads.length; ++i) {
            FJTaskRunner fJTaskRunner = this.threads[i];
            int n = fJTaskRunner.runs;
            l2 += (long)n;
            int n2 = fJTaskRunner.scans;
            l3 += (long)n2;
            int n3 = fJTaskRunner.steals;
            l4 += (long)n3;
            String string = this.getActive(fJTaskRunner) ? "*" : " ";
            System.out.print("T" + i + string + "\t" + fJTaskRunner.deqSize() + "\t" + n2 + "\t" + n3 + "\t" + n + "\n");
        }
        System.out.print("Total\t    \t" + l3 + "\t" + l4 + "\t" + l2 + "\n");
        System.out.print("Execute: " + this.entries);
        System.out.print("\tTime: " + d);
        long l5 = 0L;
        if (d != 0.0) {
            l5 = Math.round((double)l2 / d);
        }
        System.out.println("\tRate: " + l5);
    }

    protected FJTaskRunner[] getArray() {
        return this.threads;
    }

    protected FJTask pollEntryQueue() {
        try {
            FJTask fJTask = (FJTask)this.entryQueue.poll(0L);
            return fJTask;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected synchronized boolean getActive(FJTaskRunner fJTaskRunner) {
        return fJTaskRunner.active;
    }

    protected synchronized void setActive(FJTaskRunner fJTaskRunner) {
        if (!fJTaskRunner.active) {
            fJTaskRunner.active = true;
            ++this.activeCount;
            if (this.nstarted < this.threads.length) {
                this.threads[this.nstarted++].start();
            } else {
                this.notifyAll();
            }
        }
    }

    protected synchronized void setInactive(FJTaskRunner fJTaskRunner) {
        if (fJTaskRunner.active) {
            fJTaskRunner.active = false;
            --this.activeCount;
        }
    }

    protected synchronized void checkActive(FJTaskRunner fJTaskRunner, long l) {
        this.setInactive(fJTaskRunner);
        try {
            if (this.activeCount == 0 && this.entryQueue.peek() == null) {
                this.wait();
            } else {
                long l2 = l / 15L;
                if (l2 > 100L) {
                    l2 = 100L;
                }
                int n = l2 == 0L ? 1 : 0;
                this.wait(l2, n);
            }
        }
        catch (InterruptedException interruptedException) {
            this.notify();
            Thread.currentThread().interrupt();
        }
    }

    protected synchronized void signalNewTask() {
        ++this.entries;
        if (this.nstarted < this.threads.length) {
            this.threads[this.nstarted++].start();
        } else {
            this.notify();
        }
    }

    protected void initializeThreads() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new FJTaskRunner(this);
        }
    }
}

