### R code from vignette source 'IntroDoFEM.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: IntroDoFEM.Rnw:48-51
###################################################
library("igraph");
library("marray");
library("corrplot")


###################################################
### code chunk number 2: IntroDoFEM.Rnw:56-57
###################################################
library("FEM");	


###################################################
### code chunk number 3: IntroDoFEM.Rnw:60-61
###################################################
data(toydata)#load the toydata


###################################################
### code chunk number 4: IntroDoFEM.Rnw:65-66
###################################################
names(toydata)


###################################################
### code chunk number 5: IntroDoFEM.Rnw:70-71
###################################################
head(toydata$statM)#"head" function is used to show the first 10 rows of statM


###################################################
### code chunk number 6: IntroDoFEM.Rnw:77-79
###################################################
as.vector(which(toydata$statM[,1]>2))->tennodes;
tennodes;


###################################################
### code chunk number 7: IntroDoFEM.Rnw:83-84
###################################################
head(toydata$statR)


###################################################
### code chunk number 8: IntroDoFEM.Rnw:89-90
###################################################
as.vector(which(toydata$statR[,1]< -2));


###################################################
### code chunk number 9: IntroDoFEM.Rnw:97-99
###################################################
plot.igraph(graph.adjacency(toydata$adjacency,mod="undirected"),
vertex.size=8,mark.groups=toydata$tennodes,mark.col="yellow")


###################################################
### code chunk number 10: IntroDoFEM.Rnw:104-105
###################################################
head(toydata$annotation)


###################################################
### code chunk number 11: IntroDoFEM.Rnw:111-117
###################################################
DoFEM_test.o  <- with(toydata,
                             DoFEMbi(statM,statR,adjacency,
                             nseeds=1,gamma=0.5,nMC=1000,
                             sizeR.v=c(1,100),minsizeOUT=10,
                             writeOUT=TRUE,
                             nameSTUDY="TEST",ew.v=NULL));


###################################################
### code chunk number 12: IntroDoFEM.Rnw:135-136
###################################################
DoFEM_test.o$fem


###################################################
### code chunk number 13: IntroDoFEM.Rnw:141-142
###################################################
head(DoFEM_test.o$topmod$Gene11,n=5L)


###################################################
### code chunk number 14: IntroDoFEM.Rnw:146-149
###################################################
mod.idx<-as.numeric(DoFEM_test.o$topmod$Gene11[,1])
plot.igraph(graph.adjacency(toydata$adjacency,mod="undirected"),
vertex.size=8,mark.groups=mod.idx,mark.col="yellow")


###################################################
### code chunk number 15: IntroDoFEM.Rnw:153-155
###################################################
sensitivity=length(intersect(tennodes,mod.idx))/length(tennodes);
sensitivity


###################################################
### code chunk number 16: IntroDoFEM.Rnw:164-166
###################################################
data(realdata);
attributes(realdata);


###################################################
### code chunk number 17: IntroDoFEM.Rnw:170-173
###################################################
#fembi.o <- DoFEMbi(realdata$statM,realdata$statR,realdata$adjacency,
#nseeds=100,gamma=0.5,nMC=1000,sizeR.v=c(1,100),minsizeOUT=10,
#writeOUT=TRUE,nameSTUDY="TCGA-EC",ew.v=NULL);


###################################################
### code chunk number 18: IntroDoFEM.Rnw:177-178
###################################################
data(fembi.o)


###################################################
### code chunk number 19: IntroDoFEM.Rnw:182-183
###################################################
fembi.o$fem


###################################################
### code chunk number 20: IntroDoFEM.Rnw:187-188
###################################################
fembi.o$topmod


###################################################
### code chunk number 21: IntroDoFEM.Rnw:192-196
###################################################
library("marray");
library("corrplot");
HAND2.mod<-fembi.o$topmod$HAND2;
HAND2.graphNEL.o=FemModShow(fembi.o$topmod$HAND2,name="HAND2",fembi.o$ew,realdata$adjacency)


###################################################
### code chunk number 22: IntroDoFEM.Rnw:214-216
###################################################
#for(m in 1:length(names(fembi.o$topmod))){FemModShow(fembi.o$topmod[[m]],
#name=names(fembi.o$topmod)[m],fembi.o$ew,realdata$adjacency)}


###################################################
### code chunk number 23: IntroDoFEM.Rnw:230-231
###################################################
#IntFEM450k.o=DoIntFEM450k(dnaM.m,phenoM.v,exp.m,phenoR.v,adj.m)


###################################################
### code chunk number 24: IntroDoFEM.Rnw:263-272
###################################################
#IntEpi450k.o=DoIntEpi450k(dnaM.m,phenoM.v,adj.m)
#EpiMod.o=DoEpiMod(IntEpi450k.o$statM,IntEpi450k.o$adjacency,
#                   nseeds=100,gamma=0.5,nMC=1000,
#		   sizeR.v=c(1,100),minsizeOUT=10,
#                  writeOUT=TRUE,nameSTUDY="TCGA-EC",ew.v=NULL);)
#
#HAND2.mod<-EpiMod.o$topmod$HAND2; # if there is also HAND2 module
#HAND2.mod.igraph.o=FemModShow(EpiMod.o$topmod$HAND2,name="HAND2",
#EpiMod.o$ew,IntEpi450k.o$adjacency,mode="Epi")


###################################################
### code chunk number 25: IntroDoFEM.Rnw:298-307
###################################################
#IntExp.o=DoIntExp(dnaR.m,phenoR.v,adj.m)
#ExpMod.o=DoEpiMod(IntExp.o$statM,IntExp.o$adjacency,
#                   nseeds=100,gamma=0.5,nMC=1000,
#		   sizeR.v=c(1,100),minsizeOUT=10,
#                  writeOUT=TRUE,nameSTUDY="TCGA-EC",ew.v=NULL);)
#
#ExpMod1.mod<-ExpMod.o$topmod$ExpMod1; # if there is a ExpMod1 module
#Exp1Mod1.mod.graphNEL.o=FemModShow(Exp1Mod1.o$topmod$ExpMod1,name="ExpMod1",
#EpiMod.o$ew,IntExp.o$adjacency,mode="Exp")


###################################################
### code chunk number 26: IntroDoFEM.Rnw:315-328
###################################################
#library(minfi);
#require(IlluminaHumanMethylation450kmanifest);

#baseDIR <- getwd();# the base dir of the Rawdata
#setwd(baseDIR);
#targets <- read.450k.sheet(baseDIR);#read the csv file.
#RGset <- read.450k.exp(baseDIR); #Reads an entire 450k experiment 
#                                  using a sample sheet
#MSet.raw <- preprocessRaw(RGset);#Converts the Red/Green channel for an Illumina 
#                                  methylation array into methylation signal,
#                                  without using any normalization
#beta.m <- getBeta(MSet.raw,type = "Illumina");# get normalized beta 
#pval.m <- detectionP(RGset,type ="m+u")


