### R code from vignette source 'cfassay.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: cfassay.Rnw:65-67
###################################################
library(CFAssay)
datatab<- read.table(system.file("doc", "expl1_cellsurvcurves.txt", package="CFAssay"), header=TRUE, sep="\t")


###################################################
### code chunk number 2: cfassay.Rnw:71-73
###################################################
names(datatab)
head(datatab, 3)  # First 3 lines


###################################################
### code chunk number 3: cfassay.Rnw:77-81 (eval = FALSE)
###################################################
## dim(datatab)
## table(datatab$cline)
## table(datatab$cline, datatab$Exp)
## table(datatab$cline, datatab$dose)


###################################################
### code chunk number 4: cfassay.Rnw:86-90
###################################################
  X<- subset(datatab, cline=="okf6TERT1")
  dim(X)
  fit<- cellsurvLQfit(X)
  print(fit)


###################################################
### code chunk number 5: fig1
###################################################
  plot(fit)
  sfpmean(X, pes(X)$S0)


###################################################
### code chunk number 6: cfassay.Rnw:102-105 (eval = FALSE)
###################################################
##   pdf("okf6TERT1_experimental_plots.pdf")
##   	plotExp(fit)
##   dev.off()


###################################################
### code chunk number 7: cfassay.Rnw:109-115 (eval = FALSE)
###################################################
##   X<- subset(datatab, cline=="cal33")
##   dim(X)
##   fit<- cellsurvLQfit(X)
##   print(fit)
##   plot(fit)
##   plotExp(fit)


###################################################
### code chunk number 8: cfassay.Rnw:121-123
###################################################
  fitcomp<- cellsurvLQdiff(datatab, curvevar="cline")
  print(fitcomp)


###################################################
### code chunk number 9: fig2
###################################################
  plot(cellsurvLQfit(subset(datatab, cline=="okf6TERT1")), col=1)
  plot(cellsurvLQfit(subset(datatab, cline=="cal33")), col=2, add=TRUE)
  legend(0, 0.02, c("OKF6/TERT1", "CAL 33"), text.col=1:2)


###################################################
### code chunk number 10: cfassay.Rnw:140-141
###################################################
datatab<- read.table(system.file("doc", "exp2_2waycfa.txt", package="CFAssay"), header=TRUE, sep="\t")


###################################################
### code chunk number 11: cfassay.Rnw:145-147
###################################################
names(datatab)
head(datatab, 3) # First 3 lines


###################################################
### code chunk number 12: cfassay.Rnw:151-156 (eval = FALSE)
###################################################
## dim(datatab)
## table(datatab$x5fuCis)
## table(datatab$siRNA)
## table(datatab$Exp, datatab$x5fuCis)
## table(datatab$Exp, datatab$siRNA)


###################################################
### code chunk number 13: cfassay.Rnw:161-162
###################################################
  fitcomp<- cfa2way(datatab, A="siRNA", B="x5fuCis", param="A/B")


###################################################
### code chunk number 14: cfassay.Rnw:166-167
###################################################
print(fitcomp, labels=c(A="siRNA", B="x5fuCis"))


###################################################
### code chunk number 15: cfassay.Rnw:171-174 (eval = FALSE)
###################################################
##   pdf("TwoWay_experimental_plots.pdf")
##     plotExp(fitcomp, labels=c(A="siRNA", B="x5fuCis"))
##   dev.off()


