/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import buildsystem.Measure;
import java.io.File;
import java.util.HashSet;
import org.bridgedb.AttributeMapper;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;

public class Test2 {
    private static final String GDB_HUMAN = System.getProperty("user.home") + File.separator + "PathVisio-Data/gene databases/Hs_Derby_20081119.pgdb";
    private static final String GDB_RAT = System.getProperty("user.home") + File.separator + "PathVisio-Data/gene databases/Rn_Derby_20081119.pgdb";
    private static final String GDB_CE_V3 = System.getProperty("user.home") + File.separator + "/PathVisio-Data/gene databases/Ce_Derby_20090720.bridge";
    private Measure measure;

    @Before
    public void setUp() throws ClassNotFoundException {
        this.measure = new Measure("bridgedb_timing.txt");
        Class.forName("org.bridgedb.rdb.IDMapperRdb");
    }

    @Ignore
    public void testGdbConnect() throws IDMapperException {
        Assert.assertTrue((boolean)new File(GDB_HUMAN).exists());
        long start = System.currentTimeMillis();
        IDMapper gdb = BridgeDb.connect("idmapper-pgdb:" + GDB_HUMAN);
        long end = System.currentTimeMillis();
        long delta = end - start;
        this.measure.add("timing::idmapper-pgdb connect to database", "" + delta, "msec");
        gdb.close();
    }

    @Ignore
    public void testGdbAttributes() throws IDMapperException {
        IDMapper gdb = BridgeDb.connect("idmapper-pgdb:" + GDB_HUMAN);
        AttributeMapper am = (AttributeMapper)((Object)gdb);
        Xref ref = new Xref("26873", DataSource.getBySystemCode("L"));
        Assert.assertTrue((boolean)am.getAttributes(ref, "Synonyms").contains("5-Opase|DKFZP434H244|OPLA"));
        Assert.assertTrue((boolean)am.getAttributes(ref, "Description").contains("5-oxoprolinase (EC 3.5.2.9) (5-oxo-L-prolinase) (5-OPase) (Pyroglutamase) [Source:UniProtKB/Swiss-Prot.Acc:O14841]"));
        Assert.assertTrue((boolean)am.getAttributes(ref, "Chromosome").contains("8"));
        Assert.assertTrue((boolean)am.getAttributes(ref, "Symbol").contains("OPLAH"));
        HashSet<String> allExpectedAttributes = new HashSet<String>();
        allExpectedAttributes.add("26873");
    }

    @Ignore
    public void testGdbProperties() throws IDMapperException {
        IDMapper gdb = BridgeDb.connect("idmapper-pgdb:" + GDB_CE_V3);
        for (String key : gdb.getCapabilities().getKeys()) {
            System.out.println(key + " -> " + gdb.getCapabilities().getProperty(key));
        }
        Assert.assertEquals((Object)"Caenorhabditis elegans", (Object)gdb.getCapabilities().getProperty("SPECIES"));
        Assert.assertEquals((Object)"3", (Object)gdb.getCapabilities().getProperty("SCHEMAVERSION"));
        Assert.assertEquals((Object)"Ensembl", (Object)gdb.getCapabilities().getProperty("DATASOURCENAME"));
        Assert.assertEquals((Object)"20090720", (Object)gdb.getCapabilities().getProperty("BUILDDATE"));
        IDMapper gdb2 = BridgeDb.connect("idmapper-pgdb:" + GDB_HUMAN);
        for (String key : gdb2.getCapabilities().getKeys()) {
            System.out.println(key + " -> " + gdb2.getCapabilities().getProperty(key));
        }
        Assert.assertEquals((Object)"2", (Object)gdb2.getCapabilities().getProperty("SCHEMAVERSION"));
        Assert.assertEquals((Object)"20081119", (Object)gdb2.getCapabilities().getProperty("BUILDDATE"));
    }

    @Ignore
    public void testRegisterDataSource() {
        DataSource.register("@@", "ZiZaZo");
        DataSource ds2 = DataSource.getBySystemCode("@@");
        DataSource ds3 = DataSource.getByFullName("ZiZaZo");
        Assert.assertEquals((Object)ds2, (Object)ds3);
        Assert.assertNotNull((Object)DataSource.getBySystemCode("##"));
    }
}

