/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.io.File;
import java.util.Set;
import org.bridgedb.BridgeDb;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.XrefIterator;
import org.bridgedb.bio.BioDataSource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetabolitesTest {
    private static final String METABOLITES = System.getProperty("user.home") + File.separator + "tmp" + File.separator + "metabolites_111203.bridge";
    private static IDMapper mdb;

    @BeforeClass
    public static void setUp() throws Exception {
        Class.forName("org.bridgedb.rdb.IDMapperRdb");
        System.out.println(METABOLITES);
        mdb = BridgeDb.connect("idmapper-pgdb:" + METABOLITES);
        Assert.assertNotNull((Object)mdb);
        Assert.assertTrue((boolean)(mdb instanceof XrefIterator));
    }

    @AfterClass
    public static void tearDown() throws Exception {
        mdb.close();
    }

    @Test
    public void testDatabaseLoading() {
        Assert.assertTrue((boolean)new File(METABOLITES).exists());
    }

    @Test
    public void testDatabaseOpening() throws IDMapperException {
        Assert.assertNotNull((Object)mdb);
    }

    @Test
    public void testFreeSearch() throws IDMapperException {
        Set<Xref> hits = mdb.freeSearch("aspirin", 5);
        Assert.assertNotNull(hits);
        Assert.assertNotSame((Object)0, (Object)hits.size());
        for (Xref ref : hits) {
            Assert.assertNotNull((Object)ref);
        }
    }

    @Test
    public void testIterator() throws IDMapperException {
        Assert.assertTrue((boolean)(mdb instanceof XrefIterator));
        XrefIterator iterator = (XrefIterator)((Object)mdb);
        for (Xref ref : iterator.getIterator()) {
            Assert.assertNotNull((Object)ref);
        }
    }

    @Test
    public void testHMDBIterator() throws IDMapperException {
        Assert.assertTrue((boolean)(mdb instanceof XrefIterator));
        XrefIterator iterator = (XrefIterator)((Object)mdb);
        int i = 0;
        for (Xref ref : iterator.getIterator(BioDataSource.HMDB)) {
            System.out.println(++i + " " + ref);
            Assert.assertNotNull((Object)ref);
        }
    }
}

