/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericConglomerateController;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapPostCommit;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;
import org.apache.derby.impl.store.access.heap.OpenHeap;

public class HeapController
extends GenericConglomerateController
implements ConglomerateController {
    protected final void getRowPositionFromRowLocation(RowLocation rowLocation, RowPosition rowPosition) throws StandardException {
        rowPosition.current_rh = ((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer());
        rowPosition.current_rh_qualified = true;
    }

    protected void queueDeletePostCommitWork(RowPosition rowPosition) throws StandardException {
        TransactionManager transactionManager = this.open_conglom.getXactMgr();
        transactionManager.addPostCommitWork(new HeapPostCommit(transactionManager.getAccessManager(), (Heap)this.open_conglom.getConglomerate(), rowPosition.current_page.getPageNumber()));
    }

    protected final boolean purgeCommittedDeletes(Page page) throws StandardException {
        boolean bl = false;
        int n = page.recordCount() - page.nonDeletedRecordCount();
        if (n > 0) {
            for (int i = page.recordCount() - 1; i >= 0; --i) {
                RecordHandle recordHandle;
                boolean bl2 = page.isDeletedAtSlot(i);
                if (!bl2 || !(bl2 = this.lockRowAtSlotNoWaitExclusive(recordHandle = page.fetchFromSlot(null, i, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) continue;
                bl = true;
                page.purgeAtSlot(i, 1, false);
            }
        }
        if (page.recordCount() == 0) {
            this.removePage(page);
            bl = true;
        }
        return bl;
    }

    private RecordHandle doInsert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        RecordHandle recordHandle;
        byte by;
        Page page = null;
        page = this.open_conglom.getContainer().getPageForInsert(0);
        if (page != null) {
            by = page.recordCount() == 0 ? (byte)8 : 1;
            recordHandle = page.insert(dataValueDescriptorArray, null, by, 100);
            page.unlatch();
            page = null;
            if (recordHandle != null) {
                return recordHandle;
            }
        }
        if ((page = this.open_conglom.getContainer().getPageForInsert(1)) != null) {
            by = page.recordCount() == 0 ? (byte)8 : 1;
            recordHandle = page.insert(dataValueDescriptorArray, null, by, 100);
            page.unlatch();
            page = null;
            if (recordHandle != null) {
                return recordHandle;
            }
        }
        page = this.open_conglom.getContainer().addPage();
        recordHandle = page.insert(dataValueDescriptorArray, null, (byte)8, 100);
        page.unlatch();
        page = null;
        return recordHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long load(TransactionManager transactionManager, Heap heap, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        OpenHeap openHeap;
        long l = 0L;
        int n = 5;
        if (bl) {
            n |= 2;
        }
        if ((openHeap = new OpenHeap()).init(null, heap, heap.format_ids, heap.collation_ids, transactionManager, transactionManager.getRawStoreXact(), false, n, 7, transactionManager.getRawStoreXact().newLockingPolicy(2, 5, true), null) == null) {
            throw StandardException.newException("XSCH1.S", new Long(heap.getId().getContainerId()));
        }
        this.init(openHeap);
        Page page = openHeap.getContainer().addPage();
        boolean bl2 = rowLocationRetRowSource.needsRowLocation();
        HeapRowLocation heapRowLocation = bl2 ? new HeapRowLocation() : null;
        FormatableBitSet formatableBitSet = rowLocationRetRowSource.getValidColumns();
        try {
            Object[] objectArray;
            while ((objectArray = rowLocationRetRowSource.getNextRowFromRowSource()) != null) {
                ++l;
                RecordHandle recordHandle = page.insert(objectArray, formatableBitSet, (byte)1, 100);
                if (recordHandle == null) {
                    page.unlatch();
                    page = null;
                    page = openHeap.getContainer().addPage();
                    recordHandle = page.insert(objectArray, formatableBitSet, (byte)8, 100);
                }
                if (!bl2) continue;
                heapRowLocation.setFrom(recordHandle);
                rowLocationRetRowSource.rowLocation(heapRowLocation);
            }
            page.unlatch();
            page = null;
            if (!heap.isTemporary()) {
                openHeap.getContainer().flushContainer();
            }
        }
        finally {
            this.close();
        }
        return l;
    }

    protected boolean lockRow(RecordHandle recordHandle, int n, boolean bl, int n2) throws StandardException {
        boolean bl2;
        boolean bl3;
        boolean bl4 = (1 & n) != 0;
        boolean bl5 = bl3 = (8 & n) != 0;
        if (bl4 && !bl3) {
            boolean bl6;
            boolean bl7 = (2 & n) != 0;
            boolean bl8 = bl6 = (4 & n) != 0;
            bl2 = n2 == 1 ? this.open_conglom.getContainer().getLockingPolicy().zeroDurationLockRecordForWrite(this.open_conglom.getRawTran(), recordHandle, bl6, bl) : this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), recordHandle, bl7, bl);
        } else {
            bl2 = this.open_conglom.getContainer().getLockingPolicy().lockRecordForRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), recordHandle, bl, bl4);
        }
        return bl2;
    }

    protected Page getUserPageNoWait(long l) throws StandardException {
        return this.open_conglom.getContainer().getUserPageNoWait(l);
    }

    protected Page getUserPageWait(long l) throws StandardException {
        return this.open_conglom.getContainer().getUserPageWait(l);
    }

    protected boolean lockRowAtSlotNoWaitExclusive(RecordHandle recordHandle) throws StandardException {
        return this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), recordHandle, false, false);
    }

    protected void removePage(Page page) throws StandardException {
        this.open_conglom.getContainer().removePage(page);
    }

    public int insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        this.doInsert(dataValueDescriptorArray);
        return 0;
    }

    public void insertAndFetchLocation(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RecordHandle recordHandle = this.doInsert(dataValueDescriptorArray);
        HeapRowLocation heapRowLocation = (HeapRowLocation)rowLocation;
        heapRowLocation.setFrom(recordHandle);
    }

    public boolean lockRow(RowLocation rowLocation, int n, boolean bl, int n2) throws StandardException {
        RecordHandle recordHandle = ((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer());
        return this.lockRow(recordHandle, n, bl, n2);
    }

    public void unlockRowAfterRead(RowLocation rowLocation, boolean bl, boolean bl2) throws StandardException {
        RecordHandle recordHandle = ((HeapRowLocation)rowLocation).getRecordHandle(this.open_conglom.getContainer());
        this.open_conglom.getContainer().getLockingPolicy().unlockRecordAfterRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), recordHandle, this.open_conglom.isForUpdate(), bl2);
    }

    public boolean lockRow(long l, int n, int n2, boolean bl, int n3) throws StandardException {
        RecordHandle recordHandle = this.open_conglom.getContainer().makeRecordHandle(l, n);
        return this.lockRow(recordHandle, n2, bl, n3);
    }

    public RowLocation newRowLocationTemplate() throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        return new HeapRowLocation();
    }
}

