/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Instance;
import weka.core.Instances;

public abstract class CachedKernel
extends Kernel {
    private int m_kernelEvals = 0;
    private int m_cacheHits = 0;
    private int m_cacheSize;
    private double[] m_storage;
    protected long[] m_keys;
    private double[][] m_kernelMatrix;
    private int m_numInsts;
    private int m_cacheSlots = 4;

    protected CachedKernel(Instances instances, int n) {
        this.m_data = instances;
        this.m_cacheSize = n;
        if (n > 0) {
            this.m_storage = new double[this.m_cacheSize * this.m_cacheSlots];
            this.m_keys = new long[this.m_cacheSize * this.m_cacheSlots];
        }
        this.m_numInsts = this.m_data.numInstances();
    }

    protected abstract double evaluate(int var1, int var2, Instance var3) throws Exception;

    public double eval(int n, int n2, Instance instance) throws Exception {
        double d = 0.0;
        long l = -1L;
        int n3 = -1;
        if (n >= 0) {
            long l2;
            if (this.m_cacheSize == 0) {
                if (this.m_kernelMatrix == null) {
                    this.m_kernelMatrix = new double[this.m_data.numInstances()][];
                    for (int i = 0; i < this.m_data.numInstances(); ++i) {
                        this.m_kernelMatrix[i] = new double[i + 1];
                        for (int j = 0; j <= i; ++j) {
                            ++this.m_kernelEvals;
                            this.m_kernelMatrix[i][j] = this.evaluate(i, j, this.m_data.instance(i));
                        }
                    }
                }
                ++this.m_cacheHits;
                d = n > n2 ? this.m_kernelMatrix[n][n2] : this.m_kernelMatrix[n2][n];
                return d;
            }
            l = n > n2 ? (long)n + (long)n2 * (long)this.m_numInsts : (long)n2 + (long)n * (long)this.m_numInsts;
            int n4 = n3 = (int)(l % (long)this.m_cacheSize) * this.m_cacheSlots;
            for (int i = 0; i < this.m_cacheSlots && (l2 = this.m_keys[n4]) != 0L; ++i) {
                if (l2 == l + 1L) {
                    ++this.m_cacheHits;
                    if (i > 0) {
                        double d2 = this.m_storage[n4];
                        this.m_storage[n4] = this.m_storage[n3];
                        this.m_keys[n4] = this.m_keys[n3];
                        this.m_storage[n3] = d2;
                        this.m_keys[n3] = l2;
                        return d2;
                    }
                    return this.m_storage[n4];
                }
                ++n4;
            }
        }
        d = this.evaluate(n, n2, instance);
        ++this.m_kernelEvals;
        if (l != -1L) {
            System.arraycopy(this.m_keys, n3, this.m_keys, n3 + 1, this.m_cacheSlots - 1);
            System.arraycopy(this.m_storage, n3, this.m_storage, n3 + 1, this.m_cacheSlots - 1);
            this.m_storage[n3] = d;
            this.m_keys[n3] = l + 1L;
        }
        return d;
    }

    public int numEvals() {
        return this.m_kernelEvals;
    }

    public int numCacheHits() {
        return this.m_cacheHits;
    }

    public void clean() {
        this.m_storage = null;
        this.m_keys = null;
        this.m_kernelMatrix = null;
    }

    protected final double dotProd(Instance instance, Instance instance2) throws Exception {
        double d = 0.0;
        int n = instance.numValues();
        int n2 = instance2.numValues();
        int n3 = this.m_data.classIndex();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n && n5 < n2) {
            int n6;
            int n7 = instance.index(n4);
            if (n7 == (n6 = instance2.index(n5))) {
                if (n7 != n3) {
                    d += instance.valueSparse(n4) * instance2.valueSparse(n5);
                }
                ++n4;
                ++n5;
                continue;
            }
            if (n7 > n6) {
                ++n5;
                continue;
            }
            ++n4;
        }
        return d;
    }
}

