### R code from vignette source 'BiRewire.Rnw'

###################################################
### code chunk number 1: loadBiRewire
###################################################
library(BiRewire)


###################################################
### code chunk number 2: GetABipartiteGraph
###################################################
data(BRCA_binary_matrix)##loads an binary genomic event matrix for the 
												##breast cancer dataset
g=birewire.bipartite.from.incidence(BRCA_binary_matrix)##models the dataset
																								## as igraph bipartite graph


###################################################
### code chunk number 3: PerformAnalisys
###################################################
step=5000
max=100*sum(BRCA_binary_matrix)
scores<-birewire.analysis(BRCA_binary_matrix,step,verbose=FALSE,max.iter=max)
plot(x=step*seq(1:length(scores$similarity_scores)),y= scores$similarity_scores,
		type='l', xlab="Number of switching steps",
		ylab="Jaccard Similarity Score",ylim=c(0,1))

legend(max*0.8,1, c("Jaccard Similarity","N"),
       cex=0.9, col=c("black","red"), lty=1:1,lwd=3)
abline(v=scores$N,col='red')
plot(x=step*seq(1:length(scores$similarity_scores)),y= scores$similarity_scores,
			type='l',xlab="Number of switching steps",
			ylab="Jaccard Similarity Score",log="xy",main="Log-Log plot")
legend("topright", c("Jaccard Similarity","N"),
       cex=0.9, col=c("black","red"), lty=1:1,lwd=3)
abline(v=scores$N,col='red')


###################################################
### code chunk number 4: PerformAnalisysUndirected
###################################################
g.und<-erdos.renyi.game(directed=F,loops=F,n=1000,p.or.m=0.01)
m.und<-get.adjacency(g.und,sparse=FALSE)
step=100
max=100*length(E(g.und))
scores.und<-birewire.analysis.undirected(m.und,step=step,verbose=FALSE,max.iter=max)
plot(x=step*seq(1:length(scores.und$similarity_scores)),y= scores.und$similarity_scores,
		type='l', xlab="Number of switching steps",
		ylab="Jaccard Similarity Score",ylim=c(0,1))
legend(max*0.8,1, c("Jaccard Similarity","N"),
       cex=0.9, col=c("black","red"), lty=1:1,lwd=3)
abline(v=scores.und$N,col='red')
plot(x=step*seq(1:length(scores.und$similarity_scores)),y= scores.und$similarity_scores,
			type='l',xlab="Number of switching steps",
			ylab="Jaccard Similarity Score",log="xy",main="Log-Log plot")
legend("topright", c("Jaccard Similarity","N"),
       cex=0.9, col=c("black","red"), lty=1:1,lwd=3)
abline(v=scores.und$N,col='red')


###################################################
### code chunk number 5: Rewire
###################################################
m2<-birewire.rewire.bipartite(BRCA_binary_matrix,verbose=FALSE)
g2<-birewire.rewire.bipartite(g,verbose=FALSE)


###################################################
### code chunk number 6: RewireUndirected
###################################################
m2.und<-birewire.rewire(m.und,verbose=FALSE)
g2.und<-birewire.rewire(g.und,verbose=FALSE)


###################################################
### code chunk number 7: Similarity
###################################################
sc=birewire.similarity(BRCA_binary_matrix,m2)
sc=birewire.similarity(BRCA_binary_matrix,t(m2))#also works


###################################################
### code chunk number 8: Projections
###################################################
#use a smaller graph!
gg <- simplify(graph.bipartite( rep(0:1,length=100),
c(c(1:100),seq(1,100,3),seq(1,100,7),100,seq(1,100,13),
seq(1,100,17),seq(1,100,19),seq(1,100,23),100
)))

result=birewire.rewire.bipartite.and.projections(gg,step=10,
        max.iter="n",accuracy=1,verbose=FALSE) 
plot(result$similarity_scores.proj2,type='l',col='red',ylim=c(0,1))
lines(result$similarity_scores.proj1,type='l',col='blue')
legend("top",1, c("Proj2","Proj1"), cex=0.9, col=c("blue","red"), lty=1:1,lwd=3)


