### R code from vignette source 'AffyTiling.Rnw'

###################################################
### code chunk number 1: AffyTiling.Rnw:41-42
###################################################
library(AffyTiling)


###################################################
### code chunk number 2: AffyTiling.Rnw:47-48 (eval = FALSE)
###################################################
## EXP <- AnalyzeTilingCelFiles(dir(pattern=".cel|.CEL"), "Hs_PromPR_v02-3_NCBIv34.bpmap")


###################################################
### code chunk number 3: AffyTiling.Rnw:53-55 (eval = FALSE)
###################################################
## colnames(EXP)
## EXP[1:10,1:5]


###################################################
### code chunk number 4: AffyTiling.Rnw:60-61 (eval = FALSE)
###################################################
## EXP <- AnalyzeTilingCelFiles(dir(pattern=".cel|.CEL"), "Hs_PromPR_v02-3_NCBIv34.bpmap", makeUniqueID=FALSE, readProbeSeq=TRUE)


###################################################
### code chunk number 5: AffyTiling.Rnw:67-72 (eval = FALSE)
###################################################
## iID <- c(1:3)
## iCHR <- c("chr1", "chr2", "chr3")
## iSTART <- rep(1, 3)
## iEND <- iSTART+1000000
## Einter <- AnalyzeTilingCelFiles(dir(pattern=".cel|.CEL"), "Hs_PromPR_v02-3_NCBIv34.bpmap", iID= iID, iCHR= iCHR, iSTART= iSTART, iEND= iEND)


###################################################
### code chunk number 6: AffyTiling.Rnw:87-89
###################################################
data(KnownGenes)
colnames(KG)


###################################################
### code chunk number 7: AffyTiling.Rnw:94-96
###################################################
NearestGenes <- AssociateWithGenes(KG[ , 1], KG[ , 2], KG[ , 3], KG[ , 4], KG[ , 5], Einter[ , 1], Einter[ , 3], (as.integer(Einter[ , 2])+13))
head(NearestGenes)


###################################################
### code chunk number 8: AffyTiling.Rnw:101-102
###################################################
NearestGenes <- AssociateWithGenes(KG[ , 1], KG[ , 2], KG[ , 3], KG[ , 4], KG[ , 5], Einter[ , 1], Einter[ , 3], (as.integer(Einter[ , 2])+13), D=1000)


###################################################
### code chunk number 9: AffyTiling.Rnw:107-108
###################################################
GeneOfInterest <- NearestGenes[which(NearestGenes[,2] == "AY358517"),]


###################################################
### code chunk number 10: AffyTiling.Rnw:113-114
###################################################
lapply(GeneOfInterest[,1], function(x) { Einter[which(Einter[,1] == x),] })[1:10]


###################################################
### code chunk number 11: AffyTiling.Rnw:119-122
###################################################
ExpSample1 <- as.double( lapply( GeneOfInterest[,1], function(x) { Einter[which(Einter[,1] == x),4] } ) )
GenomicPos <- as.integer(lapply(GeneOfInterest[,1], function(x) { Einter[which(Einter[,1] == x),2] }))
plot(GenomicPos, ExpSample1)


###################################################
### code chunk number 12: AffyTiling.Rnw:150-151 (eval = FALSE)
###################################################
## CpG <-read.table("CpG-Table.tsv", header=TRUE, sep="\t")


