#!/bin/sh

set -e  # Exit immediately if a simple command exits with a non-zero status

## Settings for merlot2:
TOOLS_DIR="/home/hpages/SNPlocsForge/forged/SNPlocs.Hsapiens.dbSNP.20101109/inst/tools"
DOWNLOAD_DIR="/home/hpages/SNPlocsForge/srcdata/SNPlocs.Hsapiens.dbSNP.20101109/downloads"
TMP_DIR="/home/hpages/SNPlocsForge/srcdata/SNPlocs.Hsapiens.dbSNP.20101109/tmp_files"

#SHORTSEQNAMES="22 Y MT"
SHORTSEQNAMES="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y MT"

R="$HOME/bin/R-2.11"
R_SCRIPT0="source('$TOOLS_DIR/utils.R')"

for chr in $SHORTSEQNAMES; do
    src_file="$DOWNLOAD_DIR/ds_flat_ch${chr}.flat"
    rawsnps_file="$TMP_DIR/ch${chr}_rawsnps.txt"
    echo "Extracting raw SNPs from $src_file ..."
    $TOOLS_DIR/filter1_ds_flat.sh <$src_file | \
      $TOOLS_DIR/filter2_ds_flat | \
      $TOOLS_DIR/filter3_ds_flat.sh $chr | \
      $TOOLS_DIR/filter4_ds_flat.sh >$rawsnps_file
done

R_SCRIPT="$R_SCRIPT0; loadAndserializeSNPs('$TMP_DIR', '$SHORTSEQNAMES')"
echo "$R_SCRIPT" | $R --vanilla

