#!/bin/sh

set -e  # Exit immediately if a simple command exits with a non-zero status

TOOLS_DIR="/home/hpages/svn/pilot/herve/SNPlocs/SNPlocs.Hsapiens.dbSNP.20071016/inst/tools"
DOWNLOAD_DIR="/home/hpages/dbSNP/downloads"
TMP_DIR="/home/hpages/dbSNP/tmp_files"

#CHR_SHORTNAMES="Y 22"
CHR_SHORTNAMES="1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 X Y"

R="$HOME/bin/R-2.7"
R_SCRIPT0="source('$TOOLS_DIR/utils.R')"

for chr in $CHR_SHORTNAMES; do
    src_file="$DOWNLOAD_DIR/ds_flat_ch${chr}.flat"
    rawsnps_file="$TMP_DIR/chr${chr}_rawsnps.txt"
    echo "Extracting raw SNPs from $src_file ..."
    $TOOLS_DIR/filter1_ds_flat.sh <$src_file | \
      $TOOLS_DIR/filter2_ds_flat | \
      $TOOLS_DIR/filter3_ds_flat.sh $chr | \
      $TOOLS_DIR/filter4_ds_flat.sh >$rawsnps_file
done

R_SCRIPT="$R_SCRIPT0; loadAndserializeSNPs('$TMP_DIR', '$CHR_SHORTNAMES')"
echo "$R_SCRIPT" | $R --vanilla

