###################################################
### chunk number 1: options
###################################################
#line 43 "GOSemSim.Rnw"
options(width=60)


###################################################
### chunk number 2: preliminaries
###################################################
#line 47 "GOSemSim.Rnw"
## w. verbose=TRUE
library(GOSemSim)
library(org.Hs.eg.db)
library(GO.db)


###################################################
### chunk number 3: Params
###################################################
#line 148 "GOSemSim.Rnw"
params <- new("Params", ontology="MF", organism="human", method="Wang")


###################################################
### chunk number 4: GOSet
###################################################
#line 152 "GOSemSim.Rnw"
go1 <- c("GO:0004022", "GO:0004024", "GO:0004023")
go2 <- c("GO:0009055", "GO:0020037")
gos <- new("GOSet", GOSet1=go1, GOSet2=go2)


###################################################
### chunk number 5: GeneSet
###################################################
#line 158 "GOSemSim.Rnw"
gs1 <- c("835", "5261","241", "994", "514", "533")
gs2 <- c("578","582", "400", "409", "411")
gs <- new("GeneSet", GeneSet1=gs1, GeneSet2=gs2)


###################################################
### chunk number 6: GeneClusterSet
###################################################
#line 164 "GOSemSim.Rnw"
x <- org.Hs.egGO
hsEG <- mappedkeys(x)
clusters <- list(a=sample(hsEG, 20), b=sample(hsEG, 20), c=sample(hsEG, 20))
geneClusters <- new("GeneClusterSet", GeneClusters=clusters)


###################################################
### chunk number 7: sim
###################################################
#line 171 "GOSemSim.Rnw"
sim(gos,params)
setCombineMethod(params)<-"rcmax.avg"
sim(gos,params)
sim(gs, params)
sim(geneClusters, params)


###################################################
### chunk number 8: old function call
###################################################
#line 180 "GOSemSim.Rnw"
goSim("GO:0004022", "GO:0005515", ont="MF", measure="Wang")
go1 = c("GO:0004022","GO:0004024","GO:0004174")
go2 = c("GO:0009055","GO:0005515")
mgoSim(go1, go2, ont="MF", measure="Wang", combine="rcmax.avg")
geneSim("241", "251", ont="MF", organism="human", measure="Wang", combine="rcmax.avg")

mgeneSim(genes=c("835", "5261","241", "994"), ont="MF", organism="human", measure="Wang")

clusterSim(gs1, gs2, ont="MF", organism="human", measure="Wang", combine="rcmax.avg")
mclusterSim(clusters, ont="MF", organism="human", measure="Wang", combine="rcmax.avg")


###################################################
### chunk number 9: 
###################################################
#line 198 "GOSemSim.Rnw"
sessionInfo()


