/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JComponent;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.JComponentWriter;

public class JPEGWriter
extends JComponentWriter {
    private float quality;
    private Color background;

    public JPEGWriter() {
    }

    public JPEGWriter(JComponent jComponent) {
        super(jComponent);
    }

    public JPEGWriter(JComponent jComponent, File file) {
        super(jComponent, file);
        this.quality = 1.0f;
        this.background = Color.WHITE;
    }

    public void initialize() {
        super.initialize();
        this.quality = 1.0f;
        this.background = Color.WHITE;
        this.setScalingEnabled(false);
    }

    public String getDescription() {
        return "JPEG-Image";
    }

    public String getExtension() {
        return ".jpg";
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float f) {
        this.quality = f;
    }

    public static void toOutput(JComponent jComponent, File file) throws Exception {
        JPEGWriter jPEGWriter = new JPEGWriter(jComponent, file);
        ((JComponentWriter)jPEGWriter).toOutput();
    }

    public void toOutput() throws Exception {
        BufferedImage bufferedImage = new BufferedImage(this.getComponent().getWidth(), this.getComponent().getHeight(), 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setPaintMode();
        graphics.setColor(this.getBackground());
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).scale(this.getXScale(), this.getYScale());
        }
        graphics.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
        this.getComponent().paint(graphics);
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(this.getExtension().replace(".", ""));
        if (!iterator.hasNext()) {
            throw new Exception("No writer available for " + this.getDescription() + "!");
        }
        imageWriter = iterator.next();
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(this.getFile());
        imageWriter.setOutput(imageOutputStream);
        JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
        jPEGImageWriteParam.setCompressionMode(2);
        jPEGImageWriteParam.setCompressionQuality(this.getQuality());
        imageWriter.write(null, new IIOImage(bufferedImage, null, null), jPEGImageWriteParam);
        imageOutputStream.flush();
        imageWriter.dispose();
        imageOutputStream.close();
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("building TreeVisualizer...");
        TreeBuild treeBuild = new TreeBuild();
        PlaceNode2 placeNode2 = new PlaceNode2();
        Node node = treeBuild.create(new StringReader("digraph atree { top [label=\"the top\"] a [label=\"the first node\"] b [label=\"the second nodes\"] c [label=\"comes off of first\"] top->a top->b b->c }"));
        TreeVisualizer treeVisualizer = new TreeVisualizer(null, node, (NodePlace)placeNode2);
        treeVisualizer.setSize(800, 600);
        String string = System.getProperty("java.io.tmpdir") + "test.jpg";
        System.out.println("outputting to '" + string + "'...");
        JPEGWriter.toOutput(treeVisualizer, new File(string));
        System.out.println("done!");
    }
}

