/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.BorderLayout;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;

public class InstanceViewer
extends JPanel
implements Serializable,
InstanceListener {
    private JTextArea m_OutputTex;
    private boolean m_Debug;
    private boolean m_Clear;
    private String m_UpdateString;

    private void updateOutput() {
        this.m_OutputTex.append(this.m_UpdateString);
        this.m_UpdateString = "";
    }

    private void clearOutput() {
        this.m_UpdateString = "";
        this.m_OutputTex.setText("");
    }

    public void inputFormat(Instances instances) {
        if (this.m_Debug) {
            System.err.println("InstanceViewer::inputFormat()\n" + instances.toString());
        }
        if (this.m_Clear) {
            this.clearOutput();
        }
        this.m_UpdateString = this.m_UpdateString + instances.toString();
        this.updateOutput();
    }

    public void input(Instance instance) throws Exception {
        if (this.m_Debug) {
            System.err.println("InstanceViewer::input(" + instance + ")");
        }
        this.m_UpdateString = this.m_UpdateString + instance.toString() + "\n";
        this.updateOutput();
    }

    public void batchFinished() {
        this.updateOutput();
        if (this.m_Debug) {
            System.err.println("InstanceViewer::batchFinished()");
        }
    }

    public InstanceViewer() {
        this.setLayout(new BorderLayout());
        this.m_UpdateString = "";
        this.setClearEachDataset(true);
        this.m_OutputTex = new JTextArea(10, 20);
        this.m_OutputTex.setEditable(false);
        this.add("Center", new JScrollPane(this.m_OutputTex));
    }

    public void setClearEachDataset(boolean bl) {
        this.m_Clear = bl;
    }

    public boolean getClearEachDataset() {
        return this.m_Clear;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void instanceProduced(InstanceEvent instanceEvent) {
        Object object = instanceEvent.getSource();
        if (object instanceof InstanceProducer) {
            try {
                InstanceProducer instanceProducer = (InstanceProducer)object;
                switch (instanceEvent.getID()) {
                    case 1: {
                        this.inputFormat(instanceProducer.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(instanceProducer.outputPeek());
                        break;
                    }
                    case 3: {
                        this.batchFinished();
                        break;
                    }
                    default: {
                        System.err.println("InstanceViewer::instanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else {
            System.err.println("InstanceViewer::instanceProduced() - Unknown source object type");
        }
    }
}

