/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.RTSI;
import weka.core.Utils;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class GenericPropertiesCreator {
    public static final boolean VERBOSE = false;
    protected static String CREATOR_FILE = "weka/gui/GenericPropertiesCreator.props";
    protected static String PROPERTY_FILE = "weka/gui/GenericObjectEditor.props";
    protected String inputFilename;
    protected String outputFilename;
    protected Properties inputProperties;
    protected Properties outputProperties;
    protected boolean explicitPropsFile;

    public GenericPropertiesCreator() throws Exception {
        this(CREATOR_FILE);
        this.explicitPropsFile = false;
    }

    public GenericPropertiesCreator(String string) throws Exception {
        this.inputFilename = string;
        this.outputFilename = PROPERTY_FILE;
        this.inputProperties = null;
        this.outputProperties = null;
        this.explicitPropsFile = true;
    }

    public void setExplicitPropsFile(boolean bl) {
        this.explicitPropsFile = bl;
    }

    public boolean getExplicitPropsFile() {
        return this.explicitPropsFile;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String string) {
        this.outputFilename = string;
    }

    public String getInputFilename() {
        return this.inputFilename;
    }

    public void setInputFilename(String string) {
        this.inputFilename = string;
        this.setExplicitPropsFile(true);
    }

    public Properties getInputProperties() {
        return this.inputProperties;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    protected void loadInputProperties() throws Exception {
        this.inputProperties = new Properties();
        try {
            File file = new File(this.getInputFilename());
            if (this.getExplicitPropsFile() && file.exists()) {
                this.inputProperties.load(new FileInputStream(this.getInputFilename()));
            } else {
                this.inputProperties = Utils.readProperties(this.getInputFilename());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean isValidClassname(String string) {
        return string.indexOf("$") == -1;
    }

    protected boolean isValidClassname(String string, String string2) {
        boolean bl = true;
        if (string.equals(ResultListener.class.getName())) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (RTSI.hasInterface(ResultProducer.class, clazz)) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    protected void generateOutputProperties() throws Exception {
        this.outputProperties = new Properties();
        Enumeration<?> enumeration = this.inputProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(this.inputProperties.getProperty(string), ",");
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                Vector vector;
                String string3 = stringTokenizer.nextToken().trim();
                try {
                    vector = RTSI.find(string3, Class.forName(string));
                }
                catch (Exception exception) {
                    System.out.println("Problem with '" + string + "': " + exception);
                    vector = new Vector();
                }
                for (int i = 0; i < vector.size(); ++i) {
                    if (!this.isValidClassname(vector.get(i).toString()) || !this.isValidClassname(string, vector.get(i).toString())) continue;
                    if (!string2.equals("")) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + vector.get(i).toString();
                }
            }
            this.outputProperties.setProperty(string, string2);
        }
    }

    protected void storeOutputProperties() throws Exception {
        this.outputProperties.store(new FileOutputStream(this.getOutputFilename()), " Customises the list of options given by the GenericObjectEditor\n# for various superclasses.");
    }

    public void execute() throws Exception {
        this.execute(true);
    }

    public void execute(boolean bl) throws Exception {
        this.loadInputProperties();
        this.generateOutputProperties();
        if (bl) {
            this.storeOutputProperties();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        GenericPropertiesCreator genericPropertiesCreator = null;
        if (stringArray.length == 0) {
            genericPropertiesCreator = new GenericPropertiesCreator();
        } else if (stringArray.length == 1) {
            genericPropertiesCreator = new GenericPropertiesCreator();
            genericPropertiesCreator.setOutputFilename(stringArray[0]);
        } else if (stringArray.length == 2) {
            genericPropertiesCreator = new GenericPropertiesCreator(stringArray[0]);
            genericPropertiesCreator.setOutputFilename(stringArray[1]);
        } else {
            System.out.println("usage: " + GenericPropertiesCreator.class.getName() + " [<input.props>] [<output.props>]");
            System.exit(1);
        }
        genericPropertiesCreator.execute(true);
    }
}

