/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemoveMisclassified
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    protected Classifier m_cleansingClassifier = new ZeroR();
    protected int m_classIndex = -1;
    protected int m_numOfCrossValidationFolds = 0;
    protected int m_numOfCleansingIterations = 0;
    protected double m_numericClassifyThreshold = 0.1;
    protected boolean m_invertMatching = false;
    protected boolean m_firstBatchFinished = false;

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_firstBatchFinished = false;
        return true;
    }

    private Instances cleanseTrain(Instances instances) throws Exception {
        Instances instances2 = new Instances(instances);
        Instances instances3 = new Instances(instances, instances.numInstances());
        Instances instances4 = new Instances(instances, instances.numInstances());
        int n = 0;
        int n2 = 0;
        int n3 = this.m_classIndex;
        if (n3 < 0) {
            n3 = instances.classIndex();
        }
        if (n3 < 0) {
            n3 = instances.numAttributes() - 1;
        }
        while (n != instances2.numInstances() && (this.m_numOfCleansingIterations <= 0 || ++n2 <= this.m_numOfCleansingIterations)) {
            n = instances2.numInstances();
            instances2.setClassIndex(n3);
            this.m_cleansingClassifier.buildClassifier(instances2);
            instances3 = new Instances(instances2, instances2.numInstances());
            for (int i = 0; i < instances2.numInstances(); ++i) {
                Instance instance = instances2.instance(i);
                double d = this.m_cleansingClassifier.classifyInstance(instance);
                if (instances2.classAttribute().isNumeric()) {
                    if (d >= instance.classValue() - this.m_numericClassifyThreshold && d <= instance.classValue() + this.m_numericClassifyThreshold) {
                        instances3.add(instance);
                        continue;
                    }
                    if (!this.m_invertMatching) continue;
                    instances4.add(instance);
                    continue;
                }
                if (d == instance.classValue()) {
                    instances3.add(instance);
                    continue;
                }
                if (!this.m_invertMatching) continue;
                instances4.add(instance);
            }
            instances2 = instances3;
        }
        if (this.m_invertMatching) {
            instances4.setClassIndex(instances.classIndex());
            return instances4;
        }
        instances2.setClassIndex(instances.classIndex());
        return instances2;
    }

    private Instances cleanseCross(Instances instances) throws Exception {
        Instances instances2 = new Instances(instances);
        Instances instances3 = new Instances(instances, instances.numInstances());
        Instances instances4 = new Instances(instances, instances.numInstances());
        int n = 0;
        int n2 = 0;
        int n3 = this.m_classIndex;
        if (n3 < 0) {
            n3 = instances.classIndex();
        }
        if (n3 < 0) {
            n3 = instances.numAttributes() - 1;
        }
        while (n != instances2.numInstances() && instances2.numInstances() >= this.m_numOfCrossValidationFolds) {
            n = instances2.numInstances();
            if (this.m_numOfCleansingIterations > 0 && ++n2 > this.m_numOfCleansingIterations) break;
            instances2.setClassIndex(n3);
            if (instances2.classAttribute().isNominal()) {
                instances2.stratify(this.m_numOfCrossValidationFolds);
            }
            instances3 = new Instances(instances2, instances2.numInstances());
            for (int i = 0; i < this.m_numOfCrossValidationFolds; ++i) {
                Instances instances5 = instances2.trainCV(this.m_numOfCrossValidationFolds, i);
                this.m_cleansingClassifier.buildClassifier(instances5);
                Instances instances6 = instances2.testCV(this.m_numOfCrossValidationFolds, i);
                for (int j = 0; j < instances6.numInstances(); ++j) {
                    Instance instance = instances6.instance(j);
                    double d = this.m_cleansingClassifier.classifyInstance(instance);
                    if (instances2.classAttribute().isNumeric()) {
                        if (d >= instance.classValue() - this.m_numericClassifyThreshold && d <= instance.classValue() + this.m_numericClassifyThreshold) {
                            instances3.add(instance);
                            continue;
                        }
                        if (!this.m_invertMatching) continue;
                        instances4.add(instance);
                        continue;
                    }
                    if (d == instance.classValue()) {
                        instances3.add(instance);
                        continue;
                    }
                    if (!this.m_invertMatching) continue;
                    instances4.add(instance);
                }
            }
            instances2 = instances3;
        }
        if (this.m_invertMatching) {
            instances4.setClassIndex(instances.classIndex());
            return instances4;
        }
        instances2.setClassIndex(instances.classIndex());
        return instances2;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.inputFormatPeek() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_firstBatchFinished) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.m_firstBatchFinished) {
            Instances instances = this.m_numOfCrossValidationFolds < 2 ? this.cleanseTrain(this.getInputFormat()) : this.cleanseCross(this.getInputFormat());
            for (int i = 0; i < instances.numInstances(); ++i) {
                this.push(instances.instance(i));
            }
            this.m_firstBatchFinished = true;
            this.flushInput();
        }
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tFull class name of classifier to use, followed\n\tby scheme options. (required)\n\teg: \"weka.classifiers.bayes.NaiveBayes -D\"", "W", 1, "-W <classifier specification>"));
        vector.addElement(new Option("\tAttribute on which misclassifications are based.\n\tIf < 0 will use any current set class or default to the last attribute.", "C", 1, "-C <class index>"));
        vector.addElement(new Option("\tThe number of folds to use for cross-validation cleansing.\n\t(<2 = no cross-validation - default).", "F", 1, "-F <number of folds>"));
        vector.addElement(new Option("\tThreshold for the max error when predicting numeric class.\n\t(Value should be >= 0, default = 0.1).", "T", 1, "-T <threshold>"));
        vector.addElement(new Option("\tThe maximum number of cleansing iterations to perform.\n\t(<1 = until fully cleansed - default)", "I", 1, "-I"));
        vector.addElement(new Option("\tInvert the match so that correctly classified instances are discarded.\n", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length == 0) {
            throw new Exception("Invalid classifier specification string");
        }
        String string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setClassifier(Classifier.forName(string2, stringArray2));
        String string3 = Utils.getOption('C', stringArray);
        if (string3.length() != 0) {
            this.setClassIndex(new Double(string3).intValue());
        } else {
            this.setClassIndex(-1);
        }
        String string4 = Utils.getOption('F', stringArray);
        if (string4.length() != 0) {
            this.setNumFolds(new Double(string4).intValue());
        } else {
            this.setNumFolds(0);
        }
        String string5 = Utils.getOption('T', stringArray);
        if (string5.length() != 0) {
            this.setThreshold(new Double(string5));
        } else {
            this.setThreshold(0.1);
        }
        String string6 = Utils.getOption('I', stringArray);
        if (string5.length() != 0) {
            this.setMaxIterations(new Double(string5).intValue());
        } else {
            this.setMaxIterations(0);
        }
        if (Utils.getFlag('V', stringArray)) {
            this.setInvert(true);
        } else {
            this.setInvert(false);
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[15];
        int n = 0;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.getClassifierSpec();
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getClassIndex();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getNumFolds();
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.getThreshold();
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getMaxIterations();
        if (this.getInvert()) {
            stringArray[n++] = "-V";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "A filter that removes instances which are incorrectly classified. Useful for removing outliers.";
    }

    public String classifierTipText() {
        return "The classifier upon which to base the misclassifications.";
    }

    public void setClassifier(Classifier classifier) {
        this.m_cleansingClassifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_cleansingClassifier;
    }

    protected String getClassifierSpec() {
        Classifier classifier = this.getClassifier();
        if (classifier instanceof OptionHandler) {
            return classifier.getClass().getName() + " " + Utils.joinOptions(classifier.getOptions());
        }
        return classifier.getClass().getName();
    }

    public String classIndexTipText() {
        return "Index of the class upon which to base the misclassifications. If < 0 will use any current set class or default to the last attribute.";
    }

    public void setClassIndex(int n) {
        this.m_classIndex = n;
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    public String numFoldsTipText() {
        return "The number of cross-validation folds to use. If < 2 then no cross-validation will be performed.";
    }

    public void setNumFolds(int n) {
        this.m_numOfCrossValidationFolds = n;
    }

    public int getNumFolds() {
        return this.m_numOfCrossValidationFolds;
    }

    public String thresholdTipText() {
        return "Threshold for the max allowable error when predicting a numeric class. Should be >= 0.";
    }

    public void setThreshold(double d) {
        this.m_numericClassifyThreshold = d;
    }

    public double getThreshold() {
        return this.m_numericClassifyThreshold;
    }

    public String maxIterationsTipText() {
        return "The maximum number of iterations to perform. < 1 means filter will go until fully cleansed.";
    }

    public void setMaxIterations(int n) {
        this.m_numOfCleansingIterations = n;
    }

    public int getMaxIterations() {
        return this.m_numOfCleansingIterations;
    }

    public String invertTipText() {
        return "Whether or not to invert the selection. If true, correctly classified instances will be discarded.";
    }

    public void setInvert(boolean bl) {
        this.m_invertMatching = bl;
    }

    public boolean getInvert() {
        return this.m_invertMatching;
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new RemoveMisclassified(), stringArray);
            } else {
                Filter.filterFile(new RemoveMisclassified(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

