/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomTree
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
Randomizable {
    protected RandomTree[] m_Successors;
    protected int m_Attribute = -1;
    protected double m_SplitPoint = Double.NaN;
    protected double[][] m_Distribution = null;
    protected Instances m_Info = null;
    protected double[] m_Prop = null;
    protected double[] m_ClassProbs = null;
    protected double m_MinNum = 1.0;
    protected boolean m_Debug = false;
    protected int m_KValue = 1;
    protected int m_randomSeed = 1;

    public String globalInfo() {
        return "Class for constructing a tree that considers K randomly  chosen attributes at each node. Performs no pruning.";
    }

    public String minNumTipText() {
        return "The minimum total weight of the instances in a leaf.";
    }

    public double getMinNum() {
        return this.m_MinNum;
    }

    public void setMinNum(double d) {
        this.m_MinNum = d;
    }

    public String KValueTipText() {
        return "Sets the number of randomly chosen attributes.";
    }

    public int getKValue() {
        return this.m_KValue;
    }

    public void setKValue(int n) {
        this.m_KValue = n;
    }

    public String debugTipText() {
        return "Whether debug information is output to the console.";
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public String seedTipText() {
        return "The random number seed used for selecting attributes.";
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tNumber of attributes to randomly investigate\n\t(<1 = int(log(#attributes)+1)).", "K", 1, "-K <number of attributes>"));
        vector.addElement(new Option("\tSet minimum number of instances per leaf.", "M", 1, "-M <minimum number of instances>"));
        vector.addElement(new Option("\tTurns debugging info on.", "D", 0, "-D"));
        vector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S"));
        return vector.elements();
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        stringArray[n++] = "-K";
        stringArray[n++] = "" + this.getKValue();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMinNum();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        if (this.getDebug()) {
            stringArray[n++] = "-D";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('K', stringArray);
        this.m_KValue = string.length() != 0 ? Integer.parseInt(string) : 1;
        String string2 = Utils.getOption('M', stringArray);
        this.m_MinNum = string2.length() != 0 ? Double.parseDouble(string2) : 1.0;
        String string3 = Utils.getOption('S', stringArray);
        if (string3.length() != 0) {
            this.setSeed(Integer.parseInt(string3));
        } else {
            this.setSeed(1);
        }
        this.m_Debug = Utils.getFlag('D', stringArray);
        Utils.checkForRemainingOptions(stringArray);
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (this.m_KValue > instances.numAttributes() - 1) {
            this.m_KValue = instances.numAttributes() - 1;
        }
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2(instances.numAttributes()) + 1;
        }
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("RandomTree: Nominal class, please.");
        }
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numInstances() == 0) {
            throw new IllegalArgumentException("RandomTree: zero training instances or all instances have missing class!");
        }
        if (instances.numAttributes() == 1) {
            throw new IllegalArgumentException("RandomTree: Attribute missing. Need at least one attribute other than class attribute!");
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException("Cannot handle string attributes!");
        }
        Instances instances2 = instances;
        int[][] nArray = new int[instances2.numAttributes()][0];
        double[][] dArray = new double[instances2.numAttributes()][0];
        double[] dArray2 = new double[instances2.numInstances()];
        for (int i = 0; i < instances2.numAttributes(); ++i) {
            if (i == instances2.classIndex()) continue;
            dArray[i] = new double[instances2.numInstances()];
            if (instances2.attribute(i).isNominal()) {
                Instance instance;
                int n2;
                nArray[i] = new int[instances2.numInstances()];
                n = 0;
                for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                    instance = instances2.instance(n2);
                    if (instance.isMissing(i)) continue;
                    nArray[i][n] = n2;
                    dArray[i][n] = instance.weight();
                    ++n;
                }
                for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                    instance = instances2.instance(n2);
                    if (!instance.isMissing(i)) continue;
                    nArray[i][n] = n2;
                    dArray[i][n] = instance.weight();
                    ++n;
                }
                continue;
            }
            for (n = 0; n < instances2.numInstances(); ++n) {
                Instance instance = instances2.instance(n);
                dArray2[n] = instance.value(i);
            }
            nArray[i] = Utils.sort(dArray2);
            for (n = 0; n < instances2.numInstances(); ++n) {
                dArray[i][n] = instances2.instance(nArray[i][n]).weight();
            }
        }
        double[] dArray3 = new double[instances2.numClasses()];
        for (n = 0; n < instances2.numInstances(); ++n) {
            Instance instance = instances2.instance(n);
            int n3 = (int)instance.classValue();
            dArray3[n3] = dArray3[n3] + instance.weight();
        }
        int[] nArray2 = new int[instances.numAttributes() - 1];
        int n4 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (n4 == instances.classIndex()) {
                // empty if block
            }
            int n5 = ++n4;
            ++n4;
            nArray2[i] = n5;
        }
        this.buildTree(nArray, dArray, instances2, dArray3, new Instances(instances2, 0), this.m_MinNum, this.m_Debug, nArray2, instances.getRandomNumberGenerator(this.m_randomSeed));
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = null;
        if (this.m_Attribute > -1) {
            if (instance.isMissing(this.m_Attribute)) {
                dArray = new double[this.m_Info.numClasses()];
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    double[] dArray2 = this.m_Successors[i].distributionForInstance(instance);
                    if (dArray2 == null) continue;
                    for (int j = 0; j < dArray2.length; ++j) {
                        int n = j;
                        dArray[n] = dArray[n] + this.m_Prop[i] * dArray2[j];
                    }
                }
            } else {
                dArray = this.m_Info.attribute(this.m_Attribute).isNominal() ? this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance) : (instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance));
            }
        }
        if (this.m_Attribute == -1 || dArray == null) {
            return this.m_ClassProbs;
        }
        return dArray;
    }

    public String toGraph() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.toGraph(stringBuffer, 0);
            String string = "digraph Tree {\nedge [style=bold]\n" + stringBuffer.toString() + "\n}\n";
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int toGraph(StringBuffer stringBuffer, int n) throws Exception {
        int n2 = Utils.maxIndex(this.m_ClassProbs);
        String string = this.m_Info.classAttribute().value(n2);
        ++n;
        if (this.m_Attribute == -1) {
            stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + ": " + string + "\"" + "shape=box]\n");
        } else {
            stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + ": " + string + "\"]\n");
            for (int i = 0; i < this.m_Successors.length; ++i) {
                stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + "->" + "N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"" + this.m_Info.attribute(this.m_Attribute).name());
                if (this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                    if (i == 0) {
                        stringBuffer.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                    } else {
                        stringBuffer.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                    }
                } else {
                    stringBuffer.append(" = " + this.m_Info.attribute(this.m_Attribute).value(i));
                }
                stringBuffer.append("\"]\n");
                n = this.m_Successors[i].toGraph(stringBuffer, n);
            }
        }
        return n;
    }

    public String toString() {
        if (this.m_Successors == null) {
            return "RandomTree: no model has been built yet.";
        }
        return "\nRandomTree\n==========\n" + this.toString(0) + "\n" + "\nSize of the tree : " + this.numNodes();
    }

    protected String leafString() throws Exception {
        int n = Utils.maxIndex(this.m_Distribution[0]);
        return " : " + this.m_Info.classAttribute().value(n) + " (" + Utils.doubleToString(Utils.sum(this.m_Distribution[0]), 2) + "/" + Utils.doubleToString(Utils.sum(this.m_Distribution[0]) - this.m_Distribution[0][n], 2) + ")";
    }

    protected String toString(int n) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_Attribute == -1) {
                return this.leafString();
            }
            if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    stringBuffer.append("\n");
                    for (int j = 0; j < n; ++j) {
                        stringBuffer.append("|   ");
                    }
                    stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " = " + this.m_Info.attribute(this.m_Attribute).value(i));
                    stringBuffer.append(this.m_Successors[i].toString(n + 1));
                }
            } else {
                int n2;
                stringBuffer.append("\n");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("|   ");
                }
                stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " < " + Utils.doubleToString(this.m_SplitPoint, 2));
                stringBuffer.append(this.m_Successors[0].toString(n + 1));
                stringBuffer.append("\n");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("|   ");
                }
                stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                stringBuffer.append(this.m_Successors[1].toString(n + 1));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "RandomTree: tree can't be printed";
        }
    }

    protected void buildTree(int[][] nArray, double[][] dArray, Instances instances, double[] dArray2, Instances instances2, double d, boolean bl, int[] nArray2, Random random) throws Exception {
        int n;
        this.m_Info = instances2;
        this.m_Debug = bl;
        this.m_MinNum = d;
        if (instances.classIndex() > 0 && nArray[0].length == 0 || instances.classIndex() == 0 && nArray[1].length == 0) {
            this.m_Distribution = new double[1][instances.numClasses()];
            this.m_ClassProbs = null;
            return;
        }
        this.m_ClassProbs = new double[dArray2.length];
        System.arraycopy(dArray2, 0, this.m_ClassProbs, 0, dArray2.length);
        if (Utils.sum(this.m_ClassProbs) < 2.0 * this.m_MinNum || Utils.eq(this.m_ClassProbs[Utils.maxIndex(this.m_ClassProbs)], Utils.sum(this.m_ClassProbs))) {
            this.m_Attribute = -1;
            this.m_Distribution = new double[1][this.m_ClassProbs.length];
            for (int i = 0; i < this.m_ClassProbs.length; ++i) {
                this.m_Distribution[0][i] = this.m_ClassProbs[i];
            }
            Utils.normalize(this.m_ClassProbs);
            return;
        }
        double[] dArray3 = new double[instances.numAttributes()];
        double[][][] dArray4 = new double[instances.numAttributes()][0][0];
        double[][] dArray5 = new double[instances.numAttributes()][0];
        double[] dArray6 = new double[instances.numAttributes()];
        int n2 = 0;
        int n3 = this.m_KValue;
        boolean bl2 = false;
        for (int i = nArray2.length; !(i <= 0 || n3-- <= 0 && bl2); --i) {
            n = random.nextInt(i);
            n2 = nArray2[n];
            nArray2[n] = nArray2[i - 1];
            nArray2[i - 1] = n2;
            dArray6[n2] = this.distribution(dArray5, dArray4, n2, nArray[n2], dArray[n2], instances);
            dArray3[n2] = this.gain(dArray4[n2], this.priorVal(dArray4[n2]));
            if (!(dArray3[n2] > 0.0)) continue;
            bl2 = true;
        }
        this.m_Attribute = Utils.maxIndex(dArray3);
        this.m_Distribution = dArray4[this.m_Attribute];
        if (dArray3[this.m_Attribute] > 0.0) {
            this.m_SplitPoint = dArray6[this.m_Attribute];
            this.m_Prop = dArray5[this.m_Attribute];
            int[][][] nArray3 = new int[this.m_Distribution.length][instances.numAttributes()][0];
            double[][][] dArray7 = new double[this.m_Distribution.length][instances.numAttributes()][0];
            this.splitData(nArray3, dArray7, this.m_Attribute, this.m_SplitPoint, nArray, dArray, this.m_Distribution, instances);
            this.m_Successors = new RandomTree[this.m_Distribution.length];
            for (int i = 0; i < this.m_Distribution.length; ++i) {
                this.m_Successors[i] = new RandomTree();
                this.m_Successors[i].setKValue(this.m_KValue);
                this.m_Successors[i].buildTree(nArray3[i], dArray7[i], instances, this.m_Distribution[i], instances2, this.m_MinNum, this.m_Debug, nArray2, random);
            }
        } else {
            this.m_Attribute = -1;
            this.m_Distribution = new double[1][this.m_ClassProbs.length];
            for (n = 0; n < this.m_ClassProbs.length; ++n) {
                this.m_Distribution[0][n] = this.m_ClassProbs[n];
            }
        }
        Utils.normalize(this.m_ClassProbs);
    }

    public int numNodes() {
        if (this.m_Attribute == -1) {
            return 1;
        }
        int n = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            n += this.m_Successors[i].numNodes();
        }
        return n;
    }

    protected void splitData(int[][][] nArray, double[][][] dArray, int n, double d, int[][] nArray2, double[][] dArray2, double[][] dArray3, Instances instances) throws Exception {
        for (int i = 0; i < instances.numAttributes(); ++i) {
            int n2;
            int n3;
            int[] nArray3;
            if (i == instances.classIndex()) continue;
            if (instances.attribute(n).isNominal()) {
                nArray3 = new int[instances.attribute(n).numValues()];
                for (n3 = 0; n3 < nArray3.length; ++n3) {
                    nArray[n3][i] = new int[nArray2[i].length];
                    dArray[n3][i] = new double[nArray2[i].length];
                }
                for (n2 = 0; n2 < nArray2[i].length; ++n2) {
                    int n4;
                    Instance instance = instances.instance(nArray2[i][n2]);
                    if (instance.isMissing(n)) {
                        for (n4 = 0; n4 < nArray3.length; ++n4) {
                            if (!(this.m_Prop[n4] > 0.0)) continue;
                            nArray[n4][i][nArray3[n4]] = nArray2[i][n2];
                            dArray[n4][i][nArray3[n4]] = this.m_Prop[n4] * dArray2[i][n2];
                            int n5 = n4;
                            nArray3[n5] = nArray3[n5] + 1;
                        }
                        continue;
                    }
                    n4 = (int)instance.value(n);
                    nArray[n4][i][nArray3[n4]] = nArray2[i][n2];
                    dArray[n4][i][nArray3[n4]] = dArray2[i][n2];
                    int n6 = n4;
                    nArray3[n6] = nArray3[n6] + 1;
                }
            } else {
                nArray3 = new int[2];
                for (n3 = 0; n3 < 2; ++n3) {
                    nArray[n3][i] = new int[nArray2[i].length];
                    dArray[n3][i] = new double[dArray2[i].length];
                }
                for (n2 = 0; n2 < nArray2[i].length; ++n2) {
                    int n7;
                    Instance instance = instances.instance(nArray2[i][n2]);
                    if (instance.isMissing(n)) {
                        for (n7 = 0; n7 < nArray3.length; ++n7) {
                            if (!(this.m_Prop[n7] > 0.0)) continue;
                            nArray[n7][i][nArray3[n7]] = nArray2[i][n2];
                            dArray[n7][i][nArray3[n7]] = this.m_Prop[n7] * dArray2[i][n2];
                            int n8 = n7;
                            nArray3[n8] = nArray3[n8] + 1;
                        }
                        continue;
                    }
                    n7 = instance.value(n) < d ? 0 : 1;
                    nArray[n7][i][nArray3[n7]] = nArray2[i][n2];
                    dArray[n7][i][nArray3[n7]] = dArray2[i][n2];
                    int n9 = n7;
                    nArray3[n9] = nArray3[n9] + 1;
                }
            }
            for (n3 = 0; n3 < nArray3.length; ++n3) {
                int[] nArray4 = new int[nArray3[n3]];
                System.arraycopy(nArray[n3][i], 0, nArray4, 0, nArray3[n3]);
                nArray[n3][i] = nArray4;
                double[] dArray4 = new double[nArray3[n3]];
                System.arraycopy(dArray[n3][i], 0, dArray4, 0, nArray3[n3]);
                dArray[n3][i] = dArray4;
            }
        }
    }

    protected double distribution(double[][] dArray, double[][][] dArray2, int n, int[] nArray, double[] dArray3, Instances instances) throws Exception {
        int n2;
        Object object;
        int n3;
        double d = Double.NaN;
        Attribute attribute = instances.attribute(n);
        double[][] dArray4 = null;
        if (attribute.isNominal()) {
            dArray4 = new double[attribute.numValues()][instances.numClasses()];
            for (n3 = 0; n3 < nArray.length && !((Instance)(object = (Object)instances.instance(nArray[n3]))).isMissing(n); ++n3) {
                double[] dArray5 = dArray4[(int)((Instance)object).value(n)];
                int n4 = (int)((Instance)object).classValue();
                dArray5[n4] = dArray5[n4] + dArray3[n3];
            }
        } else {
            Instance instance;
            Instance instance2;
            object = new double[2][instances.numClasses()];
            dArray4 = new double[2][instances.numClasses()];
            for (int i = 0; i < nArray.length && !(instance2 = instances.instance(nArray[i])).isMissing(n); ++i) {
                Object object2 = object[1];
                int n5 = (int)instance2.classValue();
                object2[n5] = object2[n5] + dArray3[i];
            }
            double d2 = this.priorVal((double[][])object);
            for (int i = 0; i < ((Object)object).length; ++i) {
                System.arraycopy(object[i], 0, dArray4[i], 0, dArray4[i].length);
            }
            double d3 = instances.instance(nArray[0]).value(n);
            double d4 = -1.7976931348623157E308;
            for (n3 = 0; n3 < nArray.length && !(instance = instances.instance(nArray[n3])).isMissing(n); ++n3) {
                double d5;
                if (instance.value(n) > d3 && (d5 = this.gain((double[][])object, d2)) > d4) {
                    d4 = d5;
                    d = (instance.value(n) + d3) / 2.0;
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        System.arraycopy(object[i], 0, dArray4[i], 0, dArray4[i].length);
                    }
                }
                d3 = instance.value(n);
                Object object3 = object[0];
                int n6 = (int)instance.classValue();
                object3[n6] = object3[n6] + dArray3[n3];
                Object object4 = object[1];
                int n7 = (int)instance.classValue();
                object4[n7] = object4[n7] - dArray3[n3];
            }
        }
        dArray[n] = new double[dArray4.length];
        for (n2 = 0; n2 < dArray[n].length; ++n2) {
            dArray[n][n2] = Utils.sum(dArray4[n2]);
        }
        if (Utils.eq(Utils.sum(dArray[n]), 0.0)) {
            for (n2 = 0; n2 < dArray[n].length; ++n2) {
                dArray[n][n2] = 1.0 / (double)dArray[n].length;
            }
        } else {
            Utils.normalize(dArray[n]);
        }
        if (n3 < nArray.length) {
            while (n3 < nArray.length) {
                Instance instance = instances.instance(nArray[n3]);
                for (int i = 0; i < dArray4.length; ++i) {
                    double[] dArray6 = dArray4[i];
                    int n8 = (int)instance.classValue();
                    dArray6[n8] = dArray6[n8] + dArray[n][i] * dArray3[n3];
                }
                ++n3;
            }
        }
        dArray2[n] = dArray4;
        return d;
    }

    protected double priorVal(double[][] dArray) {
        return ContingencyTables.entropyOverColumns(dArray);
    }

    protected double gain(double[][] dArray, double d) {
        return d - ContingencyTables.entropyConditionedOnRows(dArray);
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new RandomTree(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

