/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SpecialFunctions;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class NaiveBayesMultinomial
extends Classifier
implements WeightedInstancesHandler {
    private double[][] probOfWordGivenClass;
    private double[] probOfClass;
    private int numAttributes;
    private int numClasses;
    private double[] lnFactorialCache = new double[]{0.0, 0.0};
    Instances headerInfo;

    public String globalInfo() {
        return "Class for building and using a multinomial Naive Bayes classifier. For more information see,\n\nAndrew Mccallum, Kamal Nigam (1998) A Comparison of Event Models for Naive Bayes Text Classification";
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        this.headerInfo = new Instances(instances, 0);
        this.numClasses = instances.numClasses();
        this.numAttributes = instances.numAttributes();
        this.probOfWordGivenClass = new double[this.numClasses][];
        for (int i = 0; i < this.numClasses; ++i) {
            this.probOfWordGivenClass[i] = new double[this.numAttributes];
            for (n2 = 0; n2 < this.numAttributes; ++n2) {
                if (instances.classIndex() == n2) {
                    if (!instances.attribute(n2).isNominal()) {
                        throw new Exception("The class attribute is required to be nominal. This is currently not the case!");
                    }
                } else if (!instances.attribute(n2).isNumeric()) {
                    throw new Exception("Attribute " + instances.attribute(n2).name() + " is not numeric! NaiveBayesMultinomial1 requires that all attributes (except the class attribute) are numeric.");
                }
                this.probOfWordGivenClass[i][n2] = 1.0;
            }
        }
        double[] dArray = new double[this.numClasses];
        double[] dArray2 = new double[this.numClasses];
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int n3 = n2 = (int)instance.value(instance.classIndex());
            dArray[n3] = dArray[n3] + instance.weight();
            for (n = 0; n < instance.numValues(); ++n) {
                if (instance.index(n) == instance.classIndex()) continue;
                if (!instance.isMissing(n)) {
                    double d = instance.valueSparse(n) * instance.weight();
                    if (d < 0.0) {
                        throw new Exception("Numeric attribute values must all be greater or equal to zero.");
                    }
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + d;
                    double[] dArray3 = this.probOfWordGivenClass[n2];
                    int n5 = instance.index(n);
                    dArray3[n5] = dArray3[n5] + d;
                    continue;
                }
                throw new Exception("Cannot handle missing values!");
            }
        }
        for (n = 0; n < this.numClasses; ++n) {
            for (int i = 0; i < this.numAttributes; ++i) {
                this.probOfWordGivenClass[n][i] = Math.log(this.probOfWordGivenClass[n][i] / (dArray2[n] + (double)this.numAttributes - 1.0));
            }
        }
        double d = instances.sumOfWeights() + (double)this.numClasses;
        this.probOfClass = new double[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.probOfClass[i] = (dArray[i] + 1.0) / d;
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[this.numClasses];
        double[] dArray2 = new double[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            dArray2[i] = this.probOfDocGivenClass(instance, i);
        }
        double d = dArray2[Utils.maxIndex(dArray2)];
        double d2 = 0.0;
        for (int i = 0; i < this.numClasses; ++i) {
            dArray[i] = Math.exp(dArray2[i] - d) * this.probOfClass[i];
            d2 += dArray[i];
        }
        Utils.normalize(dArray, d2);
        return dArray;
    }

    private double probOfDocGivenClass(Instance instance, int n) {
        double d = 0.0;
        for (int i = 0; i < instance.numValues(); ++i) {
            if (instance.index(i) == instance.classIndex()) continue;
            double d2 = instance.valueSparse(i);
            d += d2 * this.probOfWordGivenClass[n][instance.index(i)];
        }
        return d;
    }

    public double lnFactorial(int n) {
        if (n < 0) {
            return SpecialFunctions.lnFactorial(n);
        }
        if (this.lnFactorialCache.length <= n) {
            double[] dArray = new double[n + 1];
            System.arraycopy(this.lnFactorialCache, 0, dArray, 0, this.lnFactorialCache.length);
            for (int i = this.lnFactorialCache.length; i < dArray.length; ++i) {
                dArray[i] = dArray[i - 1] + Math.log(i);
            }
            this.lnFactorialCache = dArray;
        }
        return this.lnFactorialCache[n];
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("The independent probability of a class\n--------------------------------------\n");
        for (n = 0; n < this.numClasses; ++n) {
            stringBuffer.append(this.headerInfo.classAttribute().value(n)).append("\t").append(Double.toString(this.probOfClass[n])).append("\n");
        }
        stringBuffer.append("\nThe probability of a word given the class\n-----------------------------------------\n\t");
        for (n = 0; n < this.numClasses; ++n) {
            stringBuffer.append(this.headerInfo.classAttribute().value(n)).append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < this.numAttributes; ++n) {
            stringBuffer.append(this.headerInfo.attribute(n).name()).append("\t");
            for (int i = 0; i < this.numClasses; ++i) {
                stringBuffer.append(Double.toString(Math.exp(this.probOfWordGivenClass[i][n]))).append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new NaiveBayesMultinomial(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

