/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.associations.Associator;
import weka.associations.tertius.AttributeValueLiteral;
import weka.associations.tertius.IndividualInstances;
import weka.associations.tertius.IndividualLiteral;
import weka.associations.tertius.Predicate;
import weka.associations.tertius.Rule;
import weka.associations.tertius.SimpleLinkedList;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class Tertius
extends Associator
implements OptionHandler,
Runnable {
    private SimpleLinkedList m_results;
    private int m_hypotheses;
    private int m_explored;
    private Date m_time;
    private TextField m_valuesText;
    private Instances m_instances;
    private ArrayList m_predicates;
    private int m_status;
    private static final int NORMAL = 0;
    private static final int MEMORY = 1;
    private static final int STOP = 2;
    private int m_best;
    private double m_frequencyThreshold;
    private double m_confirmationThreshold;
    private double m_noiseThreshold;
    private boolean m_repeat;
    private int m_numLiterals;
    private static final int NONE = 0;
    private static final int BODY = 1;
    private static final int HEAD = 2;
    private static final int ALL = 3;
    private static final Tag[] TAGS_NEGATION = new Tag[]{new Tag(0, "None"), new Tag(1, "Body"), new Tag(2, "Head"), new Tag(3, "Both")};
    private int m_negation;
    private boolean m_classification;
    private int m_classIndex;
    private boolean m_horn;
    private boolean m_equivalent;
    private boolean m_sameClause;
    private boolean m_subsumption;
    public static final int EXPLICIT = 0;
    public static final int IMPLICIT = 1;
    public static final int SIGNIFICANT = 2;
    private static final Tag[] TAGS_MISSING = new Tag[]{new Tag(0, "Matches all"), new Tag(1, "Matches none"), new Tag(2, "Significant")};
    private int m_missing;
    private boolean m_roc;
    private String m_partsString;
    private Instances m_parts;
    private static final int NO = 0;
    private static final int OUT = 1;
    private static final int WINDOW = 2;
    private static final Tag[] TAGS_VALUES = new Tag[]{new Tag(0, "No"), new Tag(1, "stdout"), new Tag(2, "Window")};
    private int m_printValues;

    public Tertius() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Finds rules according to confirmation measure.";
    }

    public void resetOptions() {
        this.m_best = 10;
        this.m_frequencyThreshold = 0.0;
        this.m_confirmationThreshold = 0.0;
        this.m_noiseThreshold = 1.0;
        this.m_repeat = false;
        this.m_numLiterals = 4;
        this.m_negation = 0;
        this.m_classification = false;
        this.m_classIndex = 0;
        this.m_horn = false;
        this.m_equivalent = true;
        this.m_sameClause = true;
        this.m_subsumption = true;
        this.m_missing = 0;
        this.m_roc = false;
        this.m_partsString = "";
        this.m_parts = null;
        this.m_printValues = 0;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(17);
        vector.addElement(new Option("\tSet maximum number of confirmation  values in the result. (default: 10)", "K", 1, "-K <number of values in result>"));
        vector.addElement(new Option("\tSet frequency threshold for pruning. (default: 0)", "F", 1, "-F <frequency threshold>"));
        vector.addElement(new Option("\tSet confirmation threshold. (default: 0)", "C", 1, "-C <confirmation threshold>"));
        vector.addElement(new Option("\tSet noise threshold : maximum frequency of counter-examples.\n\t0 gives only satisfied rules. (default: 1)", "N", 1, "-N <noise threshold>"));
        vector.addElement(new Option("\tAllow attributes to be repeated in a same rule.", "R", 0, "-R"));
        vector.addElement(new Option("\tSet maximum number of literals in a rule. (default: 4)", "L", 1, "-L <number of literals>"));
        vector.addElement(new Option("\tSet the negations in the rule. (default: 0)", "G", 1, "-G <0=no negation | 1=body | 2=head | 3=body and head>"));
        vector.addElement(new Option("\tConsider only classification rules.", "S", 0, "-S"));
        vector.addElement(new Option("\tSet index of class attribute. (default: last).", "c", 1, "-c <class index>"));
        vector.addElement(new Option("\tConsider only horn clauses.", "H", 0, "-H"));
        vector.addElement(new Option("\tKeep equivalent rules.", "E", 0, "-E"));
        vector.addElement(new Option("\tKeep same clauses.", "M", 0, "-M"));
        vector.addElement(new Option("\tKeep subsumed rules.", "T", 0, "-T"));
        vector.addElement(new Option("\tSet the way to handle missing values. (default: 0)", "I", 1, "-I <0=always match | 1=never match | 2=significant>"));
        vector.addElement(new Option("\tUse ROC analysis. ", "O", 0, "-O"));
        vector.addElement(new Option("\tSet the file containing the parts of the individual for individual-based learning.", "p", 1, "-p <name of file>"));
        vector.addElement(new Option("\tSet output of current values. (default: 0)", "P", 1, "-P <0=no output | 1=on stdout | 2=in separate window>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3;
        String string4;
        this.resetOptions();
        String string5 = Utils.getOption('K', stringArray);
        if (string5.length() != 0) {
            try {
                this.m_best = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -K option: " + exception.getMessage() + ".");
            }
            if (this.m_best < 1) {
                throw new Exception("Number of confirmation values has to be greater than one!");
            }
        }
        if ((string4 = Utils.getOption('F', stringArray)).length() != 0) {
            try {
                this.m_frequencyThreshold = new Double(string4);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -F option: " + exception.getMessage() + ".");
            }
            if (this.m_frequencyThreshold < 0.0 || this.m_frequencyThreshold > 1.0) {
                throw new Exception("Frequency threshold has to be between zero and one!");
            }
        }
        if ((string3 = Utils.getOption('C', stringArray)).length() != 0) {
            try {
                this.m_confirmationThreshold = new Double(string3);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -C option: " + exception.getMessage() + ".");
            }
            if (this.m_confirmationThreshold < 0.0 || this.m_confirmationThreshold > 1.0) {
                throw new Exception("Confirmation threshold has to be between zero and one!");
            }
            if (string5.length() != 0) {
                throw new Exception("Specifying both a number of confirmation values and a confirmation threshold doesn't make sense!");
            }
            if (this.m_confirmationThreshold != 0.0) {
                this.m_best = 0;
            }
        }
        if ((string2 = Utils.getOption('N', stringArray)).length() != 0) {
            try {
                this.m_noiseThreshold = new Double(string2);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -N option: " + exception.getMessage() + ".");
            }
            if (this.m_noiseThreshold < 0.0 || this.m_noiseThreshold > 1.0) {
                throw new Exception("Noise threshold has to be between zero and one!");
            }
        }
        this.m_repeat = Utils.getFlag('R', stringArray);
        String string6 = Utils.getOption('L', stringArray);
        if (string6.length() != 0) {
            try {
                this.m_numLiterals = Integer.parseInt(string6);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -L option: " + exception.getMessage() + ".");
            }
            if (this.m_numLiterals < 1) {
                throw new Exception("Number of literals has to be greater than one!");
            }
        }
        if ((string = Utils.getOption('G', stringArray)).length() != 0) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -G option: " + exception.getMessage() + ".");
            }
            try {
                object2 = new SelectedTag(n, TAGS_NEGATION);
            }
            catch (Exception exception) {
                throw new Exception("Value for -G option has to be between zero and three!");
            }
            this.setNegation((SelectedTag)object2);
        }
        this.m_classification = Utils.getFlag('S', stringArray);
        object2 = Utils.getOption('c', stringArray);
        if (((String)object2).length() != 0) {
            try {
                this.m_classIndex = Integer.parseInt((String)object2);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -c option: " + exception.getMessage() + ".");
            }
        }
        this.m_horn = Utils.getFlag('H', stringArray);
        if (this.m_horn && this.m_negation != 0) {
            throw new Exception("Considering horn clauses doesn't make sense if negation allowed!");
        }
        this.m_equivalent = !Utils.getFlag('E', stringArray);
        this.m_sameClause = !Utils.getFlag('M', stringArray);
        this.m_subsumption = !Utils.getFlag('T', stringArray);
        String string7 = Utils.getOption('I', stringArray);
        if (string7.length() != 0) {
            int n;
            try {
                n = Integer.parseInt(string7);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -I option: " + exception.getMessage() + ".");
            }
            try {
                object = new SelectedTag(n, TAGS_MISSING);
            }
            catch (Exception exception) {
                throw new Exception("Value for -I option has to be between zero and two!");
            }
            this.setMissingValues((SelectedTag)object);
        }
        this.m_roc = Utils.getFlag('O', stringArray);
        this.m_partsString = Utils.getOption('p', stringArray);
        if (this.m_partsString.length() != 0) {
            try {
                object = new BufferedReader(new FileReader(this.m_partsString));
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + ".");
            }
            this.m_parts = new Instances((Reader)object);
        }
        if (((String)(object = Utils.getOption('P', stringArray))).length() != 0) {
            SelectedTag selectedTag;
            int n;
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                throw new Exception("Invalid value for -P option: " + exception.getMessage() + ".");
            }
            try {
                selectedTag = new SelectedTag(n, TAGS_VALUES);
            }
            catch (Exception exception) {
                throw new Exception("Value for -P option has to be between zero and two!");
            }
            this.setValuesOutput(selectedTag);
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[24];
        int n = 0;
        stringArray[n++] = "-K";
        stringArray[n++] = "" + this.m_best;
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.m_frequencyThreshold;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_confirmationThreshold;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_noiseThreshold;
        if (this.m_repeat) {
            stringArray[n++] = "-R";
        }
        stringArray[n++] = "-L";
        stringArray[n++] = "" + this.m_numLiterals;
        stringArray[n++] = "-G";
        stringArray[n++] = "" + this.m_negation;
        if (this.m_classification) {
            stringArray[n++] = "-S";
        }
        stringArray[n++] = "-c";
        stringArray[n++] = "" + this.m_classIndex;
        if (this.m_horn) {
            stringArray[n++] = "-H";
        }
        if (!this.m_equivalent) {
            stringArray[n++] = "-E";
        }
        if (!this.m_sameClause) {
            stringArray[n++] = "-M";
        }
        if (!this.m_subsumption) {
            stringArray[n++] = "-T";
        }
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.m_missing;
        if (this.m_roc) {
            stringArray[n++] = "-O";
        }
        stringArray[n++] = "-p";
        stringArray[n++] = "" + this.m_partsString;
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.m_printValues;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String confirmationValuesTipText() {
        return "Number of best confirmation values to find.";
    }

    public int getConfirmationValues() {
        return this.m_best;
    }

    public void setConfirmationValues(int n) throws Exception {
        this.m_best = n;
    }

    public String frequencyThresholdTipText() {
        return "Minimum proportion of instances satisfying head and body of rules";
    }

    public double getFrequencyThreshold() {
        return this.m_frequencyThreshold;
    }

    public void setFrequencyThreshold(double d) {
        this.m_frequencyThreshold = d;
    }

    public String confirmationThresholdTipText() {
        return "Minimum confirmation of the rules.";
    }

    public double getConfirmationThreshold() {
        return this.m_confirmationThreshold;
    }

    public void setConfirmationThreshold(double d) {
        this.m_confirmationThreshold = d;
        if (d != 0.0) {
            this.m_best = 0;
        }
    }

    public String noiseThresholdTipText() {
        return "Maximum proportion of counter-instances of rules. If set to 0, only satisfied rules will be given.";
    }

    public double getNoiseThreshold() {
        return this.m_noiseThreshold;
    }

    public void setNoiseThreshold(double d) {
        this.m_noiseThreshold = d;
    }

    public String repeatLiteralsTipText() {
        return "Repeated attributes allowed.";
    }

    public boolean getRepeatLiterals() {
        return this.m_repeat;
    }

    public void setRepeatLiterals(boolean bl) {
        this.m_repeat = bl;
    }

    public String numberLiteralsTipText() {
        return "Maximum number of literals in a rule.";
    }

    public int getNumberLiterals() {
        return this.m_numLiterals;
    }

    public void setNumberLiterals(int n) {
        this.m_numLiterals = n;
    }

    public String negationTipText() {
        return "Set the type of negation allowed in the rule. Negation can be allowed in the body, in the head, in both or in none.";
    }

    public SelectedTag getNegation() {
        return new SelectedTag(this.m_negation, TAGS_NEGATION);
    }

    public void setNegation(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_NEGATION) {
            this.m_negation = selectedTag.getSelectedTag().getID();
        }
    }

    public String classificationTipText() {
        return "Find only rules with the class in the head.";
    }

    public boolean getClassification() {
        return this.m_classification;
    }

    public void setClassification(boolean bl) {
        this.m_classification = bl;
    }

    public String classIndexTipText() {
        return "Index of the class attribute. If set to 0, the class will be the last attribute.";
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    public void setClassIndex(int n) {
        this.m_classIndex = n;
    }

    public String hornClausesTipText() {
        return "Find rules with a single conclusion literal only.";
    }

    public boolean getHornClauses() {
        return this.m_horn;
    }

    public void setHornClauses(boolean bl) {
        this.m_horn = bl;
    }

    public String equivalentTipText() {
        return "Keep equivalent rules. A rule r2 is equivalent to a rule r1 if the body of r2 is the negation of the head of r1, and the head of r2 is the negation of the body of r1.";
    }

    public boolean disabled_getEquivalent() {
        return !this.m_equivalent;
    }

    public void disabled_setEquivalent(boolean bl) {
        this.m_equivalent = !bl;
    }

    public String sameClauseTipText() {
        return "Keep rules corresponding to the same clauses. If set to false, only the rule with the best confirmation value and rules with a lower number of counter-instances will be kept.";
    }

    public boolean disabled_getSameClause() {
        return !this.m_sameClause;
    }

    public void disabled_setSameClause(boolean bl) {
        this.m_sameClause = !bl;
    }

    public String subsumptionTipText() {
        return "Keep subsumed rules. If set to false, subsumed rules will only be kept if they have a better confirmation or a lower number of counter-instances.";
    }

    public boolean disabled_getSubsumption() {
        return !this.m_subsumption;
    }

    public void disabled_setSubsumption(boolean bl) {
        this.m_subsumption = !bl;
    }

    public String missingValuesTipText() {
        return "Set the way to handle missing values. Missing values can be set to match any value, or never match values or to be significant and possibly appear in rules.";
    }

    public SelectedTag getMissingValues() {
        return new SelectedTag(this.m_missing, TAGS_MISSING);
    }

    public void setMissingValues(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_MISSING) {
            this.m_missing = selectedTag.getSelectedTag().getID();
        }
    }

    public String rocAnalysisTipText() {
        return "Return TP-rate and FP-rate for each rule found.";
    }

    public boolean getRocAnalysis() {
        return this.m_roc;
    }

    public void setRocAnalysis(boolean bl) {
        this.m_roc = bl;
    }

    public String partFileTipText() {
        return "Set file containing the parts of the individual for individual-based learning.";
    }

    public File disabled_getPartFile() {
        return new File(this.m_partsString);
    }

    public void disabled_setPartFile(File file) throws Exception {
        this.m_partsString = file.getAbsolutePath();
        if (this.m_partsString.length() != 0) {
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new FileReader(this.m_partsString));
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + ".");
            }
            this.m_parts = new Instances(bufferedReader);
        }
    }

    public String valuesOutputTipText() {
        return "Give visual feedback during the search. The current best and worst values can be output either to stdout or to a separate window.";
    }

    public SelectedTag getValuesOutput() {
        return new SelectedTag(this.m_printValues, TAGS_VALUES);
    }

    public void setValuesOutput(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_VALUES) {
            this.m_printValues = selectedTag.getSelectedTag().getID();
        }
    }

    private Predicate buildPredicate(Instances instances, Attribute attribute, boolean bl) throws Exception {
        int n;
        boolean bl2 = this.m_parts != null;
        int n2 = n = instances == this.m_parts ? IndividualLiteral.PART_PROPERTY : IndividualLiteral.INDIVIDUAL_PROPERTY;
        if (attribute.isNumeric()) {
            throw new Exception("Can't handle numeric attributes!");
        }
        boolean bl3 = instances.attributeStats((int)attribute.index()).missingCount > 0;
        Predicate predicate = bl2 ? new Predicate(instances.relationName() + "." + attribute.name(), attribute.index(), bl) : new Predicate(attribute.name(), attribute.index(), bl);
        if (!(attribute.numValues() != 2 || bl3 && this.m_missing != 0)) {
            AttributeValueLiteral attributeValueLiteral;
            AttributeValueLiteral attributeValueLiteral2;
            if (bl2) {
                attributeValueLiteral2 = new IndividualLiteral(predicate, attribute.value(0), 0, 1, this.m_missing, n);
                attributeValueLiteral = new IndividualLiteral(predicate, attribute.value(1), 1, 1, this.m_missing, n);
            } else {
                attributeValueLiteral2 = new AttributeValueLiteral(predicate, attribute.value(0), 0, 1, this.m_missing);
                attributeValueLiteral = new AttributeValueLiteral(predicate, attribute.value(1), 1, 1, this.m_missing);
            }
            attributeValueLiteral2.setNegation(attributeValueLiteral);
            attributeValueLiteral.setNegation(attributeValueLiteral2);
            predicate.addLiteral(attributeValueLiteral2);
        } else {
            AttributeValueLiteral attributeValueLiteral;
            AttributeValueLiteral attributeValueLiteral3;
            for (int i = 0; i < attribute.numValues(); ++i) {
                attributeValueLiteral3 = bl2 ? new IndividualLiteral(predicate, attribute.value(i), i, 1, this.m_missing, n) : new AttributeValueLiteral(predicate, attribute.value(i), i, 1, this.m_missing);
                if (this.m_negation != 0) {
                    attributeValueLiteral = bl2 ? new IndividualLiteral(predicate, attribute.value(i), i, 0, this.m_missing, n) : new AttributeValueLiteral(predicate, attribute.value(i), i, 0, this.m_missing);
                    attributeValueLiteral3.setNegation(attributeValueLiteral);
                    attributeValueLiteral.setNegation(attributeValueLiteral3);
                }
                predicate.addLiteral(attributeValueLiteral3);
            }
            if (bl3 && this.m_missing == 2) {
                attributeValueLiteral3 = bl2 ? new IndividualLiteral(predicate, "?", -1, 1, this.m_missing, n) : new AttributeValueLiteral(predicate, "?", -1, 1, this.m_missing);
                if (this.m_negation != 0) {
                    attributeValueLiteral = bl2 ? new IndividualLiteral(predicate, "?", -1, 0, this.m_missing, n) : new AttributeValueLiteral(predicate, "?", -1, 0, this.m_missing);
                    attributeValueLiteral3.setNegation(attributeValueLiteral);
                    attributeValueLiteral.setNegation(attributeValueLiteral3);
                }
                predicate.addLiteral(attributeValueLiteral3);
            }
        }
        return predicate;
    }

    private ArrayList buildPredicates() throws Exception {
        Predicate predicate;
        Attribute attribute;
        boolean bl;
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
        Enumeration enumeration = this.m_instances.enumerateAttributes();
        boolean bl2 = bl = this.m_parts != null;
        while (enumeration.hasMoreElements()) {
            attribute = (Attribute)enumeration.nextElement();
            if (bl && attribute.name().equals("id")) continue;
            predicate = this.buildPredicate(this.m_instances, attribute, false);
            arrayList.add(predicate);
        }
        attribute = this.m_instances.classAttribute();
        if (!bl || !attribute.name().equals("id")) {
            predicate = this.buildPredicate(this.m_instances, attribute, true);
            arrayList.add(predicate);
        }
        if (bl) {
            enumeration = this.m_parts.enumerateAttributes();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                if (attribute.name().equals("id")) continue;
                predicate = this.buildPredicate(this.m_parts, attribute, false);
                arrayList.add(predicate);
            }
        }
        return arrayList;
    }

    private int numValuesInResult() {
        int n = 0;
        SimpleLinkedList.LinkedListIterator linkedListIterator = this.m_results.iterator();
        if (!linkedListIterator.hasNext()) {
            return n;
        }
        Rule rule = (Rule)linkedListIterator.next();
        while (linkedListIterator.hasNext()) {
            Rule rule2 = (Rule)linkedListIterator.next();
            if (rule.getConfirmation() > rule2.getConfirmation()) {
                ++n;
            }
            rule = rule2;
        }
        return n + 1;
    }

    private boolean canRefine(Rule rule) {
        if (rule.isEmpty()) {
            return true;
        }
        if (this.m_best != 0) {
            if (this.numValuesInResult() < this.m_best) {
                return true;
            }
            Rule rule2 = (Rule)this.m_results.getLast();
            return rule.getOptimistic() >= rule2.getConfirmation();
        }
        return true;
    }

    private boolean canCalculateOptimistic(Rule rule) {
        if (rule.hasTrueBody() || rule.hasFalseHead()) {
            return false;
        }
        return rule.overFrequencyThreshold(this.m_frequencyThreshold);
    }

    private boolean canExplore(Rule rule) {
        if (rule.getOptimistic() < this.m_confirmationThreshold) {
            return false;
        }
        if (this.m_best != 0) {
            if (this.numValuesInResult() < this.m_best) {
                return true;
            }
            Rule rule2 = (Rule)this.m_results.getLast();
            return rule.getOptimistic() >= rule2.getConfirmation();
        }
        return true;
    }

    private boolean canStoreInNodes(Rule rule) {
        return rule.getObservedNumber() != 0;
    }

    private boolean canCalculateConfirmation(Rule rule) {
        return !(rule.getObservedFrequency() > this.m_noiseThreshold);
    }

    private boolean canStoreInResults(Rule rule) {
        if (rule.getConfirmation() < this.m_confirmationThreshold) {
            return false;
        }
        if (this.m_best != 0) {
            if (this.numValuesInResult() < this.m_best) {
                return true;
            }
            Rule rule2 = (Rule)this.m_results.getLast();
            return rule.getConfirmation() >= rule2.getConfirmation();
        }
        return true;
    }

    private void addResult(Rule rule) {
        Rule rule2;
        boolean bl = false;
        SimpleLinkedList.LinkedListIterator linkedListIterator = this.m_results.iterator();
        while (linkedListIterator.hasNext()) {
            rule2 = (Rule)linkedListIterator.next();
            if (Rule.confirmationThenObservedComparator.compare(rule2, rule) > 0) {
                linkedListIterator.addBefore(rule);
                bl = true;
                break;
            }
            if (!this.m_subsumption && !this.m_sameClause && !this.m_equivalent || !rule2.subsumes(rule) || !(rule2.numLiterals() == rule.numLiterals() ? (rule2.equivalentTo(rule) ? this.m_equivalent : this.m_sameClause && Rule.confirmationComparator.compare(rule2, rule) < 0) : this.m_subsumption && Rule.observedComparator.compare(rule2, rule) <= 0)) continue;
            return;
        }
        if (!bl) {
            this.m_results.add(rule);
        }
        SimpleLinkedList.LinkedListInverseIterator linkedListInverseIterator = this.m_results.inverseIterator();
        while (linkedListInverseIterator.hasPrevious() && Rule.confirmationThenObservedComparator.compare(rule2 = (Rule)linkedListInverseIterator.previous(), rule) >= 0) {
            if (rule2 == rule || !rule.subsumes(rule2)) continue;
            if (rule2.numLiterals() == rule.numLiterals()) {
                if (rule2.equivalentTo(rule) || !this.m_sameClause || Rule.confirmationComparator.compare(rule2, rule) <= 0) continue;
                linkedListInverseIterator.remove();
                continue;
            }
            if (!this.m_subsumption || Rule.observedComparator.compare(rule, rule2) > 0) continue;
            linkedListInverseIterator.remove();
        }
        if (this.m_best != 0 && this.numValuesInResult() > this.m_best) {
            Rule rule3 = (Rule)this.m_results.getLast();
            linkedListInverseIterator = this.m_results.inverseIterator();
            while (linkedListInverseIterator.hasPrevious() && Rule.confirmationComparator.compare(rule2 = (Rule)linkedListInverseIterator.previous(), rule3) >= 0) {
                linkedListInverseIterator.remove();
            }
        }
        this.printValues();
    }

    public void buildAssociations(Instances instances) throws Exception {
        Serializable serializable;
        Serializable serializable2;
        Window window = null;
        this.m_instances = this.m_parts == null ? new Instances(instances) : new IndividualInstances(new Instances(instances), this.m_parts);
        this.m_results = new SimpleLinkedList();
        this.m_hypotheses = 0;
        this.m_explored = 0;
        this.m_status = 0;
        if (this.m_classIndex == 0) {
            this.m_instances.setClassIndex(instances.numAttributes() - 1);
        } else {
            if (this.m_classIndex > instances.numAttributes() || this.m_classIndex < 0) {
                throw new Exception("Class index has to be between zero and the number of attributes!");
            }
            this.m_instances.setClassIndex(this.m_classIndex - 1);
        }
        if (this.m_printValues == 2) {
            this.m_valuesText = new TextField(37);
            this.m_valuesText.setEditable(false);
            this.m_valuesText.setFont(new Font("Monospaced", 0, 12));
            serializable2 = new Label("Best and worst current values:");
            serializable = new Button("Stop search");
            ((Button)serializable).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Tertius.this.m_status = 2;
                }
            });
            window = new Frame("Tertius status");
            ((Frame)window).setResizable(false);
            window.add((Component)this.m_valuesText, "Center");
            window.add((Component)serializable, "South");
            window.add((Component)serializable2, "North");
            window.pack();
            window.setVisible(true);
        } else if (this.m_printValues == 1) {
            System.out.println("Best and worst current values:");
        }
        serializable2 = new Date();
        this.m_predicates = this.buildPredicates();
        this.beginSearch();
        serializable = new Date();
        if (this.m_printValues == 2) {
            window.dispose();
        }
        this.m_time = new Date(((Date)serializable).getTime() - ((Date)serializable2).getTime());
    }

    public void run() {
        try {
            this.search();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            this.m_status = 1;
        }
        this.endSearch();
    }

    private synchronized void beginSearch() throws Exception {
        Thread thread = new Thread(this);
        thread.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            this.m_status = 2;
        }
    }

    private synchronized void endSearch() {
        this.notify();
    }

    public void search() {
        Rule rule;
        SimpleLinkedList simpleLinkedList = new SimpleLinkedList();
        boolean bl = this.m_negation == 1 || this.m_negation == 3;
        boolean bl2 = this.m_negation == 2 || this.m_negation == 3;
        simpleLinkedList.add(new Rule(this.m_repeat, this.m_numLiterals, bl, bl2, this.m_classification, this.m_horn));
        this.printValues();
        while (this.m_status != 2 && !simpleLinkedList.isEmpty() && this.canRefine(rule = (Rule)simpleLinkedList.removeFirst())) {
            SimpleLinkedList simpleLinkedList2 = rule.refine(this.m_predicates);
            SimpleLinkedList.LinkedListIterator linkedListIterator = simpleLinkedList2.iterator();
            while (linkedListIterator.hasNext()) {
                ++this.m_hypotheses;
                Rule rule2 = (Rule)linkedListIterator.next();
                rule2.upDate(this.m_instances);
                if (this.canCalculateOptimistic(rule2)) {
                    rule2.calculateOptimistic();
                    if (this.canExplore(rule2)) {
                        ++this.m_explored;
                        if (!this.canStoreInNodes(rule2)) {
                            linkedListIterator.remove();
                        }
                        if (!this.canCalculateConfirmation(rule2)) continue;
                        rule2.calculateConfirmation();
                        if (!this.canStoreInResults(rule2)) continue;
                        this.addResult(rule2);
                        continue;
                    }
                    linkedListIterator.remove();
                    continue;
                }
                linkedListIterator.remove();
            }
            simpleLinkedList2.sort(Rule.optimisticThenObservedComparator);
            simpleLinkedList.merge(simpleLinkedList2, Rule.optimisticThenObservedComparator);
        }
    }

    private void printValues() {
        if (this.m_printValues == 0) {
            return;
        }
        if (this.m_results.isEmpty()) {
            if (this.m_printValues == 1) {
                System.out.print("0.000000 0.000000 - 0.000000 0.000000");
            } else {
                this.m_valuesText.setText("0.000000 0.000000 - 0.000000 0.000000");
            }
        } else {
            Rule rule = (Rule)this.m_results.getFirst();
            Rule rule2 = (Rule)this.m_results.getLast();
            String string = rule.valuesToString() + " - " + rule2.valuesToString();
            if (this.m_printValues == 1) {
                System.out.print("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
                System.out.print(string);
            } else {
                this.m_valuesText.setText(string);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm 'min' ss 's' SSS 'ms'");
        SimpleLinkedList.LinkedListIterator linkedListIterator = this.m_results.iterator();
        int n = this.m_results.size();
        int n2 = 0;
        stringBuffer.append("\nTertius\n=======\n\n");
        while (linkedListIterator.hasNext()) {
            Rule rule = (Rule)linkedListIterator.next();
            stringBuffer.append(Utils.doubleToString((double)n2 + 1.0, (int)(Math.log(n) / Math.log(10.0) + 1.0), 0) + ". ");
            stringBuffer.append("/* ");
            if (this.m_roc) {
                stringBuffer.append(rule.rocToString());
            } else {
                stringBuffer.append(rule.valuesToString());
            }
            stringBuffer.append(" */ ");
            stringBuffer.append(rule.toString());
            stringBuffer.append("\n");
            ++n2;
        }
        stringBuffer.append("\nNumber of hypotheses considered: " + this.m_hypotheses);
        stringBuffer.append("\nNumber of hypotheses explored: " + this.m_explored);
        stringBuffer.append("\nTime: " + simpleDateFormat.format(this.m_time));
        if (this.m_status == 1) {
            stringBuffer.append("\n\nNot enough memory to continue the search");
        } else if (this.m_status == 2) {
            stringBuffer.append("\n\nSearch interrupted");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Tertius tertius = new Tertius();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader;
            stringBuffer.append("\n\nTertius options:\n\n");
            stringBuffer.append("-t <name of training file>\n");
            stringBuffer.append("\tSet training file.\n");
            Enumeration enumeration = tertius.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + "\n");
                stringBuffer.append(option.description() + "\n");
            }
            String string = Utils.getOption('t', stringArray);
            if (string.length() == 0) {
                throw new Exception("No training file given!");
            }
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + ".");
            }
            Instances instances = new Instances(bufferedReader);
            tertius.setOptions(stringArray);
            Utils.checkForRemainingOptions(stringArray);
            tertius.buildAssociations(instances);
            System.out.println(tertius);
        }
        catch (Exception exception) {
            System.err.println("\nWeka exception: " + exception.getMessage() + stringBuffer);
        }
    }
}

