#!/bin/sh

set -e  # Exit immediately if a simple command exits with a non-zero status

# We keep strict SNPs only (tagged "snp") i.e. we drop lines tagged as
#   "in-del", "mixed", "microsatellite", "named-locus" or "multinucleotide-polymorphism"
grep '| snp |' | \
  grep '| notwithdrawn |' | \
  grep -v '| CTG | assembly=Celera |.*| CTG | assembly=Celera |' | \
  grep -v '| CTG | assembly=reference |.*| CTG | assembly=reference |' | \
  grep "| CTG | assembly=Celera | chr=$1 |" | \
  grep "| CTG | assembly=reference | chr=$1 |" | \
  sed -r 's/\| notwithdrawn (\||\|.*\|) CTG \| assembly=reference \|/|/'

