### Name: Mmusculus
### Title: Mus musculus full genome (UCSC version mm8)
### Aliases: BSgenome.Mmusculus.UCSC.mm8-package
###   BSgenome.Mmusculus.UCSC.mm8 Mmusculus
### Keywords: package data

### ** Examples

Mmusculus
seqlengths(Mmusculus)
Mmusculus$chr1  # same as Mmusculus[["chr1"]]

if ("AGAPS" %in% masknames(Mmusculus)) {

  ## Check that the assembly gaps contain only Ns:
  checkOnlyNsInGaps <- function(seq)
  {
    ## Replace all masks by the inverted AGAPS mask
    masks(seq) <- gaps(masks(seq)["AGAPS"])
    af <- alphabetFrequency(seq)
    found_letters <- names(af)[af != 0]
    if (any(found_letters != "N"))
        stop("assembly gaps contain more than just Ns")
  }

  ## A message will be printed each time a sequence is removed
  ## from the cache:
  options(verbose=TRUE)

  for (seqname in seqnames(Mmusculus)) {
    cat("Checking sequence", seqname, "... ")
    seq <- Mmusculus[[seqname]]
    checkOnlyNsInGaps(seq)
    cat("OK\n")
  }
}

## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")



