### Name: import.expr.scheme
### Title: Import CDF, probe and annotation files into a SchemeTreeSet
### Aliases: import.expr.scheme
### Keywords: manip

### ** Examples

## Not run: 
##D ## define paths
##D scmdir <- "/common/path/schemes"
##D libdir <- "/my/path/Affy/libraryfiles"
##D anndir <- "/my/path/Affy/Annotation"
##D 
##D ## create scheme for Test3 GeneChip
##D scheme.test3.na27 <- import.expr.scheme("Scheme_Test3_na27",filedir=scmdir,
##D                      schemefile=paste(libdir,"Test3.CDF",sep="/"),
##D                      probefile=paste(libdir,"Test3_probe.tab",sep="/"),
##D                      annotfile=paste(anndir,"Test3.na27.annot.csv",sep="/"))
##D 
##D ## access ROOT scheme file from new R session
##D scheme.test3 <- root.scheme(paste(scmdir,"Scheme_Test3_na27.root",sep="/"))
##D 
##D ## create scheme for HG-U133_Plus_2 GeneChip
##D scheme.hgu133p2.na27 <- import.expr.scheme("Scheme_HGU133p2_na27",filedir=scmdir,
##D                         schemefile=paste(libdir,"HG-U133_Plus_2.cdf",sep="/"),
##D                         probefile=paste(libdir,"HG-U133-PLUS_probe.tab",sep="/"),
##D                         annotfile=paste(anndir,"HG-U133_Plus_2.na27.annot.csv",sep="/"))
##D ## access ROOT scheme file from new R session
##D scheme.hgu133p2 <- root.scheme(paste(scmdir,"Scheme_HGU133p2_na27.root",sep="/"))
## End(Not run)



