### Name: chisq.ebam
### Title: EBAM Analysis for Categorical Data
### Aliases: chisq.ebam cat.ebam
### Keywords: htest

### ** Examples
## Not run: 
##D   # Generate a random 1000 x 40 matrix consisting of the values
##D   # 1, 2, and 3, and representing 1000 variables and 40 observations.
##D   
##D   mat <- matrix(sample(3, 40000, TRUE), 1000)
##D   
##D   # Assume that the first 20 observations are cases, and the
##D   # remaining 20 are controls.
##D   
##D   cl <- rep(1:2, e=20)
##D   
##D   # Then an EBAM analysis for categorical data can be done by
##D   
##D   out <- ebam(mat, cl, method=chisq.ebam, approx=TRUE)
##D   out
##D   
##D   # approx is set to TRUE to approximate the null distribution
##D   # by the ChiSquare-distribution (usually, for such a small
##D   # number of observations this might not be a good idea
##D   # as the assumptions behind this approximation might not
##D   # be fulfilled).
##D   
##D   # The same results can also be obtained by employing
##D   # contingency tables, i.e. by specifying data as a list.
##D   # For this, we need to generate the tables summarizing
##D   # groupwise how many observations show which level at
##D   # which variable. These tables can be obtained by
##D   
##D   library(scrime)
##D   cases <- rowTables(mat[, cl==1])
##D   controls <- rowTables(mat[, cl==2])
##D   ltabs <- list(cases, controls)
##D   
##D   # And the same EBAM analysis as above can then be 
##D   # performed by 
##D   
##D   out2 <- ebam(ltabs, method=chisq.ebam, approx=TRUE)
##D   out2
## End(Not run)


