### Name: EBAM-class
### Title: Class EBAM
### Aliases: EBAM-class EBAM show,EBAM-method print,EBAM-method
###   plot,EBAM-method summary,EBAM-method
### Keywords: classes

### ** Examples
## Not run: 
##D   # Load the data of Golub et al. (1999) contained in the package multtest.
##D   data(golub)
##D   
##D   # golub.cl contains the class labels.
##D   golub.cl
##D   
##D   # Perform an EBAM analysis for the two class unpaired case assuming
##D   # unequal variances. Specify the fudge factor a0 by the suggested
##D   # choice of find.a0
##D   find.out <- find.a0(golub, golub.cl, rand = 123)
##D   ebam.out <- ebam(find.out)
##D   ebam.out
##D     
##D   # Obtain the number of differentially
##D   # expressed genes and the FDR if a gene is called differentially
##D   # expressed if its posterior probability is larger than 0.8, 0.85,
##D   # 0.9, 0.95.
##D   print(ebam.out, c(0.8, 0.85, 0.9, 0.95))
##D     
##D   # Generate a plot of the posterior probabilities for delta = 0.9.
##D   plot(ebam.out, 0.9)
##D     
##D   # Obtain the list of genes called differentially expressed if their
##D   # posterior probability is larger than 0.99, and gene-specific 
##D   # statistics for these variables such as their z-value and their
##D   # local FDR.
##D   summary(ebam.out, 0.9)
##D   
## End(Not run)


